/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.keygen;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.CreateException;
import javax.sql.DataSource;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCInsertPKCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCPkSqlCreateCommand
extends JDBCInsertPKCreateCommand {
    protected String pkSQL;
    protected JDBCCMPFieldBridge pkField;

    @Override
    public void init(JDBCStoreManager manager) {
        super.init(manager);
        this.pkField = this.getGeneratedPKField();
    }

    @Override
    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) {
        super.initEntityCommand(entityCommand);
        this.pkSQL = entityCommand.getAttribute("pk-sql");
        if (this.pkSQL == null) {
            throw CmpMessages.MESSAGES.pkSqlMustBeSet(this.entity.getEntityName());
        }
        if (this.debug) {
            this.log.debug((Object)("Generate PK sql is: " + this.pkSQL));
        }
    }

    @Override
    protected void generateFields(CmpEntityBeanContext ctx) throws CreateException {
        super.generateFields(ctx);
        Connection con = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            DataSource dataSource;
            if (this.debug) {
                this.log.debug((Object)("Executing SQL: " + this.pkSQL));
            }
            if (!(rs = (s = (con = (dataSource = this.entity.getDataSource()).getConnection()).createStatement()).executeQuery(this.pkSQL)).next()) {
                throw CmpMessages.MESSAGES.errorFetchingNextPk();
            }
            this.pkField.loadInstanceResults(rs, 1, ctx);
        }
        catch (SQLException e) {
            try {
                throw CmpMessages.MESSAGES.errorFetchingPkValue(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(s);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(s);
        JDBCUtil.safeClose(con);
    }
}

