/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework;

import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.vfs.VirtualFile;

public class StorageState {
    public static final String PROPERTY_BUNDLE_FILE = "BundleFile";
    public static final String PROPERTY_BUNDLE_ID = "BundleId";
    public static final String PROPERTY_BUNDLE_LOCATION = "Location";
    public static final String PROPERTY_BUNDLE_REV = "BundleRev";
    public static final String PROPERTY_LAST_MODIFIED = "LastModified";
    public static final String PROPERTY_PERSISTENTLY_STARTED = "PersistentlyStarted";
    public static final String PROPERTY_ACTIVATION_POLICY_USED = "ActivationPolicyUsed";
    public static final String PROPERTY_START_LEVEL = "StartLevel";
    public static final String BUNDLE_PERSISTENT_PROPERTIES = "bundle-persistent.properties";
    private final File storageDir;
    private final VirtualFile rootFile;
    private final Properties props;
    private final String location;
    private final long bundleId;
    private final int revision;
    static Set<String> requiredProps = new HashSet<String>();

    public StorageState(File storageDir, VirtualFile rootFile, Properties props) {
        assert (storageDir != null) : "Null storageFile";
        assert (props != null) : "Null properties";
        assert (storageDir.isDirectory()) : "Not a directory: " + storageDir;
        for (String key : requiredProps) {
            if (props.get(key) != null) continue;
            throw FrameworkMessages.MESSAGES.illegalArgumentRequiredPropertyMissing(key, storageDir);
        }
        this.storageDir = storageDir;
        this.rootFile = rootFile;
        this.props = props;
        this.location = props.getProperty(PROPERTY_BUNDLE_LOCATION);
        this.bundleId = Long.parseLong(props.getProperty(PROPERTY_BUNDLE_ID));
        this.revision = Integer.parseInt(props.getProperty(PROPERTY_BUNDLE_REV));
    }

    public Properties getProperties() {
        return this.props;
    }

    public File getStorageDir() {
        return this.storageDir;
    }

    public String getLocation() {
        return this.location;
    }

    public VirtualFile getRootFile() {
        return this.rootFile;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public int getRevisionId() {
        return this.revision;
    }

    public long getLastModified() {
        String value = this.props.getProperty(PROPERTY_LAST_MODIFIED);
        return new Long(value);
    }

    public boolean isPersistentlyStarted() {
        String value = this.props.getProperty(PROPERTY_PERSISTENTLY_STARTED);
        return value != null ? new Boolean(value) : false;
    }

    public boolean isBundleActivationPolicyUsed() {
        String value = this.props.getProperty(PROPERTY_ACTIVATION_POLICY_USED);
        return value != null ? new Boolean(value) : false;
    }

    public int getStartLevel() {
        String value = this.props.getProperty(PROPERTY_START_LEVEL);
        return Integer.parseInt(value);
    }

    public String toString() {
        int startlevel = this.getStartLevel();
        return "BundleStorageState[id=" + this.bundleId + ",rev=" + this.revision + ",startlevel=" + startlevel + ",location=" + this.location + "]";
    }

    static {
        requiredProps.add(PROPERTY_BUNDLE_ID);
        requiredProps.add(PROPERTY_BUNDLE_REV);
        requiredProps.add(PROPERTY_BUNDLE_LOCATION);
        requiredProps.add(PROPERTY_START_LEVEL);
        requiredProps.add(PROPERTY_LAST_MODIFIED);
    }
}

