/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.modules.ModuleLoadException;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.resolver.spi.AbstractWiring;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;

class AbstractBundleWiring
extends AbstractWiring
implements BundleWiring {
    AbstractBundleWiring(AbstractBundleRevision brev, List<Wire> wires) {
        super((Resource)brev, wires);
    }

    public boolean isCurrent() {
        return true;
    }

    public boolean isInUse() {
        for (Wire wire : this.getProvidedResourceWires(null)) {
            BundleRevision requirer = (BundleRevision)wire.getRequirer();
            AbstractBundleState importer = AbstractBundleState.assertBundleState(requirer.getBundle());
            if (importer.getState() == 1) continue;
            return true;
        }
        return false;
    }

    public List<BundleCapability> getCapabilities(String namespace) {
        return this.getRevision().getDeclaredCapabilities(namespace);
    }

    public List<BundleRequirement> getRequirements(String namespace) {
        return this.getRevision().getDeclaredRequirements(namespace);
    }

    public List<BundleWire> getProvidedWires(String namespace) {
        throw new UnsupportedOperationException();
    }

    public List<BundleWire> getRequiredWires(String namespace) {
        throw new UnsupportedOperationException();
    }

    public BundleRevision getRevision() {
        return this.getResource();
    }

    public BundleRevision getResource() {
        return (BundleRevision)super.getResource();
    }

    public ClassLoader getClassLoader() {
        try {
            AbstractBundleRevision brev = (AbstractBundleRevision)this.getRevision();
            return brev.getModuleClassLoader();
        }
        catch (ModuleLoadException e) {
            return null;
        }
    }

    public List<URL> findEntries(String path, String filePattern, int options) {
        ArrayList<URL> result = new ArrayList<URL>();
        AbstractBundleRevision brev = (AbstractBundleRevision)this.getRevision();
        Enumeration<URL> entries = brev.findEntries(path, filePattern, options == 1);
        while (entries.hasMoreElements()) {
            result.add(entries.nextElement());
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<String> listResources(String path, String filePattern, int options) {
        throw new UnsupportedOperationException();
    }

    public Bundle getBundle() {
        AbstractBundleRevision brev = (AbstractBundleRevision)this.getRevision();
        return brev.getBundle();
    }
}

