/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.PersistentBundlesComplete;
import org.jboss.osgi.framework.PersistentBundlesHandler;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.StorageState;
import org.jboss.osgi.framework.StorageStateProvider;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.InternalServices;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

final class DefaultPersistentBundlesHandler
extends AbstractPluginService<PersistentBundlesHandler>
implements PersistentBundlesHandler {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleStoragePlugin> injectedBundleStorage = new InjectedValue();
    private final InjectedValue<StorageStateProvider> injectedStorageProvider = new InjectedValue();
    private final InjectedValue<DeploymentFactoryPlugin> injectedDeploymentFactory = new InjectedValue();

    static void addIntegrationService(ServiceRegistry registry, ServiceTarget serviceTarget) {
        if (registry.getService(IntegrationServices.PERSISTENT_BUNDLES_HANDLER) == null) {
            DefaultPersistentBundlesHandler service = new DefaultPersistentBundlesHandler();
            ServiceBuilder builder = serviceTarget.addService(IntegrationServices.PERSISTENT_BUNDLES_HANDLER, (Service)service);
            builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, service.injectedBundleManager);
            builder.addDependency(Services.STORAGE_STATE_PROVIDER, StorageStateProvider.class, service.injectedStorageProvider);
            builder.addDependency(InternalServices.BUNDLE_STORAGE_PLUGIN, BundleStoragePlugin.class, service.injectedBundleStorage);
            builder.addDependency(InternalServices.DEPLOYMENT_FACTORY_PLUGIN, DeploymentFactoryPlugin.class, service.injectedDeploymentFactory);
            builder.addDependencies(new ServiceName[]{Services.FRAMEWORK_CREATE, IntegrationServices.AUTOINSTALL_COMPLETE});
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            builder.install();
        }
    }

    private DefaultPersistentBundlesHandler() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        DeploymentFactoryPlugin deploymentPlugin = (DeploymentFactoryPlugin)((Object)this.injectedDeploymentFactory.getValue());
        StorageStateProvider storageStateProvider = (StorageStateProvider)this.injectedStorageProvider.getValue();
        final HashSet<StorageState> storageStates = new HashSet<StorageState>(storageStateProvider.getStorageStates());
        Iterator iterator = storageStates.iterator();
        while (iterator.hasNext()) {
            StorageState storageState = (StorageState)iterator.next();
            if (bundleManager.getBundleById(storageState.getBundleId()) == null) continue;
            iterator.remove();
        }
        PersistentBundlesComplete installComplete = new PersistentBundlesComplete(){

            @Override
            protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
                return storageStates.size() == trackedServices.size();
            }
        };
        FrameworkLogger.LOGGER.debugf("Installing persistent bundle states: %s", storageStates);
        ServiceBuilder builder = installComplete.install(context.getChildTarget());
        if (storageStates.size() == 0) {
            builder.install();
        } else {
            ServiceListener listener = installComplete.getListener();
            for (StorageState storageState : storageStates) {
                try {
                    Deployment dep = deploymentPlugin.createDeployment(storageState);
                    bundleManager.installBundle(dep, (ServiceListener<Bundle>)listener);
                }
                catch (BundleException ex) {
                    FrameworkLogger.LOGGER.errorStateCannotInstallInitialBundle(ex, storageState.getLocation());
                }
            }
        }
    }

    public PersistentBundlesHandler getValue() throws IllegalStateException {
        return this;
    }
}

