/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.Resource;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.URLResource;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

final class FallbackLoader
implements LocalLoader {
    private static ThreadLocal<Map<String, AtomicInteger>> dynamicLoadAttempts;
    private final HostBundleState hostBundle;
    private final HostBundleRevision hostRev;
    private final ModuleIdentifier identifier;
    private final Set<String> importedPaths;
    private final BundleManagerPlugin bundleManager;
    private final ModuleManagerPlugin moduleManager;

    FallbackLoader(HostBundleRevision hostRev, ModuleIdentifier identifier, Set<String> importedPaths) {
        assert (hostRev != null) : "Null hostRev";
        assert (identifier != null) : "Null identifier";
        assert (importedPaths != null) : "Null importedPaths";
        this.identifier = identifier;
        this.importedPaths = importedPaths;
        this.hostRev = hostRev;
        this.hostBundle = hostRev.getBundleState();
        this.bundleManager = this.hostBundle.getBundleManager();
        this.moduleManager = this.hostBundle.getFrameworkState().getModuleManagerPlugin();
    }

    public Class<?> loadClassLocal(String className, boolean resolve) {
        List<XPackageRequirement> matchingPatterns = this.findMatchingPatterns(className);
        if (matchingPatterns.isEmpty()) {
            return null;
        }
        String pathName = className.replace('.', '/') + ".class";
        Module module = this.findModuleDynamically(pathName, matchingPatterns);
        if (module == null) {
            return null;
        }
        ModuleClassLoader moduleClassLoader = module.getClassLoader();
        try {
            return moduleClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            FrameworkLogger.LOGGER.tracef("Cannot load class [%s] from module: %s", className, module);
            return null;
        }
    }

    public Package loadPackageLocal(String name) {
        throw new UnsupportedOperationException();
    }

    public List<Resource> loadResourceLocal(String resName) {
        List<XPackageRequirement> matchingPatterns;
        if (resName.startsWith("/")) {
            resName = resName.substring(1);
        }
        if ((matchingPatterns = this.findMatchingPatterns(resName)).isEmpty()) {
            return Collections.emptyList();
        }
        Module module = this.findModuleDynamically(resName, matchingPatterns);
        if (module == null) {
            return Collections.emptyList();
        }
        URL resURL = module.getExportedResource(resName);
        if (resURL == null) {
            FrameworkLogger.LOGGER.tracef("Cannot load resource [%s] from module: %s", resName, module);
            return Collections.emptyList();
        }
        return Collections.singletonList(new URLResource(resURL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module findModuleDynamically(String resName, List<XPackageRequirement> matchingPatterns) {
        int idx = resName.lastIndexOf(47);
        if (idx < 0) {
            return null;
        }
        String path = resName.substring(0, idx);
        if (this.importedPaths.contains(path)) {
            return null;
        }
        if (dynamicLoadAttempts == null) {
            dynamicLoadAttempts = new ThreadLocal();
        }
        Map<String, AtomicInteger> mapping = dynamicLoadAttempts.get();
        boolean removeThreadLocalMapping = false;
        try {
            AtomicInteger recursiveDepth;
            if (mapping == null) {
                mapping = new HashMap<String, AtomicInteger>();
                dynamicLoadAttempts.set(mapping);
                removeThreadLocalMapping = true;
            }
            if ((recursiveDepth = mapping.get(resName)) == null) {
                recursiveDepth = new AtomicInteger();
                mapping.put(resName, recursiveDepth);
            }
            if (recursiveDepth.incrementAndGet() == 1) {
                Module module = this.findInResolvedModules(resName, matchingPatterns);
                if (module != null && !module.getIdentifier().equals(this.identifier)) {
                    Module module2 = module;
                    return module2;
                }
                module = this.findInUnresolvedModules(resName, matchingPatterns);
                if (module != null && !module.getIdentifier().equals(this.identifier)) {
                    Module module3 = module;
                    return module3;
                }
            }
        }
        finally {
            if (removeThreadLocalMapping) {
                dynamicLoadAttempts.remove();
            } else {
                AtomicInteger recursiveDepth = mapping.get(resName);
                if (recursiveDepth.decrementAndGet() == 0) {
                    mapping.remove(resName);
                }
            }
        }
        return null;
    }

    private List<XPackageRequirement> findMatchingPatterns(String resName) {
        List<XPackageRequirement> dynamicRequirements = this.getDynamicPackageRequirements(this.hostRev);
        String pathName = VFSUtils.getPathFromClassName((String)resName);
        List<XPackageCapability> packageCapabilities = this.getPackageCapabilities(this.hostRev);
        for (XPackageCapability packageCap : packageCapabilities) {
            String packagePath = packageCap.getPackageName().replace('.', '/');
            if (!pathName.equals(packagePath)) continue;
            return Collections.emptyList();
        }
        ArrayList<XPackageRequirement> foundMatch = new ArrayList<XPackageRequirement>();
        for (XPackageRequirement dynreq : dynamicRequirements) {
            String pattern = dynreq.getPackageName();
            if (pattern.equals("*")) {
                foundMatch.add(dynreq);
                continue;
            }
            String patternPath = this.getPatternPath(pattern);
            if (!pathName.startsWith(patternPath)) continue;
            foundMatch.add(dynreq);
        }
        if (!foundMatch.isEmpty()) {
            FrameworkLogger.LOGGER.tracef("Found match for path [%s] with Dynamic-ImportPackage pattern: %s", resName, foundMatch);
        } else {
            FrameworkLogger.LOGGER.tracef("Class [%s] does not match Dynamic-ImportPackage patterns", resName);
        }
        return foundMatch;
    }

    private Module findInResolvedModules(String resName, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in resolved modules ...", new Object[0]);
        for (XPackageRequirement pkgreq : matchingPatterns) {
            for (Bundle bundle2 : this.bundleManager.getBundles(36)) {
                ModuleIdentifier identifier;
                Module candidate;
                AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
                if (!bundleState.isResolved() || bundleState.isFragment() || !this.isValidCandidate(resName, pkgreq, candidate = this.moduleManager.getModule(identifier = bundleState.getModuleIdentifier()))) continue;
                return candidate;
            }
        }
        return null;
    }

    private Module findInUnresolvedModules(String resName, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in unresolved modules ...", new Object[0]);
        for (Bundle bundle2 : this.bundleManager.getBundles()) {
            if (bundle2.getState() != 2) continue;
            AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
            bundleState.ensureResolved(false);
        }
        return this.findInResolvedModules(resName, matchingPatterns);
    }

    private boolean isValidCandidate(String resName, XPackageRequirement pkgreq, Module candidate) {
        if (candidate == null) {
            return false;
        }
        ModuleIdentifier candidateId = candidate.getIdentifier();
        if (candidateId.equals(this.identifier)) {
            return false;
        }
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically [%s] in %s ...", resName, candidateId);
        URL resURL = candidate.getExportedResource(resName);
        if (resURL == null) {
            return false;
        }
        FrameworkLogger.LOGGER.tracef("Found path [%s] in %s", resName, candidate);
        BundleRevision brev = this.moduleManager.getBundleRevision(candidateId);
        XPackageCapability candidateCap = this.getCandidateCapability(brev, pkgreq);
        return candidateCap != null;
    }

    private XPackageCapability getCandidateCapability(BundleRevision brev, XPackageRequirement packageReq) {
        for (XPackageCapability packageCap : this.getPackageCapabilities(brev)) {
            if (!packageReq.matches((XCapability)packageCap)) continue;
            FrameworkLogger.LOGGER.tracef("Matching package capability: %s", packageCap);
            return packageCap;
        }
        return null;
    }

    private String getPatternPath(String pattern) {
        String patternPath = pattern;
        if (pattern.endsWith(".*")) {
            patternPath = pattern.substring(0, pattern.length() - 2);
        }
        patternPath = patternPath.replace('.', '/');
        return patternPath;
    }

    private List<XPackageCapability> getPackageCapabilities(BundleRevision brev) {
        ArrayList<XPackageCapability> result = new ArrayList<XPackageCapability>();
        for (Capability aux : brev.getCapabilities("osgi.wiring.package")) {
            XPackageCapability cap = (XPackageCapability)aux;
            result.add(cap);
        }
        return result;
    }

    private List<XPackageRequirement> getDynamicPackageRequirements(BundleRevision brev) {
        ArrayList<XPackageRequirement> result = new ArrayList<XPackageRequirement>();
        for (Requirement aux : brev.getRequirements("osgi.wiring.package")) {
            XPackageRequirement req = (XPackageRequirement)aux;
            if (!req.isDynamic()) continue;
            result.add(req);
        }
        return result;
    }
}

