/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.BundleInstallHandler;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.SystemServicesProvider;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;

public final class FrameworkCoreServices
extends AbstractPluginService<FrameworkCoreServices> {
    private final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();
    private final InjectedValue<BundleInstallHandler> injectedInstallProvider = new InjectedValue();
    private final InjectedValue<LifecycleInterceptorPlugin> injectedLifecycleInterceptor = new InjectedValue();
    private final InjectedValue<PackageAdmin> injectedPackageAdmin = new InjectedValue();
    private final InjectedValue<StartLevelPlugin> injectedStartLevel = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<SystemServicesProvider> injectedServicesProvider = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        FrameworkCoreServices service = new FrameworkCoreServices();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.FRAMEWORK_CORE_SERVICES, (Service)service);
        builder.addDependency(IntegrationServices.BUNDLE_INSTALL_HANDLER, BundleInstallHandler.class, service.injectedInstallProvider);
        builder.addDependency(Services.FRAMEWORK_CREATE, FrameworkState.class, service.injectedFramework);
        builder.addDependency(InternalServices.LIFECYCLE_INTERCEPTOR_PLUGIN, LifecycleInterceptorPlugin.class, service.injectedLifecycleInterceptor);
        builder.addDependency(Services.PACKAGE_ADMIN, PackageAdmin.class, service.injectedPackageAdmin);
        builder.addDependency(Services.START_LEVEL, StartLevelPlugin.class, service.injectedStartLevel);
        builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.addDependency(IntegrationServices.SYSTEM_SERVICES_PROVIDER, SystemServicesProvider.class, service.injectedServicesProvider);
        builder.addDependencies(new ServiceName[]{InternalServices.URL_HANDLER_PLUGIN, InternalServices.WEBXML_VERIFIER_PLUGIN});
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private FrameworkCoreServices() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        SystemServicesProvider servicesProvider = (SystemServicesProvider)this.injectedServicesProvider.getValue();
        servicesProvider.registerSystemServices(systemContext);
        this.getFrameworkState().injectedCoreServices.inject((Object)this);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.getFrameworkState().injectedCoreServices.uninject();
    }

    public FrameworkCoreServices getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    BundleInstallHandler getInstallHandler() {
        return (BundleInstallHandler)this.injectedInstallProvider.getValue();
    }

    FrameworkState getFrameworkState() {
        return (FrameworkState)this.injectedFramework.getValue();
    }

    LifecycleInterceptorPlugin getLifecycleInterceptorPlugin() {
        return (LifecycleInterceptorPlugin)((Object)this.injectedLifecycleInterceptor.getValue());
    }

    PackageAdmin getPackageAdmin() {
        return (PackageAdmin)this.injectedPackageAdmin.getValue();
    }

    StartLevelPlugin getStartLevel() {
        return (StartLevelPlugin)((Object)this.injectedStartLevel.getValue());
    }
}

