/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.framework.FutureServiceValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkBuilder;
import org.jboss.osgi.framework.internal.FrameworkCoreServices;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;

final class FrameworkProxy
implements Framework {
    private final AtomicInteger proxyState;
    private final FrameworkBuilder frameworkBuilder;
    private LenientShutdownContainer lenientContainer;
    private final AtomicBoolean frameworkStopped;
    private FrameworkState frameworkState;
    private boolean firstInit;
    private int stoppedEvent;

    FrameworkProxy(FrameworkBuilder frameworkBuilder) {
        this.frameworkBuilder = frameworkBuilder;
        this.stoppedEvent = 64;
        this.proxyState = new AtomicInteger(2);
        this.frameworkStopped = new AtomicBoolean(false);
        this.firstInit = true;
    }

    public long getBundleId() {
        return 0L;
    }

    public String getSymbolicName() {
        return "system.bundle";
    }

    public String getLocation() {
        return "System Bundle";
    }

    public Version getVersion() {
        return Version.emptyVersion;
    }

    public void init() throws BundleException {
        int state = this.getState();
        if (state == 8 || state == 32 || state == 16) {
            return;
        }
        FrameworkLogger.LOGGER.debugf("Init framework", new Object[0]);
        try {
            this.frameworkStopped.set(false);
            boolean allowContainerShutdown = false;
            ServiceContainer serviceContainer = this.frameworkBuilder.getServiceContainer();
            if (serviceContainer == null) {
                serviceContainer = ServiceContainer.Factory.create();
                allowContainerShutdown = true;
            }
            this.lenientContainer = new LenientShutdownContainer(serviceContainer, allowContainerShutdown);
            ServiceTarget serviceTarget = this.frameworkBuilder.getServiceTarget();
            if (serviceTarget == null) {
                serviceTarget = serviceContainer.subTarget();
            }
            this.frameworkBuilder.createFrameworkServicesInternal((ServiceRegistry)serviceContainer, serviceTarget, this.firstInit);
            this.proxyState.set(8);
            this.frameworkState = this.awaitFrameworkInit();
            this.firstInit = false;
        }
        catch (Exception ex) {
            throw FrameworkMessages.MESSAGES.bundleCannotInitializeFramework(ex);
        }
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int options) throws BundleException {
        if (this.getState() != 8) {
            this.init();
        }
        FrameworkLogger.LOGGER.debugf("start framework", new Object[0]);
        try {
            this.awaitFrameworkActive();
            this.proxyState.set(32);
        }
        catch (Exception ex) {
            throw FrameworkMessages.MESSAGES.bundleCannotStartFramework(ex);
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void stop(int options) throws BundleException {
        this.stopInternal(false);
    }

    private void stopInternal(boolean stopForUpdate) {
        int state = this.getState();
        if (state != 8 && state != 32) {
            return;
        }
        FrameworkLogger.LOGGER.debugf("stop framework", new Object[0]);
        FrameworkCoreServices coreServices = this.frameworkState.getCoreServices();
        SystemBundleState systemBundle = this.frameworkState.getSystemBundle();
        this.stoppedEvent = stopForUpdate ? 128 : 64;
        systemBundle.changeState(16);
        this.proxyState.set(16);
        StartLevelPlugin startLevel = coreServices.getStartLevel();
        if (startLevel != null) {
            startLevel.decreaseStartLevel(0);
        } else {
            BundleManagerPlugin bundleManager = systemBundle.getBundleManager();
            for (Bundle bundle2 : bundleManager.getBundles()) {
                if (bundle2.getBundleId() == 0L) continue;
                try {
                    bundle2.stop(1);
                }
                catch (Exception ex) {
                    AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
                    bundleManager.fireFrameworkError(bundleState, "stopping bundle", ex);
                }
            }
        }
        this.lenientContainer.shutdown();
        this.proxyState.set(4);
    }

    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        if (this.lenientContainer == null) {
            return new FrameworkEvent(64, (Bundle)this, null);
        }
        LenientShutdownContainer localContainer = this.lenientContainer;
        localContainer.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        if (!localContainer.isShutdownComplete()) {
            return new FrameworkEvent(512, (Bundle)this, null);
        }
        return new FrameworkEvent(this.stoppedEvent, (Bundle)this, null);
    }

    public void update(InputStream input) throws BundleException {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.update();
    }

    public void update() {
        int state = this.getState();
        if (state != 8 && state != 32) {
            return;
        }
        FrameworkLogger.LOGGER.debugf("update framework", new Object[0]);
        final int targetState = this.getState();
        Runnable cmd = new Runnable(){

            @Override
            public void run() {
                try {
                    FrameworkProxy.this.stopInternal(true);
                    if (targetState == 8) {
                        FrameworkProxy.this.init();
                    }
                    if (targetState == 32) {
                        FrameworkProxy.this.start();
                    }
                }
                catch (Exception ex) {
                    FrameworkLogger.LOGGER.errorCannotUpdateFramework(ex);
                }
            }
        };
        new Thread(cmd, "Framework update thread").run();
    }

    public void uninstall() throws BundleException {
        throw FrameworkMessages.MESSAGES.bundleCannotUninstallSystemBundle();
    }

    public int getState() {
        return this.proxyState.get();
    }

    public Dictionary<String, String> getHeaders() {
        this.assertNotStopped();
        return this.getSystemBundle().getHeaders();
    }

    public ServiceReference[] getRegisteredServices() {
        this.assertNotStopped();
        return this.getSystemBundle().getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        this.assertNotStopped();
        return this.getSystemBundle().getServicesInUse();
    }

    public boolean hasPermission(Object permission) {
        this.assertNotStopped();
        return this.getSystemBundle().hasPermission(permission);
    }

    public URL getResource(String name) {
        this.assertNotStopped();
        return this.getSystemBundle().getResource(name);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        this.assertNotStopped();
        return this.getSystemBundle().getHeaders(locale);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.assertNotStopped();
        return this.getSystemBundle().loadClass(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        this.assertNotStopped();
        return this.getSystemBundle().getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        this.assertNotStopped();
        return this.getSystemBundle().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        this.assertNotStopped();
        return this.getSystemBundle().getEntry(path);
    }

    public long getLastModified() {
        this.assertNotStopped();
        return this.getSystemBundle().getLastModified();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        this.assertNotStopped();
        return this.getSystemBundle().findEntries(path, filePattern, recurse);
    }

    public BundleContext getBundleContext() {
        return this.isNotStopped() ? this.getSystemBundle().getBundleContext() : null;
    }

    public Map getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException();
    }

    private boolean isNotStopped() {
        boolean serviceContainerActive = this.lenientContainer != null && !this.lenientContainer.isShutdownInitiated();
        return serviceContainerActive && !this.frameworkStopped.get();
    }

    private void assertNotStopped() {
        if (!this.isNotStopped()) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkAlreadyStopped();
        }
    }

    private SystemBundleState getSystemBundle() {
        if (this.frameworkState == null) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkNotInitialized();
        }
        return this.frameworkState.getSystemBundle();
    }

    private FrameworkState awaitFrameworkInit() throws ExecutionException, TimeoutException {
        ServiceController<?> controller = this.lenientContainer.getRequiredService(Services.FRAMEWORK_INIT);
        final String serviceName = controller.getName().getCanonicalName();
        controller.addListener((ServiceListener)new AbstractServiceListener<FrameworkState>(){

            public void transition(ServiceController<? extends FrameworkState> controller, ServiceController.Transition transition) {
                FrameworkLogger.LOGGER.tracef("awaitFrameworkInit %s => %s", serviceName, transition);
                switch (transition) {
                    case STARTING_to_START_FAILED: 
                    case STOPPING_to_DOWN: {
                        controller.removeListener((ServiceListener)this);
                        FrameworkProxy.this.frameworkStopped.set(true);
                        FrameworkProxy.this.frameworkState = null;
                    }
                }
            }
        });
        controller.setMode(ServiceController.Mode.ACTIVE);
        FutureServiceValue future = new FutureServiceValue(controller);
        Integer timeout = (Integer)this.frameworkBuilder.getProperty("org.jboss.osgi.framework.init.timeout", 5000);
        return (FrameworkState)future.get(timeout.intValue(), TimeUnit.MILLISECONDS);
    }

    private void awaitFrameworkActive() throws ExecutionException, TimeoutException {
        ServiceController<?> controller = this.lenientContainer.getRequiredService(Services.FRAMEWORK_ACTIVE);
        controller.setMode(ServiceController.Mode.ACTIVE);
        FutureServiceValue future = new FutureServiceValue(controller);
        Integer timeout = (Integer)this.frameworkBuilder.getProperty("org.jboss.osgi.framework.start.timeout", 10000);
        future.get(timeout.intValue(), TimeUnit.MILLISECONDS);
    }

    static class LenientShutdownContainer {
        private final ServiceContainer serviceContainer;
        private final AtomicBoolean shutdownInitiated;
        private final boolean allowContainerShutdown;

        LenientShutdownContainer(ServiceContainer serviceContainer, boolean allowContainerShutdown) {
            this.serviceContainer = serviceContainer;
            this.allowContainerShutdown = allowContainerShutdown;
            this.shutdownInitiated = new AtomicBoolean(false);
        }

        ServiceController<?> getRequiredService(ServiceName serviceName) {
            return this.serviceContainer.getRequiredService(serviceName);
        }

        boolean isShutdownInitiated() {
            return this.shutdownInitiated.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            if (this.allowContainerShutdown) {
                this.serviceContainer.shutdown();
                AtomicBoolean atomicBoolean = this.shutdownInitiated;
                synchronized (atomicBoolean) {
                    this.shutdownInitiated.set(true);
                    FrameworkLogger.LOGGER.debugf("shutdownInitiated.notifyAll", new Object[0]);
                    this.shutdownInitiated.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            FrameworkLogger.LOGGER.debugf("awaitTermination", new Object[0]);
            AtomicBoolean atomicBoolean = this.shutdownInitiated;
            synchronized (atomicBoolean) {
                if (!this.shutdownInitiated.get()) {
                    FrameworkLogger.LOGGER.debugf("shutdownInitiated.wait", new Object[0]);
                    this.shutdownInitiated.wait(2000L);
                }
            }
            this.serviceContainer.awaitTermination(timeout, unit);
        }

        boolean isShutdownComplete() {
            return this.serviceContainer.isShutdownComplete();
        }
    }
}

