/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.ModuleLoaderProvider;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.SystemPathsProvider;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FallbackLoader;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.HostBundleClassLoader;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.NativeResourceLoader;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.RevisionContentResourceLoader;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.metadata.NativeLibrary;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.XBundleRequirement;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;

final class ModuleManagerPlugin
extends AbstractPluginService<ModuleManagerPlugin> {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<SystemPathsProvider> injectedSystemPaths = new InjectedValue();
    private final InjectedValue<ModuleLoaderProvider> injectedModuleLoader = new InjectedValue();
    private Map<ModuleIdentifier, BundleRevision> modules = new ConcurrentHashMap<ModuleIdentifier, BundleRevision>();

    static void addService(ServiceTarget serviceTarget) {
        ModuleManagerPlugin service = new ModuleManagerPlugin();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.MODULE_MANGER_PLUGIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, service.injectedBundleManager);
        builder.addDependency(IntegrationServices.MODULE_LOADER_PROVIDER, ModuleLoaderProvider.class, service.injectedModuleLoader);
        builder.addDependency(IntegrationServices.SYSTEM_PATHS_PROVIDER, SystemPathsProvider.class, service.injectedSystemPaths);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private ModuleManagerPlugin() {
    }

    public ModuleManagerPlugin getValue() {
        return this;
    }

    ModuleLoaderProvider getModuleLoaderIntegration() {
        return (ModuleLoaderProvider)this.injectedModuleLoader.getValue();
    }

    ModuleLoader getModuleLoader() {
        return this.getModuleLoaderIntegration().getModuleLoader();
    }

    ModuleIdentifier getModuleIdentifier(XResource res) {
        assert (res != null) : "Null resource";
        assert (!res.isFragment()) : "A fragment is not a module";
        ModuleIdentifier identifier = (ModuleIdentifier)res.getAttachment(ModuleIdentifier.class);
        if (identifier != null) {
            return identifier;
        }
        XIdentityCapability icap = res.getIdentityCapability();
        Module module = (Module)res.getAttachment(Module.class);
        if (module != null) {
            identifier = module.getIdentifier();
        } else if ("system.bundle".equals(icap.getSymbolicName())) {
            identifier = this.getFrameworkModule().getIdentifier();
        } else {
            int revision = res instanceof AbstractBundleRevision ? ((AbstractBundleRevision)res).getRevisionId() : 0;
            identifier = this.getModuleLoaderIntegration().getModuleIdentifier(res, revision);
        }
        res.addAttachment(ModuleIdentifier.class, (Object)identifier);
        return identifier;
    }

    Module getModule(ModuleIdentifier identifier) {
        try {
            return this.getModuleLoader().loadModule(identifier);
        }
        catch (ModuleLoadException ex) {
            return null;
        }
    }

    BundleRevision getBundleRevision(ModuleIdentifier identifier) {
        return this.modules.get(identifier);
    }

    AbstractBundleState getBundleState(Class<?> clazz) {
        assert (clazz != null) : "Null clazz";
        AbstractBundleState result = null;
        ClassLoader loader = clazz.getClassLoader();
        if (loader instanceof BundleReference) {
            BundleReference bundleRef = (BundleReference)loader;
            result = AbstractBundleState.assertBundleState(bundleRef.getBundle());
        }
        if (result == null) {
            FrameworkLogger.LOGGER.debugf("Cannot obtain bundle for: %s", clazz.getName());
        }
        return result;
    }

    ModuleIdentifier addModule(XResource res, List<Wire> wires) {
        ModuleIdentifier identifier;
        assert (res != null) : "Null res";
        assert (wires != null) : "Null wires";
        assert (!res.isFragment()) : "Fragments cannot be added: " + res;
        Module module = (Module)res.getAttachment(Module.class);
        if (module != null) {
            this.getModuleLoaderIntegration().addModule(module);
            return module.getIdentifier();
        }
        XIdentityCapability icap = res.getIdentityCapability();
        if ("system.bundle".equals(icap.getSymbolicName())) {
            identifier = this.getFrameworkModule().getIdentifier();
        } else {
            HostBundleRevision hostRev = HostBundleRevision.assertHostRevision((Resource)res);
            identifier = this.createHostModule(hostRev, wires);
        }
        return identifier;
    }

    private ModuleIdentifier createHostModule(HostBundleRevision hostRev, List<Wire> wires) {
        HostBundleState hostBundle = hostRev.getBundleState();
        List<RevisionContent> contentRoots = hostBundle.getContentRoots();
        ModuleIdentifier identifier = this.getModuleIdentifier((XResource)hostRev);
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)identifier);
        ArrayList<DependencySpec> moduleDependencies = new ArrayList<DependencySpec>();
        SystemPathsProvider plugin = (SystemPathsProvider)this.injectedSystemPaths.getValue();
        Set<String> bootPaths = plugin.getBootDelegationPaths();
        PathFilter bootFilter = plugin.getBootDelegationFilter();
        PathFilter acceptAll = PathFilters.acceptAll();
        moduleDependencies.add(DependencySpec.createSystemDependencySpec((PathFilter)bootFilter, (PathFilter)acceptAll, bootPaths));
        LinkedHashMap<XResource, ModuleDependencyHolder> specHolderMap = new LinkedHashMap<XResource, ModuleDependencyHolder>();
        this.processModuleWireList(wires, specHolderMap);
        HashSet allPaths = new HashSet();
        for (ModuleDependencyHolder holder : specHolderMap.values()) {
            moduleDependencies.add(holder.create());
        }
        for (DependencySpec dep : moduleDependencies) {
            specBuilder.addDependency(dep);
        }
        for (RevisionContent revContent : contentRoots) {
            RevisionContentResourceLoader resLoader = new RevisionContentResourceLoader(revContent);
            specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resLoader));
            allPaths.addAll(resLoader.getPaths());
        }
        Set<FragmentBundleRevision> fragRevs = hostRev.getAttachedFragments();
        for (FragmentBundleRevision fragRev : fragRevs) {
            for (RevisionContent revContent : fragRev.getContentList()) {
                RevisionContentResourceLoader resLoader = new RevisionContentResourceLoader(revContent);
                specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resLoader));
                allPaths.addAll(resLoader.getPaths());
            }
        }
        HashSet<String> importedPaths = new HashSet<String>();
        for (ModuleDependencyHolder holder : specHolderMap.values()) {
            Set<String> paths = holder.getImportPaths();
            if (paths == null) continue;
            importedPaths.addAll(paths);
        }
        PathFilter importFilter = acceptAll;
        PathFilter exportFilter = acceptAll;
        if (!importedPaths.isEmpty()) {
            importFilter = PathFilters.not((PathFilter)PathFilters.in(importedPaths));
        }
        PathFilter resImportFilter = PathFilters.acceptAll();
        PathFilter resExportFilter = PathFilters.acceptAll();
        ClassFilter classImportFilter = new ClassFilter(){

            public boolean accept(String className) {
                return true;
            }
        };
        final PathFilter cefPath = this.getExportClassFilter((XResource)hostRev);
        ClassFilter classExportFilter = new ClassFilter(){

            public boolean accept(String className) {
                return cefPath.accept(className);
            }
        };
        FrameworkLogger.LOGGER.tracef("createLocalDependencySpec: [if=%s,ef=%s,rif=%s,ref=%s,cf=%s]", new Object[]{importFilter, exportFilter, resImportFilter, resExportFilter, cefPath});
        DependencySpec localDep = DependencySpec.createLocalDependencySpec((PathFilter)importFilter, (PathFilter)exportFilter, (PathFilter)resImportFilter, (PathFilter)resExportFilter, (ClassFilter)classImportFilter, (ClassFilter)classExportFilter);
        specBuilder.addDependency(localDep);
        this.addNativeResourceLoader(hostRev, specBuilder);
        PathFilter lazyActivationFilter = this.getLazyPackagesFilter(hostBundle);
        specBuilder.setModuleClassLoaderFactory((ModuleClassLoaderFactory)new HostBundleClassLoader.Factory(hostBundle, lazyActivationFilter));
        specBuilder.setFallbackLoader((LocalLoader)new FallbackLoader(hostRev, identifier, importedPaths));
        ModuleSpec moduleSpec = specBuilder.create();
        this.modules.put(identifier, hostRev);
        this.getModuleLoaderIntegration().addModule(moduleSpec);
        return identifier;
    }

    private void processModuleWireList(List<Wire> wires, Map<XResource, ModuleDependencyHolder> depBuilderMap) {
        XResource exporter;
        ArrayList<Wire> bundleWires = new ArrayList<Wire>();
        ArrayList<Wire> packageWires = new ArrayList<Wire>();
        for (Wire wire : wires) {
            Requirement req = wire.getRequirement();
            XResource importer = (XResource)wire.getRequirer();
            exporter = (XResource)wire.getProvider();
            if (exporter == importer) continue;
            if (req instanceof XPackageRequirement) {
                packageWires.add(wire);
                continue;
            }
            if (!(req instanceof XBundleRequirement)) continue;
            bundleWires.add(wire);
        }
        HashSet<String> importedPaths = new HashSet<String>();
        HashSet<XResource> packageExporters = new HashSet<XResource>();
        for (Wire wire : packageWires) {
            exporter = (XResource)wire.getProvider();
            packageExporters.add(exporter);
            XPackageRequirement req = (XPackageRequirement)wire.getRequirement();
            ModuleDependencyHolder holder = this.getDependencyHolder(depBuilderMap, exporter);
            String path = VFSUtils.getPathFromPackageName((String)req.getPackageName());
            holder.setOptional(req.isOptional());
            holder.addImportPath(path);
            importedPaths.add(path);
        }
        PathFilter importedPathsFilter = PathFilters.in(importedPaths);
        for (Wire wire : bundleWires) {
            XResource exporter2 = (XResource)wire.getProvider();
            if (packageExporters.contains(exporter2)) continue;
            XBundleRequirement req = (XBundleRequirement)wire.getRequirement();
            ModuleDependencyHolder holder = this.getDependencyHolder(depBuilderMap, exporter2);
            holder.setImportFilter(PathFilters.not((PathFilter)importedPathsFilter));
            holder.setOptional(req.isOptional());
            boolean reexport = "reexport".equals(req.getVisibility());
            if (!reexport) continue;
            HashSet<String> exportedPaths = new HashSet<String>();
            for (Capability auxcap : exporter2.getCapabilities("osgi.wiring.package")) {
                XPackageCapability packcap = (XPackageCapability)auxcap;
                String path = packcap.getPackageName().replace('.', '/');
                if (importedPaths.contains(path)) continue;
                exportedPaths.add(path);
            }
            PathFilter exportedPathsFilter = PathFilters.in(exportedPaths);
            holder.setImportFilter(exportedPathsFilter);
            holder.setExportFilter(exportedPathsFilter);
        }
    }

    private PathFilter getExportClassFilter(XResource resModule) {
        PathFilter includeFilter = null;
        PathFilter excludeFilter = null;
        for (Capability auxcap : resModule.getCapabilities("osgi.wiring.package")) {
            String excludeDirective;
            XPackageCapability packageCap = (XPackageCapability)auxcap;
            String includeDirective = packageCap.getDirective("include");
            if (includeDirective != null) {
                String packageName = packageCap.getPackageName();
                String[] patterns = includeDirective.split(",");
                ArrayList<PathFilter> includes = new ArrayList<PathFilter>();
                for (String pattern : patterns) {
                    includes.add(PathFilters.match((String)(packageName + "." + pattern)));
                }
                includeFilter = PathFilters.any(includes);
            }
            if ((excludeDirective = packageCap.getDirective("exclude")) == null) continue;
            String packageName = packageCap.getPackageName();
            String[] patterns = excludeDirective.split(",");
            ArrayList<PathFilter> excludes = new ArrayList<PathFilter>();
            for (String pattern : patterns) {
                excludes.add(PathFilters.match((String)(packageName + "." + pattern)));
            }
            excludeFilter = PathFilters.not((PathFilter)PathFilters.any(excludes));
        }
        if (includeFilter == null && excludeFilter == null) {
            return PathFilters.acceptAll();
        }
        if (includeFilter == null) {
            includeFilter = PathFilters.acceptAll();
        }
        if (excludeFilter == null) {
            excludeFilter = PathFilters.rejectAll();
        }
        return PathFilters.all((PathFilter[])new PathFilter[]{includeFilter, excludeFilter});
    }

    private PathFilter getLazyPackagesFilter(HostBundleState hostBundle) {
        PathFilter result = PathFilters.acceptAll();
        ActivationPolicyMetaData activationPolicy = hostBundle.getActivationPolicy();
        if (activationPolicy != null) {
            List excludes;
            List includes = activationPolicy.getIncludes();
            if (includes != null) {
                HashSet<String> paths = new HashSet<String>();
                for (String packageName : includes) {
                    paths.add(packageName.replace('.', '/'));
                }
                result = PathFilters.in(paths);
            }
            if ((excludes = activationPolicy.getExcludes()) != null) {
                HashSet<String> paths = new HashSet<String>();
                for (String packageName : excludes) {
                    paths.add(packageName.replace('.', '/'));
                }
                result = includes != null ? PathFilters.all((PathFilter[])new PathFilter[]{result, PathFilters.not((PathFilter)PathFilters.in(paths))}) : PathFilters.not((PathFilter)PathFilters.in(paths));
            }
        }
        return result;
    }

    private void addNativeResourceLoader(HostBundleRevision hostrev, ModuleSpec.Builder specBuilder) {
        Deployment deployment = hostrev.getDeployment();
        this.addNativeResourceLoader(specBuilder, hostrev, deployment);
        if (hostrev instanceof HostBundleRevision) {
            for (FragmentBundleRevision fragRev : hostrev.getAttachedFragments()) {
                this.addNativeResourceLoader(specBuilder, hostrev, fragRev.getDeployment());
            }
        }
    }

    private void addNativeResourceLoader(ModuleSpec.Builder specBuilder, HostBundleRevision hostrev, Deployment deployment) {
        NativeLibraryMetaData libMetaData = (NativeLibraryMetaData)deployment.getAttachment(NativeLibraryMetaData.class);
        if (libMetaData != null) {
            NativeResourceLoader nativeLoader = new NativeResourceLoader();
            for (NativeLibrary library : libMetaData.getNativeLibraries()) {
                String libpath = library.getLibraryPath();
                String libfile = new File(libpath).getName();
                String libname = libfile.substring(0, libfile.lastIndexOf(46));
                NativeCodePlugin.BundleNativeLibraryProvider libProvider = new NativeCodePlugin.BundleNativeLibraryProvider(hostrev, libname, libpath);
                nativeLoader.addNativeLibrary(libProvider);
                if (!libname.startsWith("lib")) continue;
                libname = libname.substring(3);
                libProvider = new NativeCodePlugin.BundleNativeLibraryProvider(hostrev, libname, libpath);
                nativeLoader.addNativeLibrary(libProvider);
            }
            specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)nativeLoader));
        }
    }

    private ModuleDependencyHolder getDependencyHolder(Map<XResource, ModuleDependencyHolder> depBuilderMap, XResource exporter) {
        ModuleIdentifier exporterId = this.getModuleIdentifier(exporter);
        ModuleDependencyHolder holder = depBuilderMap.get(exporter);
        if (holder == null) {
            holder = new ModuleDependencyHolder(exporterId);
            depBuilderMap.put(exporter, holder);
        }
        return holder;
    }

    Module loadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (this.getFrameworkModule().getIdentifier().equals(identifier)) {
            return this.getFrameworkModule();
        }
        return this.getModuleLoader().loadModule(identifier);
    }

    void removeModule(ModuleIdentifier identifier) {
        this.modules.remove(identifier);
        this.getModuleLoaderIntegration().removeModule(identifier);
    }

    private Module getFrameworkModule() {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        return bundleManager.getSystemBundle().getFrameworkModule();
    }

    private class ModuleDependencyHolder {
        private DependencySpec dependencySpec;
        private ModuleIdentifier identifier;
        private Set<String> importPaths;
        private PathFilter importFilter;
        private PathFilter exportFilter;
        private boolean optional;

        ModuleDependencyHolder(ModuleIdentifier identifier) {
            this.identifier = identifier;
        }

        void addImportPath(String path) {
            this.assertNotCreated();
            if (this.importPaths == null) {
                this.importPaths = new HashSet<String>();
            }
            this.importPaths.add(path);
        }

        Set<String> getImportPaths() {
            return this.importPaths;
        }

        void setImportFilter(PathFilter importFilter) {
            this.assertNotCreated();
            this.importFilter = importFilter;
        }

        void setExportFilter(PathFilter exportFilter) {
            this.assertNotCreated();
            this.exportFilter = exportFilter;
        }

        void setOptional(boolean optional) {
            this.assertNotCreated();
            this.optional = optional;
        }

        DependencySpec create() {
            Module frameworkModule;
            if (this.exportFilter == null) {
                this.exportFilter = PathFilters.rejectAll();
            }
            if (this.importFilter == null) {
                this.importFilter = this.importPaths != null ? PathFilters.in(this.importPaths) : PathFilters.acceptAll();
            }
            ModuleLoader depLoader = (frameworkModule = ModuleManagerPlugin.this.getFrameworkModule()).getIdentifier().equals(this.identifier) ? frameworkModule.getModuleLoader() : ModuleManagerPlugin.this.getModuleLoader();
            FrameworkLogger.LOGGER.tracef("createModuleDependencySpec: [id=%s,if=%s,ef=%s,loader=%s,optional=%s]", new Object[]{this.identifier, this.importFilter, this.exportFilter, depLoader, this.optional});
            return DependencySpec.createModuleDependencySpec((PathFilter)this.importFilter, (PathFilter)this.exportFilter, (ModuleLoader)depLoader, (ModuleIdentifier)this.identifier, (boolean)this.optional);
        }

        private void assertNotCreated() {
            assert (this.dependencySpec == null) : "DependencySpec already created";
        }
    }
}

