/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.felix.StatelessResolver;
import org.osgi.framework.BundleException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

final class ResolverPlugin
extends AbstractPluginService<ResolverPlugin> {
    private final InjectedValue<NativeCodePlugin> injectedNativeCode = new InjectedValue();
    private final InjectedValue<ModuleManagerPlugin> injectedModuleManager = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private XResolver resolver;

    static void addService(ServiceTarget serviceTarget) {
        ResolverPlugin service = new ResolverPlugin();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.RESOLVER_PLUGIN, (Service)service);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, service.injectedEnvironment);
        builder.addDependency(InternalServices.NATIVE_CODE_PLUGIN, NativeCodePlugin.class, service.injectedNativeCode);
        builder.addDependency(InternalServices.MODULE_MANGER_PLUGIN, ModuleManagerPlugin.class, service.injectedModuleManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private ResolverPlugin() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        this.resolver = new StatelessResolver();
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.resolver = null;
    }

    public ResolverPlugin getValue() {
        return this;
    }

    Map<Resource, List<Wire>> resolve(Collection<? extends Resource> mandatory, Collection<? extends Resource> optional) throws ResolutionException {
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        Collection<Resource> manres = this.filterSingletons(mandatory);
        Collection<Resource> optres = this.appendOptionalFragments(mandatory, optional);
        XResolveContext context = this.resolver.createResolverContext(env, manres, optres);
        return this.resolver.resolve((ResolveContext)context);
    }

    synchronized void resolveAndApply(Collection<? extends Resource> mandatory, Collection<? extends Resource> optional) throws ResolutionException {
        Map<Resource, List<Wire>> wiremap = this.resolve(mandatory, optional);
        for (Map.Entry<Resource, Wiring> entry : this.applyResolverResults(wiremap).entrySet()) {
            XResource res = (XResource)entry.getKey();
            res.addAttachment(Wiring.class, (Object)entry.getValue());
        }
    }

    private Collection<Resource> appendOptionalFragments(Collection<? extends Resource> mandatory, Collection<? extends Resource> optional) {
        Collection<Capability> hostcaps = this.getHostCapabilities(mandatory);
        HashSet<Resource> result = new HashSet<Resource>();
        if (!hostcaps.isEmpty()) {
            result.addAll(optional != null ? optional : Collections.emptySet());
            result.addAll(this.findAttachableFragments(hostcaps));
        }
        return result;
    }

    private Collection<Capability> getHostCapabilities(Collection<? extends Resource> resources) {
        HashSet<Capability> result = new HashSet<Capability>();
        for (Resource resource : resources) {
            List caps = resource.getCapabilities("osgi.wiring.host");
            if (caps.size() != 1) continue;
            result.add((Capability)caps.get(0));
        }
        return result;
    }

    private Collection<Resource> filterSingletons(Collection<? extends Resource> resources) {
        HashMap<String, XResource> singletons = new HashMap<String, XResource>();
        ArrayList<? extends Resource> result = new ArrayList<Resource>(resources);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            XResource xres = (XResource)iterator.next();
            XIdentityCapability icap = xres.getIdentityCapability();
            if (!icap.isSingleton()) continue;
            if (singletons.get(icap.getSymbolicName()) != null) {
                iterator.remove();
                continue;
            }
            singletons.put(icap.getSymbolicName(), xres);
        }
        return Collections.unmodifiableList(result);
    }

    private Collection<? extends Resource> findAttachableFragments(Collection<? extends Capability> hostcaps) {
        HashSet<XResource> result = new HashSet<XResource>();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        for (XResource res : env.getResources(Collections.singleton("osgi.fragment"))) {
            Requirement req = (Requirement)res.getRequirements("osgi.wiring.host").get(0);
            XRequirement xreq = (XRequirement)req;
            for (Capability capability : hostcaps) {
                if (!xreq.matches((XCapability)capability)) continue;
                result.add(res);
            }
        }
        if (!result.isEmpty()) {
            FrameworkLogger.LOGGER.debugf("Adding attachable fragments: %s", result);
        }
        return result;
    }

    private Map<Resource, Wiring> applyResolverResults(Map<Resource, List<Wire>> wiremap) throws ResolutionException {
        this.attachFragmentsToHost(wiremap);
        try {
            this.resolveNativeCodeLibraries(wiremap);
        }
        catch (BundleException ex) {
            throw new ResolutionException((Throwable)ex);
        }
        this.addModules(wiremap);
        this.loadModules(wiremap);
        this.setBundleToResolved(wiremap);
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        return env.updateWiring(wiremap);
    }

    private void attachFragmentsToHost(Map<Resource, List<Wire>> wiremap) {
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            XResource res = (XResource)entry.getKey();
            if (!res.isFragment()) continue;
            FragmentBundleRevision fragRev = (FragmentBundleRevision)res;
            for (Wire wire : entry.getValue()) {
                Capability cap = wire.getCapability();
                if (!"osgi.wiring.host".equals(cap.getNamespace())) continue;
                HostBundleRevision hostRev = (HostBundleRevision)cap.getResource();
                fragRev.attachToHost(hostRev);
            }
        }
    }

    private void resolveNativeCodeLibraries(Map<Resource, List<Wire>> wiremap) throws BundleException {
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            UserBundleRevision userRev;
            Deployment deployment;
            NativeLibraryMetaData libMetaData;
            XResource res = (XResource)entry.getKey();
            if (!(res instanceof UserBundleRevision) || (libMetaData = (NativeLibraryMetaData)(deployment = (userRev = (UserBundleRevision)res).getDeployment()).getAttachment(NativeLibraryMetaData.class)) == null) continue;
            NativeCodePlugin nativeCodePlugin = (NativeCodePlugin)((Object)this.injectedNativeCode.getValue());
            nativeCodePlugin.resolveNativeCode(userRev);
        }
    }

    private void addModules(Map<Resource, List<Wire>> wiremap) {
        ModuleManagerPlugin moduleManager = (ModuleManagerPlugin)((Object)this.injectedModuleManager.getValue());
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            XResource res = (XResource)entry.getKey();
            if (res.isFragment()) continue;
            List<Wire> wires = wiremap.get(res);
            moduleManager.addModule(res, wires);
        }
    }

    private void loadModules(Map<Resource, List<Wire>> wiremap) {
        ModuleManagerPlugin moduleManager = (ModuleManagerPlugin)((Object)this.injectedModuleManager.getValue());
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            XResource res = (XResource)entry.getKey();
            if (res.isFragment()) continue;
            ModuleIdentifier identifier = moduleManager.getModuleIdentifier(res);
            try {
                moduleManager.loadModule(identifier);
            }
            catch (ModuleLoadException ex) {
                throw FrameworkMessages.MESSAGES.illegalStateCannotLoadModule(ex, identifier);
            }
        }
    }

    private void setBundleToResolved(Map<Resource, List<Wire>> wiremap) {
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            if (!(entry.getKey() instanceof AbstractBundleRevision)) continue;
            AbstractBundleRevision brev = (AbstractBundleRevision)entry.getKey();
            brev.getBundleState().changeState(4);
        }
    }
}

