/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.StorageState;
import org.jboss.osgi.framework.StorageStateProvider;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.InternalServices;
import org.osgi.framework.BundleException;

final class StorageStateProviderPlugin
extends AbstractPluginService<StorageStateProvider>
implements StorageStateProvider {
    private final InjectedValue<BundleStoragePlugin> injectedBundleStorage = new InjectedValue();
    private final InjectedValue<DeploymentFactoryPlugin> injectedDeploymentFactory = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        StorageStateProviderPlugin service = new StorageStateProviderPlugin();
        ServiceBuilder builder = serviceTarget.addService(Services.STORAGE_STATE_PROVIDER, (Service)service);
        builder.addDependency(InternalServices.BUNDLE_STORAGE_PLUGIN, BundleStoragePlugin.class, service.injectedBundleStorage);
        builder.addDependency(InternalServices.DEPLOYMENT_FACTORY_PLUGIN, DeploymentFactoryPlugin.class, service.injectedDeploymentFactory);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private StorageStateProviderPlugin() {
    }

    public StorageStateProvider getValue() {
        return this;
    }

    @Override
    public Set<StorageState> getStorageStates() {
        BundleStoragePlugin bundleStorage = (BundleStoragePlugin)((Object)this.injectedBundleStorage.getValue());
        Set<BundleStoragePlugin.InternalStorageState> storageStates = bundleStorage.getBundleStorageStates();
        return Collections.unmodifiableSet(new HashSet<BundleStoragePlugin.InternalStorageState>(storageStates));
    }

    @Override
    public StorageState getByLocation(String location) {
        BundleStoragePlugin bundleStorage = (BundleStoragePlugin)((Object)this.injectedBundleStorage.getValue());
        return bundleStorage.getStorageState(location);
    }

    @Override
    public Deployment createDeployment(StorageState storageState) throws BundleException {
        return ((DeploymentFactoryPlugin)((Object)this.injectedDeploymentFactory.getValue())).createDeployment(storageState);
    }
}

