/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds.v10;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.ds.v10.DataSource;
import org.jboss.jca.common.api.metadata.ds.v10.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.AbstractParser;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.ds.DatasourcesImpl;
import org.jboss.jca.common.metadata.ds.DriverImpl;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.StatementImpl;
import org.jboss.jca.common.metadata.ds.TimeOutImpl;
import org.jboss.jca.common.metadata.ds.ValidationImpl;
import org.jboss.jca.common.metadata.ds.v10.DataSourceImpl;
import org.jboss.jca.common.metadata.ds.v10.XADataSourceImpl;
import org.jboss.logging.Messages;

public class DsParser
extends AbstractParser
implements MetadataParser<DataSources> {
    protected static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSources parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        try {
            DataSources dataSources = this.parse(reader);
            return dataSources;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public DataSources parse(XMLStreamReader reader) throws Exception {
        int iterate;
        DataSources dataSources = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case DATASOURCES: {
                        dataSources = this.parseDataSources(reader);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return dataSources;
    }

    protected DataSources parseDataSources(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<DataSource> datasource = new ArrayList<DataSource>();
        ArrayList<XaDataSource> xaDataSource = new ArrayList<XaDataSource>();
        HashMap<String, Driver> drivers = new HashMap<String, Driver>();
        boolean driversMatched = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.DATASOURCES) {
                        return new DatasourcesImpl(datasource, xaDataSource, drivers);
                    }
                    if (DataSources.Tag.forName((String)reader.getLocalName()) != DataSources.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSources.Tag.forName((String)reader.getLocalName())) {
                        case DATASOURCE: {
                            datasource.add(this.parseDataSource(reader));
                            break block0;
                        }
                        case XA_DATASOURCE: {
                            xaDataSource.add(this.parseXADataSource(reader));
                            break block0;
                        }
                        case DRIVERS: {
                            driversMatched = true;
                            break block0;
                        }
                        case DRIVER: {
                            Driver driver = this.parseDriver(reader);
                            drivers.put(driver.getName(), driver);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Driver parseDriver(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String driverClass = null;
        String dataSourceClass = null;
        String xaDataSourceClass = null;
        String name = null;
        Integer majorVersion = null;
        Integer minorVersion = null;
        String module = null;
        block15: for (Driver.Attribute attribute : Driver.Attribute.values()) {
            switch (attribute) {
                case NAME: {
                    name = this.attributeAsString(reader, attribute.getLocalName());
                    continue block15;
                }
                case MAJOR_VERSION: {
                    majorVersion = this.attributeAsInt(reader, attribute.getLocalName());
                    continue block15;
                }
                case MINOR_VERSION: {
                    minorVersion = this.attributeAsInt(reader, attribute.getLocalName());
                    continue block15;
                }
                case MODULE: {
                    module = this.attributeAsString(reader, attribute.getLocalName());
                    continue block15;
                }
            }
        }
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DRIVER) {
                        return new DriverImpl(name, majorVersion, minorVersion, module, driverClass, dataSourceClass, xaDataSourceClass);
                    }
                    if (Driver.Tag.forName((String)reader.getLocalName()) != Driver.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Driver.Tag.forName((String)reader.getLocalName())) {
                        case DATASOURCE_CLASS: {
                            dataSourceClass = this.elementAsString(reader);
                            break block6;
                        }
                        case XA_DATASOURCE_CLASS: {
                            xaDataSourceClass = this.elementAsString(reader);
                            break block6;
                        }
                        case DRIVER_CLASS: {
                            driverClass = this.elementAsString(reader);
                            break block6;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected XaDataSource parseXADataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> xaDataSourceProperty = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        CommonXaPool xaPool = null;
        Recovery recovery = null;
        String xaDataSourceClass = null;
        String driver = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String poolName = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        block27: for (XaDataSource.Attribute attribute : XaDataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block27;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block27;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
                case SPY: {
                    spy = this.attributeAsBoolean(reader, attribute.getLocalName(), false);
                    continue block27;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
            }
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        return new XADataSourceImpl(transactionIsolation, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm, xaDataSourceProperty, xaDataSourceClass, driver, newConnectionSql, xaPool, recovery);
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            xaDataSourceProperty.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block8;
                        }
                        case XA_DATASOURCE_CLASS: {
                            xaDataSourceClass = this.elementAsString(reader);
                            break block8;
                        }
                        case DRIVER: {
                            driver = this.elementAsString(reader);
                            break block8;
                        }
                        case XA_POOL: {
                            xaPool = this.parseXaPool(reader);
                            break block8;
                        }
                        case NEW_CONNECTION_SQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block8;
                        }
                        case URL_DELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block8;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block8;
                        }
                        case TRANSACTION_ISOLATION: {
                            transactionIsolation = TransactionIsolation.valueOf((String)this.elementAsString(reader));
                            break block8;
                        }
                        case SECURITY: {
                            securitySettings = this.parseDsSecurity(reader);
                            break block8;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block8;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block8;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block8;
                        }
                        case RECOVERY: {
                            recovery = this.parseRecovery(reader);
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected DsSecurity parseDsSecurity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String securityDomain = null;
        Extension reauthPlugin = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return new DsSecurityImpl(userName, password, securityDomain, reauthPlugin);
                    }
                    if (DsSecurity.Tag.forName((String)reader.getLocalName()) != DsSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    DsSecurity.Tag tag = DsSecurity.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            break block0;
                        }
                        case USER_NAME: {
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                        case REAUTH_PLUGIN: {
                            reauthPlugin = this.parseExtension(reader, tag.getLocalName());
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected DataSource parseDataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String connectionUrl = null;
        String driverClass = null;
        String dataSourceClass = null;
        String driver = null;
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        CommonPool pool = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String poolName = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean jta = Defaults.JTA;
        block29: for (DataSource.Attribute attribute : DataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block29;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block29;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block29;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block29;
                }
                case SPY: {
                    spy = this.attributeAsBoolean(reader, attribute.getLocalName(), false);
                    continue block29;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block29;
                }
                case JTA: {
                    jta = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block29;
                }
            }
        }
        while (reader.hasNext()) {
            block9 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        return new DataSourceImpl(connectionUrl, driverClass, dataSourceClass, driver, transactionIsolation, connectionProperties, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useCcm, jta, pool);
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            connectionProperties.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block9;
                        }
                        case CONNECTION_URL: {
                            connectionUrl = this.elementAsString(reader);
                            break block9;
                        }
                        case DRIVER_CLASS: {
                            driverClass = this.elementAsString(reader);
                            break block9;
                        }
                        case DATASOURCE_CLASS: {
                            dataSourceClass = this.elementAsString(reader);
                            break block9;
                        }
                        case DRIVER: {
                            driver = this.elementAsString(reader);
                            break block9;
                        }
                        case POOL: {
                            pool = this.parsePool(reader);
                            break block9;
                        }
                        case NEW_CONNECTION_SQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block9;
                        }
                        case URL_DELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block9;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block9;
                        }
                        case TRANSACTION_ISOLATION: {
                            transactionIsolation = TransactionIsolation.valueOf((String)this.elementAsString(reader));
                            break block9;
                        }
                        case SECURITY: {
                            securitySettings = this.parseDsSecurity(reader);
                            break block9;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block9;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block9;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block9;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Validation parseValidationSetting(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Boolean validateOnMatch = Defaults.VALIDATE_ON_MATCH;
        Boolean useFastFail = Defaults.USE_CCM;
        Long backgroundValidationMillis = null;
        Extension staleConnectionChecker = null;
        Boolean backgroundValidation = Defaults.BACKGROUND_VALIDATION;
        String checkValidConnectionSql = null;
        Extension validConnectionChecker = null;
        Extension exceptionSorter = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.VALIDATION) {
                        return new ValidationImpl(backgroundValidation, backgroundValidationMillis, useFastFail, validConnectionChecker, checkValidConnectionSql, validateOnMatch, staleConnectionChecker, exceptionSorter);
                    }
                    if (Validation.Tag.forName((String)reader.getLocalName()) != Validation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Validation.Tag currTag = Validation.Tag.forName((String)reader.getLocalName());
                    switch (currTag) {
                        case BACKGROUND_VALIDATION: {
                            backgroundValidation = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            backgroundValidationMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case CHECK_VALID_CONNECTION_SQL: {
                            checkValidConnectionSql = this.elementAsString(reader);
                            break block0;
                        }
                        case EXCEPTION_SORTER: {
                            exceptionSorter = this.parseExtension(reader, currTag.getLocalName());
                            break block0;
                        }
                        case STALE_CONNECTION_CHECKER: {
                            staleConnectionChecker = this.parseExtension(reader, currTag.getLocalName());
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            useFastFail = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case VALIDATE_ON_MATCH: {
                            validateOnMatch = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case VALID_CONNECTION_CHECKER: {
                            validConnectionChecker = this.parseExtension(reader, currTag.getLocalName());
                            break block0;
                        }
                    }
                    if (reader.getLocalName().equals("background-validation-minutes")) {
                        Integer backgroundValidationMinutes = this.elementAsInteger(reader);
                        backgroundValidationMillis = (long)backgroundValidationMinutes.intValue() * 60000L;
                        break;
                    }
                    if (reader.getLocalName().equals("useFastFail")) {
                        useFastFail = this.elementAsBoolean(reader);
                        break;
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected TimeOut parseTimeOutSettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Long blockingTimeoutMillis = null;
        Long idleTimeoutMinutes = null;
        Boolean setTxQuertTimeout = Defaults.SET_TX_QUERY_TIMEOUT;
        Long queryTimeout = null;
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Long useTryLock = null;
        Integer xaResourceTimeout = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.TIMEOUT) {
                        return new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, setTxQuertTimeout, queryTimeout, useTryLock);
                    }
                    if (TimeOut.Tag.forName((String)reader.getLocalName()) != TimeOut.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (TimeOut.Tag.forName((String)reader.getLocalName())) {
                        case ALLOCATION_RETRY: {
                            allocationRetry = this.elementAsInteger(reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            allocationRetryWaitMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            blockingTimeoutMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            idleTimeoutMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case QUERY_TIMEOUT: {
                            queryTimeout = this.elementAsLong(reader);
                            break block0;
                        }
                        case SET_TX_QUERY_TIMEOUT: {
                            setTxQuertTimeout = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_TRY_LOCK: {
                            useTryLock = this.elementAsLong(reader);
                            break block0;
                        }
                        case XA_RESOURCE_TIMEOUT: {
                            xaResourceTimeout = this.elementAsInteger(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Statement parseStatementSettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Long preparedStatementsCacheSize = null;
        Boolean sharePreparedStatements = Defaults.SHARE_PREPARED_STATEMENTS;
        Statement.TrackStatementsEnum trackStatements = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.STATEMENT) {
                        return new StatementImpl(sharePreparedStatements, preparedStatementsCacheSize, trackStatements);
                    }
                    if (Statement.Tag.forName((String)reader.getLocalName()) != Statement.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Statement.Tag.forName((String)reader.getLocalName())) {
                        case PREPARED_STATEMENT_CACHE_SIZE: {
                            preparedStatementsCacheSize = this.elementAsLong(reader);
                            break block0;
                        }
                        case TRACK_STATEMENTS: {
                            String elementString = this.elementAsString(reader);
                            trackStatements = Statement.TrackStatementsEnum.valueOf((String)(elementString == null ? "FALSE" : elementString.toUpperCase(Locale.US)));
                            break block0;
                        }
                        case SHARE_PREPARED_STATEMENTS: {
                            sharePreparedStatements = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

