/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import org.jboss.as.xts.SecurityActions;
import org.jboss.as.xts.XtsAsMessages;
import org.jboss.jbossts.XTSService;
import org.jboss.jbossts.xts.environment.WSCEnvironmentBean;
import org.jboss.jbossts.xts.environment.XTSPropertyManager;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.wsf.spi.management.ServerConfig;

public class XTSManagerService
extends AbstractService<XTSService> {
    private final String coordinatorURL;
    private volatile XTSService xtsService;
    private InjectedValue<ServerConfig> wsServerConfig = new InjectedValue();

    public XTSManagerService(String coordinatorURL) {
        this.coordinatorURL = coordinatorURL;
        this.xtsService = null;
    }

    public XTSService getValue() throws IllegalStateException {
        return this.xtsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        ClassLoader loader = XTSService.class.getClassLoader();
        SecurityActions.setContextLoader(loader);
        try {
            ServerConfig serverConfigValue = (ServerConfig)this.wsServerConfig.getValue();
            WSCEnvironmentBean wscEnVBean = XTSPropertyManager.getWSCEnvironmentBean();
            if (this.coordinatorURL != null) {
                wscEnVBean.setCoordinatorURL11(this.coordinatorURL);
            } else {
                String defaultCoordinatorUrl = "http://" + serverConfigValue.getWebServiceHost() + ":" + serverConfigValue.getWebServicePort() + "/" + wscEnVBean.getCoordinatorPath11();
                wscEnVBean.setCoordinatorURL11(defaultCoordinatorUrl);
            }
            wscEnVBean.setBindAddress11(serverConfigValue.getWebServiceHost());
            wscEnVBean.setBindPort11(serverConfigValue.getWebServicePort());
            wscEnVBean.setBindPortSecure11(serverConfigValue.getWebServiceSecurePort());
            XTSService service = new XTSService();
            try {
                service.start();
            }
            catch (Exception e) {
                throw XtsAsMessages.MESSAGES.xtsServiceFailedToStart();
            }
            this.xtsService = service;
        }
        finally {
            SecurityActions.setContextLoader(null);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.xtsService != null) {
            try {
                this.xtsService.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public InjectedValue<ServerConfig> getWSServerConfig() {
        return this.wsServerConfig;
    }
}

