/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ee.component.deployers.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.EjbInjectionSource;
import org.jboss.as.ejb3.deployment.processors.EjbLookupInjectionSource;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;

public class EjbRefProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    private final boolean appclient;

    public EjbRefProcessor(boolean appclient) {
        this.appclient = appclient;
    }

    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ResourceInjectionTarget resourceInjectionTarget, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        EJBLocalReferencesMetaData ejbLocalRefs;
        RemoteEnvironment remoteEnvironment = environment.getEnvironment();
        DeploymentClassIndex index = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        ArrayList<BindingConfiguration> bindingDescriptions = new ArrayList<BindingConfiguration>();
        EJBReferencesMetaData ejbRefs = remoteEnvironment.getEjbReferences();
        if (ejbRefs != null) {
            for (EJBReferenceMetaData ejbRef : ejbRefs) {
                BindingConfiguration bindingConfiguration;
                String name = ejbRef.getEjbRefName();
                String ejbName = ejbRef.getLink();
                String lookup = ejbRef.getLookupName() != null ? ejbRef.getLookupName() : ejbRef.getMappedName();
                String remoteInterface = ejbRef.getRemote();
                String home = ejbRef.getHome();
                Class remoteInterfaceType = null;
                if (!this.isEmpty(home)) {
                    try {
                        remoteInterfaceType = index.classIndex(home).getModuleClass();
                    }
                    catch (ClassNotFoundException e) {
                        throw EjbLogger.EJB3_LOGGER.failedToLoadViewClass(e, home);
                    }
                }
                if (!this.isEmpty(remoteInterface)) {
                    try {
                        remoteInterfaceType = index.classIndex(remoteInterface).getModuleClass();
                    }
                    catch (ClassNotFoundException e) {
                        throw EjbLogger.EJB3_LOGGER.failedToLoadViewClass(e, remoteInterface);
                    }
                }
                if (!name.startsWith("java:")) {
                    name = environment.getDefaultContext() + name;
                }
                LookupInjectionSource injectionSource = new LookupInjectionSource(name);
                remoteInterfaceType = this.processInjectionTargets(resourceInjectionTarget, (InjectionSource)injectionSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)ejbRef, remoteInterfaceType);
                EjbInjectionSource ejbInjectionSource = null;
                if (!this.isEmpty(lookup)) {
                    bindingConfiguration = !lookup.startsWith("java:") ? new BindingConfiguration(name, (InjectionSource)new EjbLookupInjectionSource(lookup, remoteInterfaceType)) : new BindingConfiguration(name, (InjectionSource)new LookupInjectionSource(lookup));
                } else {
                    if (remoteInterfaceType == null) {
                        throw EjbLogger.EJB3_LOGGER.couldNotDetermineEjbRefForInjectionTarget(name, resourceInjectionTarget);
                    }
                    if (!this.isEmpty(ejbName)) {
                        ejbInjectionSource = new EjbInjectionSource(ejbName, remoteInterfaceType.getName(), name, deploymentUnit, this.appclient);
                        bindingConfiguration = new BindingConfiguration(name, (InjectionSource)ejbInjectionSource);
                    } else {
                        ejbInjectionSource = new EjbInjectionSource(remoteInterfaceType.getName(), name, deploymentUnit, this.appclient);
                        bindingConfiguration = new BindingConfiguration(name, (InjectionSource)ejbInjectionSource);
                    }
                }
                if (ejbInjectionSource != null) {
                    deploymentUnit.addToAttachmentList(EjbDeploymentAttachmentKeys.EJB_INJECTIONS, ejbInjectionSource);
                }
                bindingDescriptions.add(bindingConfiguration);
            }
        }
        if (remoteEnvironment instanceof Environment && !this.appclient && (ejbLocalRefs = ((Environment)remoteEnvironment).getEjbLocalReferences()) != null) {
            for (EJBLocalReferenceMetaData ejbRef : ejbLocalRefs) {
                BindingConfiguration bindingConfiguration;
                LookupInjectionSource injectionSource;
                String name = ejbRef.getEjbRefName();
                String ejbName = ejbRef.getLink();
                String lookup = ejbRef.getLookupName() != null ? ejbRef.getLookupName() : ejbRef.getMappedName();
                String localInterface = ejbRef.getLocal();
                String localHome = ejbRef.getLocalHome();
                Class localInterfaceType = null;
                if (!this.isEmpty(localHome)) {
                    try {
                        localInterfaceType = index.classIndex(localHome).getModuleClass();
                    }
                    catch (ClassNotFoundException e) {
                        throw EjbLogger.EJB3_LOGGER.failedToLoadViewClass(e, localHome);
                    }
                }
                if (!this.isEmpty(localInterface)) {
                    try {
                        localInterfaceType = index.classIndex(localInterface).getModuleClass();
                    }
                    catch (ClassNotFoundException e) {
                        throw EjbLogger.EJB3_LOGGER.failedToLoadViewClass(e, localInterface);
                    }
                }
                if (!name.startsWith("java:")) {
                    name = environment.getDefaultContext() + name;
                }
                if ((localInterfaceType = this.processInjectionTargets(resourceInjectionTarget, (InjectionSource)(injectionSource = new LookupInjectionSource(name)), classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)ejbRef, localInterfaceType)) == null) {
                    throw EjbLogger.EJB3_LOGGER.couldNotDetermineEjbLocalRefForInjectionTarget(name, resourceInjectionTarget);
                }
                EjbInjectionSource ejbInjectionSource = null;
                if (!this.isEmpty(lookup)) {
                    bindingConfiguration = !lookup.startsWith("java:") ? new BindingConfiguration(name, (InjectionSource)new EjbLookupInjectionSource(lookup, localInterfaceType)) : new BindingConfiguration(name, (InjectionSource)new LookupInjectionSource(lookup));
                } else if (!this.isEmpty(ejbName)) {
                    ejbInjectionSource = new EjbInjectionSource(ejbName, localInterfaceType.getName(), name, deploymentUnit, this.appclient);
                    bindingConfiguration = new BindingConfiguration(name, (InjectionSource)ejbInjectionSource);
                } else {
                    ejbInjectionSource = new EjbInjectionSource(localInterfaceType.getName(), name, deploymentUnit, this.appclient);
                    bindingConfiguration = new BindingConfiguration(name, (InjectionSource)ejbInjectionSource);
                }
                if (ejbInjectionSource != null) {
                    deploymentUnit.addToAttachmentList(EjbDeploymentAttachmentKeys.EJB_INJECTIONS, (Object)ejbInjectionSource);
                }
                bindingDescriptions.add(bindingConfiguration);
            }
        }
        return bindingDescriptions;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

