/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreSourceService;
import org.jboss.as.ejb3.subsystem.PassivationStoreAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class ClusterPassivationStoreAdd
extends PassivationStoreAdd {
    public ClusterPassivationStoreAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    @Override
    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        String name = model.require("name").asString();
        ClusteredBackingCacheEntryStoreSourceService service = new ClusteredBackingCacheEntryStoreSourceService(name);
        ClusteredBackingCacheEntryStoreConfig config = (ClusteredBackingCacheEntryStoreConfig)service.getValue();
        if (model.hasDefined("cache-container")) {
            config.setCacheContainer(model.get("cache-container").asString());
        }
        if (model.hasDefined("bean-cache")) {
            config.setBeanCache(model.get("bean-cache").asString());
        }
        if (model.hasDefined("client-mappings-cache")) {
            config.setClientMappingCache(model.get("client-mappings-cache").asString());
        }
        if (model.hasDefined("passivate-events-on-replicate")) {
            config.setPassivateEventsOnReplicate(model.get("passivate-events-on-replicate").asBoolean());
        }
        ServiceName serviceName = ClusteredBackingCacheEntryStoreSourceService.getPassivationStoreClusterNameServiceName(name);
        ServiceRegistry registry = context.getServiceRegistry(true);
        if (registry.getService(serviceName) != null) {
            context.removeService(serviceName);
        }
        InjectedValue clusterName = new InjectedValue();
        ServiceController controller = context.getServiceTarget().addService(serviceName, (Service)new ValueService((Value)clusterName)).addDependency(ClusteredBackingCacheEntryStoreSourceService.getCacheContainerClusterNameServiceName(config.getCacheContainer()), String.class, (Injector)clusterName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return Arrays.asList(this.installBackingCacheEntryStoreSourceService(service, context, model, verificationHandler), controller);
    }
}

