/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.hibernate.AssertionFailure;
import org.hibernate.ejb.packaging.ClassFilter;
import org.hibernate.ejb.packaging.Entry;
import org.hibernate.ejb.packaging.FileFilter;
import org.hibernate.ejb.packaging.Filter;
import org.hibernate.ejb.packaging.JarVisitor;
import org.hibernate.ejb.packaging.JarVisitorFactory;
import org.hibernate.ejb.packaging.NamedInputStream;
import org.hibernate.ejb.packaging.PackageFilter;
import org.hibernate.ejb.packaging.Scanner;
import org.hibernate.internal.util.ReflectHelper;

public class NativeScanner
implements Scanner {
    private static final String META_INF_ORM_XML = "META-INF/orm.xml";
    private Map<URL, StateJarVisitor> visitors = new HashMap<URL, StateJarVisitor>();
    private static final int PACKAGE_FILTER_INDEX = 0;
    private static final int CLASS_FILTER_INDEX = 1;
    private static final int FILE_FILTER_INDEX = 2;

    @Override
    public Set<Package> getPackagesInJar(URL jarToScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        Set packageEntries;
        if (annotationsToLookFor.size() > 0) {
            throw new AssertionFailure("Improper use of NativeScanner: must not filter packages");
        }
        JarVisitor jarVisitor = this.getVisitor(jarToScan);
        try {
            packageEntries = jarVisitor.getMatchingEntries()[0];
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading " + jarToScan.toString(), e);
        }
        HashSet<Package> packages = new HashSet<Package>(packageEntries.size());
        for (Entry entry : packageEntries) {
            try {
                packages.add(ReflectHelper.classForName((String)(entry.getName() + ".package-info")).getPackage());
            }
            catch (ClassNotFoundException e) {}
        }
        return packages;
    }

    private JarVisitor getVisitor(URL jar) {
        StateJarVisitor stateJarVisitor = this.visitors.get(jar);
        if (stateJarVisitor == null) {
            Filter[] filters = new Filter[]{new PackageFilter(false, null){

                @Override
                public boolean accept(String javaElementName) {
                    return true;
                }
            }, new ClassFilter(false, new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class}){

                @Override
                public boolean accept(String javaElementName) {
                    return true;
                }
            }, new FileFilter(true){

                @Override
                public boolean accept(String javaElementName) {
                    return javaElementName.endsWith("hbm.xml") || javaElementName.endsWith(NativeScanner.META_INF_ORM_XML);
                }
            }};
            stateJarVisitor = new StateJarVisitor(JarVisitorFactory.getVisitor(jar, filters));
            this.visitors.put(jar, stateJarVisitor);
        }
        return stateJarVisitor.visitor;
    }

    @Override
    public Set<Class<?>> getClassesInJar(URL jarToScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        Set classesEntry;
        if (this.isValidForClasses(annotationsToLookFor)) {
            throw new AssertionFailure("Improper use of NativeScanner: must not filter classes by other annotations than Entity, MappedSuperclass, embeddable");
        }
        JarVisitor jarVisitor = this.getVisitor(jarToScan);
        try {
            classesEntry = jarVisitor.getMatchingEntries()[1];
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading " + jarToScan.toString(), e);
        }
        HashSet classes = new HashSet(classesEntry.size());
        for (Entry entry : classesEntry) {
            try {
                classes.add(ReflectHelper.classForName((String)entry.getName()));
            }
            catch (ClassNotFoundException e) {}
        }
        return classes;
    }

    private boolean isValidForClasses(Set<Class<? extends Annotation>> annotationsToLookFor) {
        return annotationsToLookFor.size() != 3 || !annotationsToLookFor.contains(Entity.class) || !annotationsToLookFor.contains(MappedSuperclass.class) || !annotationsToLookFor.contains(Embeddable.class);
    }

    @Override
    public Set<NamedInputStream> getFilesInJar(URL jarToScan, Set<String> filePatterns) {
        Set fileEntries;
        StringBuilder sb = new StringBuilder("URL: ").append(jarToScan).append("\n");
        for (String pattern : filePatterns) {
            sb.append("  ").append(pattern).append("\n");
        }
        JarVisitor jarVisitor = this.getVisitor(jarToScan);
        StateJarVisitor stateVisitor = this.visitors.get(jarToScan);
        if (stateVisitor.hasReadFiles) {
            throw new AssertionFailure("Cannot read files twice on NativeScanner");
        }
        stateVisitor.hasReadFiles = true;
        HashSet<String> endWiths = new HashSet<String>();
        HashSet<String> exacts = new HashSet<String>();
        for (String pattern : filePatterns) {
            if (pattern.startsWith("**/*")) {
                String patternTail = pattern.substring(4, pattern.length());
                if (!patternTail.equals(".hbm.xml")) {
                    throw new AssertionFailure("Improper use of NativeScanner: must not filter files via pattern other than .hbm.xml");
                }
                endWiths.add(patternTail);
                continue;
            }
            exacts.add(pattern);
        }
        try {
            fileEntries = jarVisitor.getMatchingEntries()[2];
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading " + jarToScan.toString(), e);
        }
        HashSet<NamedInputStream> files = new HashSet<NamedInputStream>(fileEntries.size());
        HashSet leftOver = new HashSet(fileEntries);
        for (Entry entry : fileEntries) {
            boolean done = false;
            for (String exact : exacts) {
                if (!entry.getName().equals(exact)) continue;
                files.add(new NamedInputStream(entry.getName(), entry.getInputStream()));
                leftOver.remove(entry);
                done = true;
            }
            if (done) continue;
            for (String endWithPattern : endWiths) {
                if (!entry.getName().endsWith(endWithPattern)) continue;
                files.add(new NamedInputStream(entry.getName(), entry.getInputStream()));
                leftOver.remove(entry);
            }
        }
        for (Entry entry : leftOver) {
            try {
                entry.getInputStream().close();
            }
            catch (IOException e) {}
        }
        return files;
    }

    @Override
    public Set<NamedInputStream> getFilesInClasspath(Set<String> filePatterns) {
        throw new AssertionFailure("Not implemented");
    }

    @Override
    public String getUnqualifiedJarName(URL jarToScan) {
        JarVisitor jarVisitor = this.getVisitor(jarToScan);
        return jarVisitor.getUnqualifiedJarName();
    }

    private static class StateJarVisitor {
        JarVisitor visitor;
        boolean hasReadFiles = false;

        StateJarVisitor(JarVisitor visitor) {
            this.visitor = visitor;
        }
    }
}

