/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.jca.core.CoreLogger;
import org.jboss.logging.Logger;

public class TransactionSynchronizer
implements Synchronization {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)TransactionSynchronizer.class.getName());
    private static ConcurrentMap<Transaction, TransactionSynchronizer> txSynchs = new ConcurrentHashMap<Transaction, TransactionSynchronizer>();
    private static ConcurrentMap<Transaction, Lock> locks = new ConcurrentHashMap<Transaction, Lock>();
    private Transaction tx;
    private Thread enlistingThread;
    private List<Synchronization> unenlisted;
    private List<Synchronization> enlisted;
    private Synchronization ccmSynch;

    private TransactionSynchronizer(Transaction tx) {
        this.tx = tx;
    }

    public synchronized void addUnenlisted(Synchronization synch) {
        if (this.unenlisted == null) {
            this.unenlisted = new ArrayList<Synchronization>(1);
        }
        this.unenlisted.add(synch);
    }

    public synchronized List<Synchronization> getUnenlisted() {
        Thread currentThread = Thread.currentThread();
        while (this.enlistingThread != null && this.enlistingThread != currentThread) {
            boolean interrupted = false;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            if (!interrupted) continue;
            currentThread.interrupt();
        }
        List<Synchronization> result = this.unenlisted;
        this.unenlisted = null;
        if (result != null) {
            this.enlistingThread = currentThread;
        }
        return result;
    }

    public synchronized void addEnlisted(Synchronization synch) {
        if (this.enlisted == null) {
            this.enlisted = new ArrayList<Synchronization>(1);
        }
        this.enlisted.add(synch);
    }

    public synchronized boolean removeEnlisted(Synchronization synch) {
        return this.enlisted.remove(synch);
    }

    public synchronized void enlisted() {
        Thread currentThread = Thread.currentThread();
        if (this.enlistingThread == null || this.enlistingThread != currentThread) {
            log.threadIsnotEnlistingThread(currentThread, this.enlistingThread, new Exception("STACKTRACE"));
            return;
        }
        this.enlistingThread = null;
        this.notifyAll();
    }

    public static TransactionSynchronizer getRegisteredSynchronizer(Transaction tx, TransactionSynchronizationRegistry tsr) throws SystemException, RollbackException {
        TransactionSynchronizer newResult;
        TransactionSynchronizer result = (TransactionSynchronizer)txSynchs.get(tx);
        if (result == null && (result = txSynchs.putIfAbsent(tx, newResult = new TransactionSynchronizer(tx))) == null) {
            result = newResult;
            if (tsr != null) {
                tsr.registerInterposedSynchronization((Synchronization)result);
            } else {
                tx.registerSynchronization((Synchronization)result);
            }
        }
        return result;
    }

    public static Synchronization getCCMSynchronization(Transaction tx) {
        TransactionSynchronizer ts = (TransactionSynchronizer)txSynchs.get(tx);
        if (ts != null) {
            return ts.ccmSynch;
        }
        return null;
    }

    public static void registerCCMSynchronization(Transaction tx, Synchronization synch, TransactionSynchronizationRegistry tsr) throws Exception {
        TransactionSynchronizer ts = TransactionSynchronizer.getRegisteredSynchronizer(tx, tsr);
        ts.ccmSynch = synch;
    }

    public static void lock(Transaction tx) {
        ReentrantLock newLock;
        Lock lock = (Lock)locks.get(tx);
        if (lock == null && (lock = locks.putIfAbsent(tx, newLock = new ReentrantLock(true))) == null) {
            lock = newLock;
        }
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to get synchronization", e);
        }
    }

    public static void unlock(Transaction tx) {
        Lock lock = (Lock)locks.get(tx);
        if (lock != null) {
            lock.unlock();
        }
    }

    public void beforeCompletion() {
        if (this.enlisted != null) {
            for (Synchronization synch : this.enlisted) {
                this.invokeBefore(synch);
            }
        }
        if (this.ccmSynch != null) {
            this.invokeBefore(this.ccmSynch);
        }
    }

    public void afterCompletion(int status) {
        if (this.enlisted != null) {
            for (Synchronization synch : this.enlisted) {
                this.invokeAfter(synch, status);
            }
        }
        if (this.ccmSynch != null) {
            this.invokeAfter(this.ccmSynch, status);
        }
        txSynchs.remove(this.tx);
        locks.remove(this.tx);
    }

    protected void invokeBefore(Synchronization synch) {
        try {
            synch.beforeCompletion();
        }
        catch (Throwable t) {
            log.transactionErrorInBeforeCompletion(this.tx, synch, t);
        }
    }

    protected void invokeAfter(Synchronization synch, int status) {
        try {
            synch.afterCompletion(status);
        }
        catch (Throwable t) {
            log.transactionErrorInAfterCompletion(this.tx, synch, t);
        }
    }
}

