/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.jbossts;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.spi.transaction.xa.XidWrapper;
import org.jboss.jca.core.tx.jbossts.XidWrapperImpl;
import org.jboss.logging.Logger;
import org.jboss.tm.XAResourceWrapper;

public class XAResourceWrapperImpl
implements org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper,
XAResourceWrapper {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)XAResourceWrapperImpl.class.getName());
    private XAResource xaResource;
    private boolean pad;
    private Boolean overrideRmValue;
    private String productName;
    private String productVersion;
    private String jndiName;

    public XAResourceWrapperImpl(XAResource resource, boolean pad, Boolean override, String productName, String productVersion, String jndiName) {
        this.overrideRmValue = override;
        this.pad = pad;
        this.xaResource = resource;
        this.productName = productName;
        this.productVersion = productVersion;
        this.jndiName = jndiName;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (this.overrideRmValue != null) {
            if (log.isTraceEnabled()) {
                log.trace("Executing isSameRM with override value" + this.overrideRmValue + " for XAResourceWrapper" + this);
            }
            return this.overrideRmValue;
        }
        if (resource instanceof org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper) {
            org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper other = (org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper)resource;
            return this.xaResource.isSameRM(other.getResource());
        }
        return this.xaResource.isSameRM(resource);
    }

    public int prepare(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        return this.xaResource.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.rollback(xid);
    }

    public boolean setTransactionTimeout(int flag) throws XAException {
        return this.xaResource.setTransactionTimeout(flag);
    }

    public void start(Xid xid, int flags) throws XAException {
        xid = this.convertXid(xid);
        this.xaResource.start(xid, flags);
    }

    public XAResource getResource() {
        return this.xaResource;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    private Xid convertXid(Xid xid) {
        if (xid instanceof XidWrapper) {
            return xid;
        }
        return new XidWrapperImpl(xid, this.pad, this.jndiName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XAResourceWrapperImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[xaResource=").append(this.xaResource);
        sb.append(" pad=").append(this.pad);
        sb.append(" overrideRmValue=").append(this.overrideRmValue);
        sb.append(" productName=").append(this.productName);
        sb.append(" productVersion=").append(this.productVersion);
        sb.append(" jndiName=").append(this.jndiName);
        sb.append("]");
        return sb.toString();
    }
}

