/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.metadata.model.JAXRPCDeployment;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public final class WSIntegrationProcessorJAXRPC_POJO
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (WSIntegrationProcessorJAXRPC_POJO.isJaxwsPojoDeployment(unit)) {
            return;
        }
        JBossWebMetaData jbossWebMD = ASHelper.getJBossWebMetaData(unit);
        WebservicesMetaData webservicesMD = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.WEBSERVICES_METADATA_KEY);
        if (jbossWebMD != null && webservicesMD != null && this.hasJaxRpcMapping(webservicesMD)) {
            WSIntegrationProcessorJAXRPC_POJO.createJaxrpcDeployment(unit, webservicesMD, jbossWebMD);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static boolean isJaxwsPojoDeployment(DeploymentUnit unit) {
        return ASHelper.getJaxwsPojos(unit).size() > 0;
    }

    private static void createJaxrpcDeployment(DeploymentUnit unit, WebservicesMetaData webservicesMD, JBossWebMetaData jbossWebMD) {
        JAXRPCDeployment jaxrpcDeployment = ASHelper.getJaxrpcDeployment(unit);
        for (WebserviceDescriptionMetaData wsDescriptionMD : webservicesMD.getWebserviceDescriptions()) {
            for (PortComponentMetaData portComponentMD : wsDescriptionMD.getPortComponents()) {
                POJOEndpoint pojoEndpoint = WSIntegrationProcessorJAXRPC_POJO.newPojoEndpoint(portComponentMD, jbossWebMD);
                jaxrpcDeployment.addEndpoint(pojoEndpoint);
            }
        }
    }

    private static POJOEndpoint newPojoEndpoint(PortComponentMetaData portComponentMD, JBossWebMetaData jbossWebMD) {
        String endpointName = portComponentMD.getServletLink();
        ServletMetaData servletMD = ASHelper.getServletForName(jbossWebMD, endpointName);
        String endpointClassName = ASHelper.getEndpointClassName(servletMD);
        String urlPattern = WSIntegrationProcessorJAXRPC_POJO.getUrlPattern(endpointName, jbossWebMD);
        return new POJOEndpoint(endpointName, endpointClassName, urlPattern);
    }

    private static String getUrlPattern(String servletName, JBossWebMetaData jbossWebMD) {
        for (ServletMappingMetaData servletMappingMD : jbossWebMD.getServletMappings()) {
            if (!servletName.equals(servletMappingMD.getServletName())) continue;
            return (String)servletMappingMD.getUrlPatterns().get(0);
        }
        throw new IllegalStateException();
    }

    private boolean hasJaxRpcMapping(WebservicesMetaData webservicesMD) {
        for (WebserviceDescriptionMetaData wsdmd : webservicesMD.getWebserviceDescriptions()) {
            if (wsdmd.getJaxrpcMappingFile() == null) continue;
            return true;
        }
        return false;
    }
}

