/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import org.apache.felix.log.LogException;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;

final class LogEntryImpl
implements LogEntry {
    private final Bundle m_bundle;
    private final Throwable m_exception;
    private final int m_level;
    private final String m_message;
    private final ServiceReference m_serviceReference;
    private final long m_time;

    LogEntryImpl(Bundle bundle, ServiceReference sr, int level, String message, Throwable exception) {
        this.m_bundle = bundle;
        this.m_exception = LogException.getException(exception);
        this.m_level = level;
        this.m_message = message;
        this.m_serviceReference = sr;
        this.m_time = System.currentTimeMillis();
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public ServiceReference getServiceReference() {
        return this.m_serviceReference;
    }

    public int getLevel() {
        return this.m_level;
    }

    public String getMessage() {
        return this.m_message;
    }

    public Throwable getException() {
        return this.m_exception;
    }

    public long getTime() {
        return this.m_time;
    }
}

