/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import java.util.Locale;
import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class DivertAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final DivertAdd INSTANCE = new DivertAdd();

    public static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = Util.getOperation((String)"add", (ModelNode)address, (ModelNode)subModel);
        return operation;
    }

    private DivertAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
        for (AttributeDefinition attributeDefinition : CommonAttributes.DIVERT_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null) {
            if (hqService.getState() != ServiceController.State.UP) {
                throw MessagingMessages.MESSAGES.invalidServiceState(hqServiceName, ServiceController.State.UP, hqService.getState());
            }
            String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            DivertConfiguration divertConfiguration = DivertAdd.createDivertConfiguration(context, name, model);
            HornetQServerControlImpl serverControl = ((HornetQServer)HornetQServer.class.cast(hqService.getValue())).getHornetQServerControl();
            DivertAdd.createDivert(name, divertConfiguration, (HornetQServerControl)serverControl);
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getDivertAdd(locale);
    }

    static void addDivertConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("divert")) {
            List configs = configuration.getDivertConfigurations();
            for (Property prop : model.get("divert").asPropertyList()) {
                configs.add(DivertAdd.createDivertConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static DivertConfiguration createDivertConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        ModelNode routingNode = CommonAttributes.ROUTING_NAME.resolveModelAttribute(context, model);
        String routingName = routingNode.isDefined() ? routingNode.asString() : null;
        String address = CommonAttributes.DIVERT_ADDRESS.resolveModelAttribute(context, model).asString();
        String forwardingAddress = CommonAttributes.DIVERT_FORWARDING_ADDRESS.resolveModelAttribute(context, model).asString();
        boolean exclusive = CommonAttributes.EXCLUSIVE.resolveModelAttribute(context, model).asBoolean();
        ModelNode filterNode = CommonAttributes.FILTER.resolveModelAttribute(context, model);
        String filter = filterNode.isDefined() ? filterNode.asString() : null;
        ModelNode transformerNode = CommonAttributes.TRANSFORMER_CLASS_NAME.resolveModelAttribute(context, model);
        String transformerClassName = transformerNode.isDefined() ? transformerNode.asString() : null;
        return new DivertConfiguration(name, routingName, address, forwardingAddress, exclusive, filter, transformerClassName);
    }

    static void createDivert(String name, DivertConfiguration divertConfiguration, HornetQServerControl serverControl) {
        try {
            serverControl.createDivert(name, divertConfiguration.getRoutingName(), divertConfiguration.getAddress(), divertConfiguration.getForwardingAddress(), divertConfiguration.isExclusive(), divertConfiguration.getFilterString(), divertConfiguration.getTransformerClassName());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

