/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.messaging.SecurityRoleAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ManagementUtil {
    public static void reportRolesAsJSON(OperationContext context, String rolesAsJSON) {
        ModelNode camelCase = ModelNode.fromJSONString((String)rolesAsJSON);
        ModelNode converted = ManagementUtil.convertSecurityRole(camelCase);
        String json = converted.toJSONString(true);
        context.getResult().set(json);
    }

    public static void reportRoles(OperationContext context, String rolesAsJSON) {
        ModelNode camelCase = ModelNode.fromJSONString((String)rolesAsJSON);
        ModelNode converted = ManagementUtil.convertSecurityRole(camelCase);
        context.getResult().set(converted);
    }

    public static void reportListOfString(OperationContext context, String[] list) {
        ModelNode result = context.getResult();
        result.setEmptyList();
        for (String tx : list) {
            result.add(tx);
        }
    }

    private ManagementUtil() {
    }

    private static ModelNode convertSecurityRole(ModelNode camelCase) {
        ModelNode result = new ModelNode();
        result.setEmptyList();
        if (camelCase.isDefined()) {
            for (ModelNode role : camelCase.asList()) {
                ModelNode roleNode = result.add();
                for (Property prop : role.asPropertyList()) {
                    String key = prop.getName();
                    if ("createDurableQueue".equals(key)) {
                        key = SecurityRoleAdd.CREATE_DURABLE_QUEUE.getName();
                    } else if ("deleteDurableQueue".equals(key)) {
                        key = SecurityRoleAdd.DELETE_DURABLE_QUEUE.getName();
                    } else if ("createNonDurableQueue".equals(key)) {
                        key = SecurityRoleAdd.CREATE_NON_DURABLE_QUEUE.getName();
                    } else if ("deleteNonDurableQueue".equals(key)) {
                        key = SecurityRoleAdd.DELETE_NON_DURABLE_QUEUE.getName();
                    }
                    roleNode.get(key).set(prop.getValue());
                }
            }
        }
        return result;
    }
}

