/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import org.infinispan.atomic.Operation;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class RemoveOperation<K, V>
extends Operation<K, V> {
    private K key;
    private V oldValue;

    public RemoveOperation() {
    }

    RemoveOperation(K key, V oldValue) {
        this.key = key;
        this.oldValue = oldValue;
    }

    @Override
    public void rollback(Map<K, V> delegate) {
        if (this.oldValue != null) {
            delegate.put(this.key, this.oldValue);
        }
    }

    @Override
    public void replay(Map<K, V> delegate) {
        delegate.remove(this.key);
    }

    @Override
    public K keyAffected() {
        return this.key;
    }

    public static class Externalizer
    extends AbstractExternalizer<RemoveOperation> {
        @Override
        public void writeObject(ObjectOutput output, RemoveOperation remove) throws IOException {
            output.writeObject(remove.key);
        }

        @Override
        public RemoveOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            RemoveOperation remove = new RemoveOperation();
            remove.key = input.readObject();
            return remove;
        }

        @Override
        public Integer getId() {
            return 48;
        }

        @Override
        public Set<Class<? extends RemoveOperation>> getTypeClasses() {
            return Util.asSet(RemoveOperation.class);
        }
    }
}

