/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.versioned;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.entries.versioned.VersionedMortalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class VersionedMortalCacheValue
extends MortalCacheValue
implements Versioned {
    EntryVersion version;

    public VersionedMortalCacheValue(Object value, EntryVersion version, long created, long lifespan) {
        super(value, created, lifespan);
        this.version = version;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new VersionedMortalCacheEntry(key, this);
    }

    @Override
    public EntryVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.version = version;
    }

    public static class Externalizer
    extends AbstractExternalizer<VersionedMortalCacheValue> {
        @Override
        public void writeObject(ObjectOutput output, VersionedMortalCacheValue mcv) throws IOException {
            output.writeObject(mcv.value);
            output.writeObject(mcv.version);
            UnsignedNumeric.writeUnsignedLong(output, mcv.created);
            output.writeLong(mcv.lifespan);
        }

        @Override
        public VersionedMortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            EntryVersion version = (EntryVersion)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            return new VersionedMortalCacheValue(v, version, created, lifespan);
        }

        @Override
        public Integer getId() {
            return 81;
        }

        @Override
        public Set<Class<? extends VersionedMortalCacheValue>> getTypeClasses() {
            return Util.asSet(VersionedMortalCacheValue.class);
        }
    }
}

