/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingSubsystemAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LoggingDescribeHandler
implements OperationStepHandler,
DescriptionProvider {
    static final LoggingDescribeHandler INSTANCE = new LoggingDescribeHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode result = context.getResult();
        result.add(LoggingSubsystemAdd.createOperation(rootAddress.toModelNode()));
        if (model.hasDefined("root-logger")) {
            ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{LoggingExtension.rootLoggerPath}).toModelNode());
            ModelNode rootLogger = model.get(new String[]{"root-logger", "ROOT"});
            this.copy((AttributeDefinition)CommonAttributes.LEVEL, rootLogger, add);
            this.copy((AttributeDefinition)CommonAttributes.FILTER, rootLogger, add);
            this.copy((AttributeDefinition)CommonAttributes.HANDLERS, rootLogger, add);
            result.add(add);
        }
        if (model.hasDefined("logger")) {
            for (Property prop : model.get("logger").asPropertyList()) {
                ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"logger", (String)prop.getName())}).toModelNode());
                this.copy((AttributeDefinition)CommonAttributes.NAME, prop.getValue(), add);
                this.copy((AttributeDefinition)CommonAttributes.CATEGORY, prop.getValue(), add);
                this.copy((AttributeDefinition)CommonAttributes.USE_PARENT_HANDLERS, prop.getValue(), add);
                this.copy((AttributeDefinition)CommonAttributes.HANDLERS, prop.getValue(), add);
                this.copy((AttributeDefinition)CommonAttributes.LEVEL, prop.getValue(), add);
                result.add(add);
            }
        }
        if (model.hasDefined("async-handler")) {
            for (Property prop : model.get("async-handler").asPropertyList()) {
                result.add(this.defineAsynchHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        if (model.hasDefined("console-handler")) {
            for (Property prop : model.get("console-handler").asPropertyList()) {
                result.add(this.defineConsoleHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        if (model.hasDefined("file-handler")) {
            for (Property prop : model.get("file-handler").asPropertyList()) {
                result.add(this.defineFileHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        if (model.hasDefined("custom-handler")) {
            for (Property prop : model.get("custom-handler").asPropertyList()) {
                result.add(this.defineCustomHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        if (model.hasDefined("periodic-rotating-file-handler")) {
            for (Property prop : model.get("periodic-rotating-file-handler").asPropertyList()) {
                result.add(this.definePeriodicRotatingFileHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        if (model.hasDefined("size-rotating-file-handler")) {
            for (Property prop : model.get("size-rotating-file-handler").asPropertyList()) {
                result.add(this.defineSizeRotatingFileHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        context.completeStep();
    }

    private ModelNode defineAsynchHandler(String name, ModelNode handler, PathAddress rootAddress) throws OperationFailedException {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"async-handler", (String)name)}).toModelNode());
        this.copy((AttributeDefinition)CommonAttributes.NAME, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.LEVEL, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.FILTER, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.QUEUE_LENGTH, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.SUBHANDLERS, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.OVERFLOW_ACTION, handler, add);
        return add;
    }

    private ModelNode defineConsoleHandler(String name, ModelNode handler, PathAddress rootAddress) throws OperationFailedException {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"console-handler", (String)name)}).toModelNode());
        this.copyCommonFlushingHandlerAttributes(handler, add);
        this.copy((AttributeDefinition)CommonAttributes.TARGET, handler, add);
        return add;
    }

    private ModelNode defineFileHandler(String name, ModelNode handler, PathAddress rootAddress) throws OperationFailedException {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"file-handler", (String)name)}).toModelNode());
        this.copyCommonFlushingHandlerAttributes(handler, add);
        this.copy((AttributeDefinition)CommonAttributes.APPEND, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.FILE, handler, add);
        return add;
    }

    private ModelNode defineCustomHandler(String name, ModelNode handler, PathAddress rootAddress) throws OperationFailedException {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"custom-handler", (String)name)}).toModelNode());
        this.copyCommonHandlerAttributes(handler, add);
        this.copy((AttributeDefinition)CommonAttributes.CLASS, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.MODULE, handler, add);
        this.copy("properties", handler, add);
        return add;
    }

    private ModelNode definePeriodicRotatingFileHandler(String name, ModelNode handler, PathAddress rootAddress) throws OperationFailedException {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"periodic-rotating-file-handler", (String)name)}).toModelNode());
        this.copyCommonFlushingHandlerAttributes(handler, add);
        this.copy((AttributeDefinition)CommonAttributes.FILE, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.APPEND, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.SUFFIX, handler, add);
        return add;
    }

    private ModelNode defineSizeRotatingFileHandler(String name, ModelNode handler, PathAddress rootAddress) throws OperationFailedException {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"size-rotating-file-handler", (String)name)}).toModelNode());
        this.copyCommonFlushingHandlerAttributes(handler, add);
        this.copy((AttributeDefinition)CommonAttributes.FILE, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.APPEND, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.MAX_BACKUP_INDEX, handler, add);
        this.copy((AttributeDefinition)CommonAttributes.ROTATE_SIZE, handler, add);
        return add;
    }

    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
    }

    private void copyCommonHandlerAttributes(ModelNode from, ModelNode to) throws OperationFailedException {
        this.copy((AttributeDefinition)CommonAttributes.NAME, from, to);
        this.copy((AttributeDefinition)CommonAttributes.ENCODING, from, to);
        this.copy((AttributeDefinition)CommonAttributes.FORMATTER, from, to);
        this.copy((AttributeDefinition)CommonAttributes.LEVEL, from, to);
        this.copy((AttributeDefinition)CommonAttributes.FILTER, from, to);
    }

    private void copyCommonFlushingHandlerAttributes(ModelNode from, ModelNode to) throws OperationFailedException {
        this.copyCommonHandlerAttributes(from, to);
        this.copy((AttributeDefinition)CommonAttributes.AUTOFLUSH, from, to);
    }

    private void copy(AttributeDefinition definition, ModelNode from, ModelNode to) throws OperationFailedException {
        this.copy(definition.getName(), from, to);
    }

    private void copy(String name, ModelNode from, ModelNode to) {
        to.get(name).set(from.get(name));
    }
}

