/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.AbstractLogHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.file.FileHandlers;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.FileHandler;

public abstract class AbstractFileHandlerWriteAttributeHandler<T extends FileHandler>
extends AbstractLogHandlerWriteAttributeHandler<T> {
    protected AbstractFileHandlerWriteAttributeHandler(AttributeDefinition ... attributes) {
        super(AbstractFileHandlerWriteAttributeHandler.join(attributes, new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.AUTOFLUSH, CommonAttributes.FILE}));
    }

    @Override
    protected boolean doApplyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, String handlerName, T handler) throws OperationFailedException {
        boolean requiresRestart = false;
        if (CommonAttributes.APPEND.getName().equals(attributeName)) {
            handler.setAppend(resolvedValue.asBoolean());
            return true;
        }
        if (CommonAttributes.AUTOFLUSH.getName().equals(attributeName)) {
            handler.setAutoFlush(resolvedValue.asBoolean());
        } else if (CommonAttributes.FILE.getName().equals(attributeName)) {
            requiresRestart = FileHandlers.changeFile(context, currentValue, resolvedValue, handlerName);
        }
        return requiresRestart;
    }

    @Override
    protected void doRevertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handlerName, T handler) throws OperationFailedException {
        if (CommonAttributes.APPEND.getName().equals(attributeName)) {
            handler.setAppend(valueToRestore.asBoolean());
        } else if (CommonAttributes.AUTOFLUSH.getName().equals(attributeName)) {
            handler.setAutoFlush(valueToRestore.asBoolean());
        } else if (CommonAttributes.FILE.getName().equals(attributeName)) {
            FileHandlers.revertFileChange(context, valueToRestore, handlerName);
        }
    }

    private static List<AttributeDefinition> join(AttributeDefinition[] supplied, AttributeDefinition ... added) {
        ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
        Collections.addAll(result, added);
        result.addAll(Arrays.asList(supplied));
        return result;
    }
}

