/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.osgi.metadata.DynamicOSGiMetaData;
import org.jboss.osgi.metadata.OSGiManifestMetaData;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.internal.MetadataMessages;
import org.osgi.framework.Version;

public class OSGiMetaDataBuilder {
    private DynamicOSGiMetaData metadata;
    private List<String> importPackages = new ArrayList<String>();
    private List<String> exportPackages = new ArrayList<String>();
    private List<String> dynamicImportPackages = new ArrayList<String>();

    public static OSGiMetaData load(InputStream input) throws IOException {
        if (input == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("input");
        }
        return OSGiMetaDataBuilder.load(new InputStreamReader(input));
    }

    public static OSGiMetaData load(Reader reader) throws IOException {
        if (reader == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("reader");
        }
        Properties props = new Properties();
        props.load(reader);
        return OSGiMetaDataBuilder.load(props);
    }

    public static OSGiMetaData load(Properties props) {
        if (props == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("props");
        }
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        for (Object key : props.keySet()) {
            Attributes.Name name = new Attributes.Name((String)key);
            mainAttributes.put(name, props.get(key));
        }
        return OSGiMetaDataBuilder.load(manifest);
    }

    public static OSGiMetaData load(Manifest manifest) {
        return new OSGiManifestMetaData(manifest);
    }

    public static OSGiMetaDataBuilder createBuilder(String symbolicName) {
        return new OSGiMetaDataBuilder(symbolicName, Version.emptyVersion);
    }

    public static OSGiMetaDataBuilder createBuilder(String symbolicName, Version version) {
        return new OSGiMetaDataBuilder(symbolicName, version);
    }

    private OSGiMetaDataBuilder(String symbolicName, Version version) {
        this.metadata = new DynamicOSGiMetaData(symbolicName, version);
    }

    public OSGiMetaDataBuilder setBundleManifestVersion(int version) {
        this.metadata.addMainAttribute("Bundle-ManifestVersion", "" + version);
        return this;
    }

    public OSGiMetaDataBuilder setBundleActivator(String value) {
        this.metadata.addMainAttribute("Bundle-Activator", value);
        return this;
    }

    public OSGiMetaDataBuilder addImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addImportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addImportPackages(String ... packages) {
        for (String aux : packages) {
            this.importPackages.add(aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addExportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addExportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addExportPackages(String ... packages) {
        for (String aux : packages) {
            this.exportPackages.add(aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addDynamicImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addDynamicImportPackages(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiMetaDataBuilder addDynamicImportPackages(String ... packages) {
        for (String aux : packages) {
            this.dynamicImportPackages.add(aux);
        }
        return this;
    }

    public OSGiMetaDataBuilder addMainAttribute(String key, String value) {
        this.metadata.addMainAttribute(key, value);
        return this;
    }

    public OSGiMetaData getOSGiMetaData() {
        int i;
        StringBuffer value;
        if (this.exportPackages.size() > 0) {
            value = new StringBuffer();
            for (i = 0; i < this.exportPackages.size(); ++i) {
                value.append(i > 0 ? "," : "");
                value.append(this.exportPackages.get(i));
            }
            this.metadata.addMainAttribute("Export-Package", value.toString());
        }
        if (this.importPackages.size() > 0) {
            value = new StringBuffer();
            for (i = 0; i < this.importPackages.size(); ++i) {
                value.append(i > 0 ? "," : "");
                value.append(this.importPackages.get(i));
            }
            this.metadata.addMainAttribute("Import-Package", value.toString());
        }
        if (this.dynamicImportPackages.size() > 0) {
            value = new StringBuffer();
            for (i = 0; i < this.dynamicImportPackages.size(); ++i) {
                value.append(i > 0 ? "," : "");
                value.append(this.dynamicImportPackages.get(i));
            }
            this.metadata.addMainAttribute("DynamicImport-Package", value.toString());
        }
        return this.metadata;
    }
}

