/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.builtin.BeanManagerBean;
import org.jboss.weld.bean.builtin.ContextBean;
import org.jboss.weld.bean.builtin.ConversationBean;
import org.jboss.weld.bean.builtin.EventBean;
import org.jboss.weld.bean.builtin.InjectionPointBean;
import org.jboss.weld.bean.builtin.InstanceBean;
import org.jboss.weld.bean.builtin.ee.DefaultValidatorBean;
import org.jboss.weld.bean.builtin.ee.DefaultValidatorFactoryBean;
import org.jboss.weld.bean.builtin.ee.PrincipalBean;
import org.jboss.weld.bean.builtin.ee.UserTransactionBean;
import org.jboss.weld.bootstrap.BeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.jsf.JsfApiAbstraction;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.Enabled;
import org.jboss.weld.manager.InjectionTargetValidator;
import org.jboss.weld.metadata.FilterPredicate;
import org.jboss.weld.metadata.ScanningPredicate;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.resources.DefaultResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.reflection.instantiation.DefaultInstantiatorFactory;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;
import org.jboss.weld.validation.spi.ValidationServices;
import org.jboss.weld.ws.WSApiAbstraction;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployment {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private final BeanDeploymentArchive beanDeploymentArchive;
    private final BeanManagerImpl beanManager;
    private final BeanDeployer beanDeployer;
    private final Collection<ContextHolder<? extends Context>> contexts;

    public BeanDeployment(BeanDeploymentArchive beanDeploymentArchive, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices, Collection<ContextHolder<? extends Context>> contexts) {
        InstantiatorFactory factory;
        this.beanDeploymentArchive = beanDeploymentArchive;
        EjbDescriptors ejbDescriptors = new EjbDescriptors();
        ServiceRegistry registry = beanDeploymentArchive.getServices();
        registry.add(EjbDescriptors.class, (Service)ejbDescriptors);
        ResourceLoader resourceLoader = (ResourceLoader)registry.get(ResourceLoader.class);
        if (resourceLoader == null) {
            resourceLoader = DefaultResourceLoader.INSTANCE;
            registry.add(ResourceLoader.class, (Service)resourceLoader);
        }
        if ((factory = (InstantiatorFactory)registry.get(InstantiatorFactory.class)) == null) {
            registry.add(InstantiatorFactory.class, (Service)new DefaultInstantiatorFactory());
        }
        SimpleServiceRegistry services = new SimpleServiceRegistry();
        services.addAll((Collection)deploymentServices.entrySet());
        services.addAll((Collection)registry.entrySet());
        services.add(EJBApiAbstraction.class, (Service)new EJBApiAbstraction(resourceLoader));
        services.add(JsfApiAbstraction.class, (Service)new JsfApiAbstraction(resourceLoader));
        services.add(PersistenceApiAbstraction.class, (Service)new PersistenceApiAbstraction(resourceLoader));
        services.add(WSApiAbstraction.class, (Service)new WSApiAbstraction(resourceLoader));
        this.beanManager = BeanManagerImpl.newManager(deploymentManager, beanDeploymentArchive.getId(), (ServiceRegistry)services, Enabled.of(beanDeploymentArchive.getBeansXml(), resourceLoader));
        services.add(InjectionTargetValidator.class, (Service)new InjectionTargetValidator(this.beanManager));
        log.debug((Enum)BootstrapMessage.ENABLED_ALTERNATIVES, new Object[]{this.beanManager, this.beanManager.getEnabled().getAlternativeClasses(), this.beanManager.getEnabled().getAlternativeStereotypes()});
        log.debug((Enum)BootstrapMessage.ENABLED_DECORATORS, new Object[]{this.beanManager, this.beanManager.getEnabled().getDecorators()});
        log.debug((Enum)BootstrapMessage.ENABLED_INTERCEPTORS, new Object[]{this.beanManager, this.beanManager.getEnabled().getInterceptors()});
        if (this.beanManager.getServices().contains(EjbServices.class)) {
            ejbDescriptors.addAll(beanDeploymentArchive.getEjbs());
        }
        this.beanDeployer = new BeanDeployer(this.beanManager, ejbDescriptors, deploymentServices);
        this.beanManager.addBean(new BeanManagerBean(this.beanManager));
        this.contexts = contexts;
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public BeanDeployer getBeanDeployer() {
        return this.beanDeployer;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive() {
        return this.beanDeploymentArchive;
    }

    protected Iterable<String> loadClasses() {
        Collection classNames;
        Function<Metadata<Filter>, Predicate<String>> filterToPredicateFunction = new Function<Metadata<Filter>, Predicate<String>>(){
            ResourceLoader resourceLoader;
            {
                this.resourceLoader = (ResourceLoader)BeanDeployment.this.getBeanManager().getServices().get(ResourceLoader.class);
            }

            public Predicate<String> apply(Metadata<Filter> from) {
                return new FilterPredicate(from, this.resourceLoader);
            }
        };
        if (this.getBeanDeploymentArchive().getBeansXml() != null && this.getBeanDeploymentArchive().getBeansXml().getScanning() != null) {
            Collection<Object> includeFilters = this.getBeanDeploymentArchive().getBeansXml().getScanning().getIncludes() != null ? this.getBeanDeploymentArchive().getBeansXml().getScanning().getIncludes() : Collections.emptyList();
            Collection<Object> excludeFilters = this.getBeanDeploymentArchive().getBeansXml().getScanning().getExcludes() != null ? this.getBeanDeploymentArchive().getBeansXml().getScanning().getExcludes() : Collections.emptyList();
            ArrayList includes = new ArrayList(Collections2.transform(includeFilters, (Function)filterToPredicateFunction));
            ArrayList excludes = new ArrayList(Collections2.transform(excludeFilters, (Function)filterToPredicateFunction));
            ScanningPredicate filters = new ScanningPredicate(includes, excludes);
            classNames = Collections2.filter((Collection)this.beanDeploymentArchive.getBeanClasses(), filters);
        } else {
            classNames = this.beanDeploymentArchive.getBeanClasses();
        }
        return classNames;
    }

    public void createBeans(Environment environment) {
        this.beanDeployer.addClasses(this.loadClasses());
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new InjectionPointBean(this.beanManager));
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new EventBean(this.beanManager));
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new InstanceBean(this.beanManager));
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new ConversationBean(this.beanManager));
        if (this.beanManager.getServices().contains(TransactionServices.class)) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new UserTransactionBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(SecurityServices.class)) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new PrincipalBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(ValidationServices.class)) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new DefaultValidatorBean(this.beanManager));
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new DefaultValidatorFactoryBean(this.beanManager));
        }
        for (ContextHolder<? extends Context> context : this.contexts) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(ContextBean.of(context, this.beanManager));
        }
        this.beanDeployer.createBeans();
        BeansClosure closure = BeansClosure.getClosure(this.beanManager);
        closure.addEnvironment((BeanDeployerEnvironment)this.beanDeployer.getEnvironment());
    }

    public void deploySpecialized(Environment environment) {
        this.beanDeployer.deploySpecialized();
    }

    public void deployBeans(Environment environment) {
        this.beanDeployer.deploy();
    }

    public void afterBeanDiscovery(Environment environment) {
        this.doAfterBeanDiscovery(this.beanManager.getBeans());
        this.doAfterBeanDiscovery(this.beanManager.getDecorators());
        this.doAfterBeanDiscovery(this.beanManager.getInterceptors());
    }

    private void doAfterBeanDiscovery(List<? extends Bean<?>> beanList) {
        for (Bean<?> bean : beanList) {
            if (!(bean instanceof RIBean)) continue;
            ((RIBean)bean).initializeAfterBeanDiscovery();
        }
    }
}

