/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.core.client.impl.ClientConsumerInternal;
import org.hornetq.core.client.impl.ClientLargeMessageInternal;
import org.hornetq.core.client.impl.ClientMessageInternal;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.client.impl.CompressedLargeMessageControllerImpl;
import org.hornetq.core.client.impl.LargeMessageControllerImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.impl.wireformat.SessionConsumerCloseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveLargeMessage;
import org.hornetq.utils.Future;
import org.hornetq.utils.LinkedListIterator;
import org.hornetq.utils.PriorityLinkedList;
import org.hornetq.utils.PriorityLinkedListImpl;
import org.hornetq.utils.TokenBucketLimiter;

public class ClientConsumerImpl
implements ClientConsumerInternal {
    private static final Logger log = Logger.getLogger(ClientConsumerImpl.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private static final boolean trace = log.isTraceEnabled();
    public static final long CLOSE_TIMEOUT_MILLISECONDS = 10000L;
    public static final int NUM_PRIORITIES = 10;
    public static final SimpleString FORCED_DELIVERY_MESSAGE = new SimpleString("_hornetq.forced.delivery.seq");
    private final ClientSessionInternal session;
    private final Channel channel;
    private final long id;
    private final SimpleString filterString;
    private final SimpleString queueName;
    private final boolean browseOnly;
    private final Executor sessionExecutor;
    private final Executor flowControlExecutor;
    private final int clientWindowSize;
    private final int ackBatchSize;
    private final PriorityLinkedList<ClientMessageInternal> buffer = new PriorityLinkedListImpl<ClientMessageInternal>(10);
    private final Runner runner = new Runner();
    private LargeMessageControllerImpl currentLargeMessageController;
    private ClientMessageInternal largeMessageReceived;
    private final TokenBucketLimiter rateLimiter;
    private volatile Thread receiverThread;
    private volatile Thread onMessageThread;
    private volatile MessageHandler handler;
    private volatile boolean closing;
    private volatile boolean closed;
    private volatile int creditsToSend;
    private volatile boolean failedOver;
    private volatile Exception lastException;
    private volatile int ackBytes;
    private volatile ClientMessageInternal lastAckedMessage;
    private boolean stopped = false;
    private long forceDeliveryCount;
    private final SessionQueueQueryResponseMessage queueInfo;
    private volatile boolean ackIndividually;
    private final ClassLoader contextClassLoader;

    public ClientConsumerImpl(ClientSessionInternal session, long id, SimpleString queueName, SimpleString filterString, boolean browseOnly, int clientWindowSize, int ackBatchSize, TokenBucketLimiter rateLimiter, Executor executor, Executor flowControlExecutor, Channel channel, SessionQueueQueryResponseMessage queueInfo, ClassLoader contextClassLoader) {
        this.id = id;
        this.queueName = queueName;
        this.filterString = filterString;
        this.browseOnly = browseOnly;
        this.channel = channel;
        this.session = session;
        this.rateLimiter = rateLimiter;
        this.sessionExecutor = executor;
        this.clientWindowSize = clientWindowSize;
        this.ackBatchSize = ackBatchSize;
        this.queueInfo = queueInfo;
        this.contextClassLoader = contextClassLoader;
        this.flowControlExecutor = flowControlExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientMessage receive(long timeout, boolean forcingDelivery) throws HornetQException {
        this.checkClosed();
        if (this.largeMessageReceived != null) {
            this.largeMessageReceived.discardBody();
            this.largeMessageReceived = null;
        }
        if (this.rateLimiter != null) {
            this.rateLimiter.limit();
        }
        if (this.handler != null) {
            throw new HornetQException(104, "Cannot call receive(...) - a MessageHandler is set");
        }
        if (this.clientWindowSize == 0) {
            this.startSlowConsumer();
        }
        this.receiverThread = Thread.currentThread();
        boolean deliveryForced = false;
        boolean callForceDelivery = false;
        long start = -1L;
        long toWait = timeout == 0L ? Long.MAX_VALUE : timeout;
        try {
            ClientConsumerImpl clientConsumerImpl;
            block31: {
                ClientMessageInternal m;
                block32: {
                    while (true) {
                        m = null;
                        clientConsumerImpl = this;
                        synchronized (clientConsumerImpl) {
                            while ((this.stopped || (m = this.buffer.poll()) == null) && !this.closed && toWait > 0L) {
                                if (start == -1L) {
                                    start = System.currentTimeMillis();
                                }
                                if (m == null && forcingDelivery) {
                                    if (this.stopped) break;
                                    if (!deliveryForced) {
                                        callForceDelivery = true;
                                        break;
                                    }
                                }
                                try {
                                    this.wait(toWait);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                if (m != null || this.closed) break;
                                long now = System.currentTimeMillis();
                                toWait -= now - start;
                                start = now;
                            }
                        }
                        if (this.failedOver) {
                            if (m == null) {
                                this.failedOver = false;
                                deliveryForced = false;
                                toWait = timeout == 0L ? Long.MAX_VALUE : timeout;
                                continue;
                            }
                            this.failedOver = false;
                        }
                        if (callForceDelivery) {
                            if (isTrace) {
                                log.trace("Forcing delivery");
                            }
                            this.session.forceDelivery(this.id, this.forceDeliveryCount++);
                            callForceDelivery = false;
                            deliveryForced = true;
                            continue;
                        }
                        if (m == null) break block31;
                        this.session.workDone();
                        if (m.containsProperty(FORCED_DELIVERY_MESSAGE)) {
                            long seq = m.getLongProperty(FORCED_DELIVERY_MESSAGE);
                            if (forcingDelivery && deliveryForced && seq == this.forceDeliveryCount - 1L) {
                                this.resetIfSlowConsumer();
                                if (isTrace) {
                                    log.trace("There was nothing on the queue, leaving it now:: returning null");
                                }
                                ClientMessage clientMessage = null;
                                return clientMessage;
                            }
                            if (!isTrace) continue;
                            log.trace("Ignored force delivery answer as it belonged to another call");
                            continue;
                        }
                        boolean expired = m.isExpired();
                        this.flowControlBeforeConsumption(m);
                        if (!expired) break block32;
                        m.discardBody();
                        this.session.expire(this.id, m.getMessageID());
                        if (this.clientWindowSize == 0) {
                            this.startSlowConsumer();
                        }
                        if (toWait <= 0L) break;
                    }
                    ClientMessage clientMessage = null;
                    return clientMessage;
                }
                if (m.isLargeMessage()) {
                    this.largeMessageReceived = m;
                }
                if (isTrace) {
                    log.trace("Returning " + m);
                }
                ClientMessageInternal clientMessageInternal = m;
                return clientMessageInternal;
            }
            if (isTrace) {
                log.trace("Returning null");
            }
            this.resetIfSlowConsumer();
            clientConsumerImpl = null;
            return clientConsumerImpl;
        }
        finally {
            this.receiverThread = null;
        }
    }

    @Override
    public ClientMessage receive(long timeout) throws HornetQException {
        ClientMessage msg = this.receive(timeout, false);
        if (msg == null && !this.closed) {
            msg = this.receive(0L, true);
        }
        return msg;
    }

    @Override
    public ClientMessage receive() throws HornetQException {
        return this.receive(0L, false);
    }

    @Override
    public ClientMessage receiveImmediate() throws HornetQException {
        return this.receive(0L, true);
    }

    @Override
    public MessageHandler getMessageHandler() throws HornetQException {
        this.checkClosed();
        return this.handler;
    }

    @Override
    public synchronized void setMessageHandler(MessageHandler theHandler) throws HornetQException {
        boolean noPreviousHandler;
        this.checkClosed();
        if (this.receiverThread != null) {
            throw new HornetQException(104, "Cannot set MessageHandler - consumer is in receive(...)");
        }
        boolean bl = noPreviousHandler = this.handler == null;
        if (this.handler != theHandler && this.clientWindowSize == 0) {
            this.startSlowConsumer();
        }
        this.handler = theHandler;
        if (this.handler != null && noPreviousHandler) {
            this.requeueExecutors();
        } else if (this.handler == null && !noPreviousHandler) {
            this.waitForOnMessageToComplete(true);
        }
    }

    @Override
    public void close() throws HornetQException {
        this.doCleanUp(true);
    }

    @Override
    public void cleanUp() {
        try {
            this.doCleanUp(false);
        }
        catch (HornetQException e) {
            log.warn("problem cleaning up: " + this);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void stop() throws HornetQException {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean waitForOnMessage) throws HornetQException {
        this.waitForOnMessageToComplete(waitForOnMessage);
        ClientConsumerImpl clientConsumerImpl = this;
        synchronized (clientConsumerImpl) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
        }
    }

    @Override
    public void clearAtFailover() {
        this.clearBuffer();
        this.lastAckedMessage = null;
        this.creditsToSend = 0;
        this.failedOver = true;
        this.ackIndividually = false;
    }

    @Override
    public synchronized void start() {
        this.stopped = false;
        this.requeueExecutors();
    }

    @Override
    public Exception getLastException() {
        return this.lastException;
    }

    @Override
    public ClientSessionInternal getSession() {
        return this.session;
    }

    @Override
    public SessionQueueQueryResponseMessage getQueueInfo() {
        return this.queueInfo;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public SimpleString getFilterString() {
        return this.filterString;
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }

    @Override
    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    @Override
    public synchronized void handleMessage(ClientMessageInternal message) throws Exception {
        if (this.closing) {
            return;
        }
        ClientMessageInternal messageToHandle = message;
        if (messageToHandle.getAddress() == null) {
            messageToHandle.setAddressTransient(this.queueInfo.getAddress());
        }
        messageToHandle.onReceipt(this);
        if (message.getPriority() != 4) {
            this.ackIndividually = true;
        }
        this.buffer.addTail(messageToHandle, messageToHandle.getPriority());
        if (this.handler != null) {
            if (!this.stopped) {
                this.queueExecutor();
            }
        } else {
            this.notify();
        }
    }

    @Override
    public synchronized void handleLargeMessage(SessionReceiveLargeMessage packet) throws Exception {
        if (this.closing) {
            return;
        }
        ClientLargeMessageInternal currentChunkMessage = (ClientLargeMessageInternal)packet.getLargeMessage();
        currentChunkMessage.setFlowControlSize(packet.getPacketSize());
        currentChunkMessage.setDeliveryCount(packet.getDeliveryCount());
        File largeMessageCache = null;
        if (this.session.isCacheLargeMessageClient()) {
            largeMessageCache = File.createTempFile("tmp-large-message-" + currentChunkMessage.getMessageID() + "-", ".tmp");
            largeMessageCache.deleteOnExit();
        }
        this.currentLargeMessageController = new LargeMessageControllerImpl(this, packet.getLargeMessageSize(), 5, largeMessageCache);
        if (currentChunkMessage.isCompressed()) {
            currentChunkMessage.setLargeMessageController(new CompressedLargeMessageControllerImpl(this.currentLargeMessageController));
        } else {
            currentChunkMessage.setLargeMessageController(this.currentLargeMessageController);
        }
        this.handleMessage(currentChunkMessage);
    }

    @Override
    public synchronized void handleLargeMessageContinuation(SessionReceiveContinuationMessage chunk) throws Exception {
        if (this.closing) {
            return;
        }
        if (this.currentLargeMessageController == null) {
            if (log.isTraceEnabled()) {
                log.trace("Sending back credits for largeController = null " + chunk.getPacketSize());
            }
            this.flowControl(chunk.getPacketSize(), false);
        } else {
            this.currentLargeMessageController.addPacket(chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(boolean waitForOnMessage) throws HornetQException {
        ClientConsumerImpl clientConsumerImpl = this;
        synchronized (clientConsumerImpl) {
            LinkedListIterator<ClientMessageInternal> iter = this.buffer.iterator();
            while (iter.hasNext()) {
                try {
                    ClientMessageInternal message = (ClientMessageInternal)iter.next();
                    if (message.isLargeMessage()) {
                        ClientLargeMessageInternal largeMessage = (ClientLargeMessageInternal)message;
                        largeMessage.getLargeMessageController().cancel();
                    }
                    this.flowControlBeforeConsumption(message);
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), e);
                }
            }
            this.clearBuffer();
            try {
                this.resetLargeMessageController();
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
        }
        this.waitForOnMessageToComplete(waitForOnMessage);
    }

    private void resetLargeMessageController() {
        LargeMessageControllerImpl controller = this.currentLargeMessageController;
        if (controller != null) {
            controller.cancel();
            this.currentLargeMessageController = null;
        }
    }

    @Override
    public int getClientWindowSize() {
        return this.clientWindowSize;
    }

    @Override
    public int getBufferSize() {
        return this.buffer.size();
    }

    @Override
    public void acknowledge(ClientMessage message) throws HornetQException {
        ClientMessageInternal cmi = (ClientMessageInternal)message;
        if (this.ackIndividually) {
            if (this.lastAckedMessage != null) {
                this.flushAcks();
            }
            this.session.individualAcknowledge(this.id, message.getMessageID());
        } else {
            this.ackBytes += message.getEncodeSize();
            if (this.ackBytes >= this.ackBatchSize) {
                this.doAck(cmi);
            } else {
                this.lastAckedMessage = cmi;
            }
        }
    }

    @Override
    public void flushAcks() throws HornetQException {
        if (this.lastAckedMessage != null) {
            this.doAck(this.lastAckedMessage);
        }
    }

    @Override
    public void flowControl(int messageBytes, boolean discountSlowConsumer) throws HornetQException {
        if (this.clientWindowSize >= 0) {
            this.creditsToSend += messageBytes;
            if (this.creditsToSend >= this.clientWindowSize) {
                if (this.clientWindowSize == 0 && discountSlowConsumer) {
                    if (trace) {
                        log.trace("FlowControl::Sending " + this.creditsToSend + " -1, for slow consumer");
                    }
                    int credits = this.creditsToSend - 1;
                    this.creditsToSend = 0;
                    if (credits > 0) {
                        this.sendCredits(credits);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Sending " + messageBytes + " from flow-control");
                    }
                    int credits = this.creditsToSend;
                    this.creditsToSend = 0;
                    if (credits > 0) {
                        this.sendCredits(credits);
                    }
                }
            }
        }
    }

    private void startSlowConsumer() {
        if (trace) {
            log.trace("Sending 1 credit to start delivering of one message to slow consumer");
        }
        this.sendCredits(1);
    }

    private void resetIfSlowConsumer() {
        if (this.clientWindowSize == 0) {
            this.sendCredits(0);
            final CountDownLatch latch = new CountDownLatch(1);
            this.flowControlExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            });
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void requeueExecutors() {
        for (int i = 0; i < this.buffer.size(); ++i) {
            this.queueExecutor();
        }
    }

    private void queueExecutor() {
        if (trace) {
            log.trace("Adding Runner on Executor for delivery");
        }
        this.sessionExecutor.execute(this.runner);
    }

    private void sendCredits(final int credits) {
        this.flowControlExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ClientConsumerImpl.this.channel.send(new SessionConsumerFlowCreditMessage(ClientConsumerImpl.this.id, credits));
            }
        });
    }

    private void waitForOnMessageToComplete(boolean waitForOnMessage) {
        if (this.handler == null) {
            return;
        }
        if (!waitForOnMessage || Thread.currentThread() == this.onMessageThread) {
            return;
        }
        Future future = new Future();
        this.sessionExecutor.execute(future);
        boolean ok = future.await(10000L);
        if (!ok) {
            log.warn("Executor couldn't finish its operation before timeout : " + this.sessionExecutor.toString());
            log.warn("Timed out waiting for handler to complete processing", new Exception("trace"));
        }
    }

    private void checkClosed() throws HornetQException {
        if (this.closed) {
            throw new HornetQException(102, "Consumer is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnMessage() throws Exception {
        block12: {
            block14: {
                ClientMessageInternal message;
                block13: {
                    if (this.closing || this.stopped) {
                        return;
                    }
                    this.session.workDone();
                    MessageHandler theHandler = this.handler;
                    if (theHandler == null) break block12;
                    if (this.rateLimiter != null) {
                        this.rateLimiter.limit();
                    }
                    this.failedOver = false;
                    ClientConsumerImpl clientConsumerImpl = this;
                    synchronized (clientConsumerImpl) {
                        message = this.buffer.poll();
                    }
                    if (message == null) break block12;
                    if (message.containsProperty(FORCED_DELIVERY_MESSAGE)) {
                        return;
                    }
                    boolean expired = message.isExpired();
                    this.flowControlBeforeConsumption(message);
                    if (expired) break block13;
                    this.onMessageThread = Thread.currentThread();
                    if (trace) {
                        log.trace("Calling handler.onMessage");
                    }
                    ClassLoader originalLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(ClientConsumerImpl.this.contextClassLoader);
                            return originalLoader;
                        }
                    });
                    try {
                        theHandler.onMessage(message);
                    }
                    catch (Throwable throwable) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(originalLoader){
                            final /* synthetic */ ClassLoader val$originalLoader;
                            {
                                this.val$originalLoader = classLoader;
                            }

                            @Override
                            public Object run() {
                                Thread.currentThread().setContextClassLoader(this.val$originalLoader);
                                return null;
                            }
                        });
                        throw throwable;
                    }
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    if (trace) {
                        log.trace("Handler.onMessage done");
                    }
                    if (message.isLargeMessage()) {
                        message.discardBody();
                    }
                    break block14;
                }
                this.session.expire(this.id, message.getMessageID());
            }
            if (this.clientWindowSize == 0) {
                this.startSlowConsumer();
            }
        }
    }

    private void flowControlBeforeConsumption(ClientMessageInternal message) throws HornetQException {
        if (message.getFlowControlSize() != 0) {
            this.flowControl(message.getFlowControlSize(), !message.isLargeMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanUp(boolean sendCloseMessage) throws HornetQException {
        try {
            if (this.closed) {
                return;
            }
            this.closing = true;
            this.resetLargeMessageController();
            this.waitForOnMessageToComplete(true);
            this.closed = true;
            ClientConsumerImpl clientConsumerImpl = this;
            synchronized (clientConsumerImpl) {
                if (this.receiverThread != null) {
                    this.notify();
                }
                this.handler = null;
                this.receiverThread = null;
            }
            this.flushAcks();
            this.clearBuffer();
            if (sendCloseMessage) {
                this.channel.sendBlocking(new SessionConsumerCloseMessage(this.id));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.session.removeConsumer(this);
    }

    private void clearBuffer() {
        this.buffer.clear();
    }

    private void doAck(ClientMessageInternal message) throws HornetQException {
        this.ackBytes = 0;
        this.lastAckedMessage = null;
        this.session.acknowledge(this.id, message.getMessageID());
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            try {
                ClientConsumerImpl.this.callOnMessage();
            }
            catch (Exception e) {
                log.error("Failed to call onMessage()", e);
                ClientConsumerImpl.this.lastException = e;
            }
        }
    }
}

