/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.invm;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.impl.invm.InVMAcceptor;

public class InVMRegistry {
    private static final Logger log = Logger.getLogger(InVMRegistry.class);
    public static final InVMRegistry instance = new InVMRegistry();
    private final ConcurrentMap<Integer, InVMAcceptor> acceptors = new ConcurrentHashMap<Integer, InVMAcceptor>();

    public void registerAcceptor(int id, InVMAcceptor acceptor) {
        if (this.acceptors.putIfAbsent(id, acceptor) != null) {
            throw new IllegalArgumentException("Acceptor with id " + id + " already registered");
        }
    }

    public void unregisterAcceptor(int id) {
        if (this.acceptors.remove(id) == null) {
            throw new IllegalArgumentException("Acceptor with id " + id + " not registered");
        }
    }

    public InVMAcceptor getAcceptor(int id) {
        return (InVMAcceptor)this.acceptors.get(id);
    }

    public void clear() {
        this.acceptors.clear();
    }

    public int size() {
        return this.acceptors.size();
    }
}

