/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.logging.Logger;
import org.jboss.security.auth.spi.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyLoginModule
implements LoginModule {
    private static final String MODULE_NAME = "moduleName";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"moduleName"};
    protected Logger log;
    private String moduleName;
    private LoginModule delegate;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.log = Logger.getLogger(this.getClass());
        HashSet<String> validOptions = new HashSet<String>(Arrays.asList(ALL_VALID_OPTIONS));
        for (String key : options.keySet()) {
            if (validOptions.contains(key)) continue;
            this.log.warn((Object)("Invalid or misspelled option: " + key));
        }
        this.moduleName = (String)options.get(MODULE_NAME);
        if (this.moduleName == null) {
            System.out.println("Required moduleName option not given");
            return;
        }
        ClassLoader loader = SecurityActions.getContextClassLoader();
        try {
            Class<?> clazz = loader.loadClass(this.moduleName);
            this.delegate = (LoginModule)clazz.newInstance();
        }
        catch (Throwable t) {
            System.out.println("ProxyLoginModule failed to load: " + this.moduleName);
            t.printStackTrace();
            return;
        }
        this.delegate.initialize(subject, callbackHandler, sharedState, options);
    }

    @Override
    public boolean login() throws LoginException {
        if (this.moduleName == null) {
            throw new LoginException("PB00015: Null Value:Required moduleName option not given");
        }
        if (this.delegate == null) {
            throw new LoginException("PB00015: Null Value:Failed to load LoginModule: " + this.moduleName);
        }
        return this.delegate.login();
    }

    @Override
    public boolean commit() throws LoginException {
        boolean ok = false;
        if (this.delegate != null) {
            ok = this.delegate.commit();
        }
        return ok;
    }

    @Override
    public boolean abort() throws LoginException {
        boolean ok = true;
        if (this.delegate != null) {
            ok = this.delegate.abort();
        }
        return ok;
    }

    @Override
    public boolean logout() throws LoginException {
        boolean ok = true;
        if (this.delegate != null) {
            ok = this.delegate.logout();
        }
        return ok;
    }
}

