/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class SchemaLocationRemoveHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove-schema-location";
    public static final SchemaLocationRemoveHandler INSTANCE = new SchemaLocationRemoveHandler();
    private final ParameterValidator typeValidator = new ModelTypeValidator(ModelType.STRING);

    public static ModelNode getRemoveSchemaLocationOperation(ModelNode address, String schemaURI) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("uri").set(schemaURI);
        return op;
    }

    private SchemaLocationRemoveHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode param = operation.get("uri");
        this.typeValidator.validateParameter("uri", param);
        ModelNode locations = model.get("schema-locations");
        Property toRemove = null;
        ModelNode newList = new ModelNode().setEmptyList();
        String uri = param.asString();
        if (locations.isDefined()) {
            for (Property location : locations.asPropertyList()) {
                if (uri.equals(location.getName())) {
                    toRemove = location;
                    continue;
                }
                newList.add(location.getName(), location.getValue());
            }
        }
        if (toRemove == null) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.schemaNotFound(uri)));
        }
        locations.set(newList);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getRemoveSchemaLocationOperation(locale);
    }
}

