/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml.ext.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.saml.ext.bean.ActionBean;
import org.apache.ws.security.saml.ext.bean.AttributeBean;
import org.apache.ws.security.saml.ext.bean.AttributeStatementBean;
import org.apache.ws.security.saml.ext.bean.AuthDecisionStatementBean;
import org.apache.ws.security.saml.ext.bean.AuthenticationStatementBean;
import org.apache.ws.security.saml.ext.bean.ConditionsBean;
import org.apache.ws.security.saml.ext.bean.KeyInfoBean;
import org.apache.ws.security.saml.ext.bean.SubjectBean;
import org.apache.ws.security.saml.ext.bean.SubjectLocalityBean;
import org.apache.ws.security.saml.ext.builder.SAML1ComponentBuilder;
import org.apache.ws.security.util.UUIDGenerator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Action;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.AuthzDecisionStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.DecisionTypeEnumeration;
import org.opensaml.saml2.core.Evidence;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.KeyInfoConfirmationDataType;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.core.SubjectLocality;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.signature.KeyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2ComponentBuilder {
    private static SAMLObjectBuilder<Assertion> assertionBuilder;
    private static SAMLObjectBuilder<Issuer> issuerBuilder;
    private static SAMLObjectBuilder<Subject> subjectBuilder;
    private static SAMLObjectBuilder<NameID> nameIdBuilder;
    private static SAMLObjectBuilder<SubjectConfirmation> subjectConfirmationBuilder;
    private static SAMLObjectBuilder<Conditions> conditionsBuilder;
    private static SAMLObjectBuilder<SubjectConfirmationData> subjectConfirmationDataBuilder;
    private static SAMLObjectBuilder<KeyInfoConfirmationDataType> keyInfoConfirmationDataBuilder;
    private static SAMLObjectBuilder<AuthnStatement> authnStatementBuilder;
    private static SAMLObjectBuilder<AuthnContext> authnContextBuilder;
    private static SAMLObjectBuilder<AuthnContextClassRef> authnContextClassRefBuilder;
    private static SAMLObjectBuilder<AttributeStatement> attributeStatementBuilder;
    private static SAMLObjectBuilder<Attribute> attributeBuilder;
    private static XSStringBuilder stringBuilder;
    private static SAMLObjectBuilder<AudienceRestriction> audienceRestrictionBuilder;
    private static SAMLObjectBuilder<Audience> audienceBuilder;
    private static SAMLObjectBuilder<AuthzDecisionStatement> authorizationDecisionStatementBuilder;
    private static SAMLObjectBuilder<Action> actionElementBuilder;
    private static XMLObjectBuilderFactory builderFactory;
    private static SAMLObjectBuilder<SubjectLocality> subjectLocalityBuilder;

    public static Assertion createAssertion() {
        if (assertionBuilder == null && (assertionBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME)) == null) {
            throw new IllegalStateException("OpenSaml engine not initialized. Please make sure to initialize the OpenSaml engine prior using it");
        }
        Assertion assertion = (Assertion)assertionBuilder.buildObject(Assertion.DEFAULT_ELEMENT_NAME, Assertion.TYPE_NAME);
        assertion.setID("_" + UUIDGenerator.getUUID());
        assertion.setVersion(SAMLVersion.VERSION_20);
        assertion.setIssueInstant(new DateTime());
        return assertion;
    }

    public static Issuer createIssuer(String issuerValue) {
        if (issuerBuilder == null) {
            issuerBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        }
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(issuerValue);
        return issuer;
    }

    public static Conditions createConditions(ConditionsBean conditionsBean) {
        if (conditionsBuilder == null) {
            conditionsBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        }
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        if (conditionsBean == null) {
            DateTime newNotBefore = new DateTime();
            conditions.setNotBefore(newNotBefore);
            conditions.setNotOnOrAfter(newNotBefore.plusMinutes(5));
            return conditions;
        }
        int tokenPeriodMinutes = conditionsBean.getTokenPeriodMinutes();
        DateTime notBefore = conditionsBean.getNotBefore();
        DateTime notAfter = conditionsBean.getNotAfter();
        if (notBefore != null && notAfter != null) {
            if (notBefore.isAfter((ReadableInstant)notAfter)) {
                throw new IllegalStateException("The value of notBefore may not be after the value of notAfter");
            }
            conditions.setNotBefore(notBefore);
            conditions.setNotOnOrAfter(notAfter);
        } else {
            DateTime newNotBefore = new DateTime();
            conditions.setNotBefore(newNotBefore);
            if (tokenPeriodMinutes <= 0) {
                tokenPeriodMinutes = 5;
            }
            conditions.setNotOnOrAfter(newNotBefore.plusMinutes(tokenPeriodMinutes));
        }
        if (conditionsBean.getAudienceURI() != null) {
            AudienceRestriction audienceRestriction = SAML2ComponentBuilder.createAudienceRestriction(conditionsBean.getAudienceURI());
            conditions.getAudienceRestrictions().add(audienceRestriction);
        }
        return conditions;
    }

    public static AudienceRestriction createAudienceRestriction(String audienceURI) {
        if (audienceRestrictionBuilder == null) {
            audienceRestrictionBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AudienceRestriction.DEFAULT_ELEMENT_NAME);
        }
        if (audienceBuilder == null) {
            audienceBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Audience.DEFAULT_ELEMENT_NAME);
        }
        AudienceRestriction audienceRestriction = (AudienceRestriction)audienceRestrictionBuilder.buildObject();
        Audience audience = (Audience)audienceBuilder.buildObject();
        audience.setAudienceURI(audienceURI);
        audienceRestriction.getAudiences().add(audience);
        return audienceRestriction;
    }

    public static List<AuthnStatement> createAuthnStatement(List<AuthenticationStatementBean> authBeans) {
        ArrayList<AuthnStatement> authnStatements = new ArrayList<AuthnStatement>();
        if (authnStatementBuilder == null) {
            authnStatementBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnStatement.DEFAULT_ELEMENT_NAME);
        }
        if (authnContextBuilder == null) {
            authnContextBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnContext.DEFAULT_ELEMENT_NAME);
        }
        if (authnContextClassRefBuilder == null) {
            authnContextClassRefBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        }
        if (subjectLocalityBuilder == null) {
            subjectLocalityBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(SubjectLocality.DEFAULT_ELEMENT_NAME);
        }
        if (authBeans != null && authBeans.size() > 0) {
            for (AuthenticationStatementBean statementBean : authBeans) {
                AuthnStatement authnStatement = (AuthnStatement)authnStatementBuilder.buildObject();
                DateTime authInstant = statementBean.getAuthenticationInstant();
                if (authInstant == null) {
                    authInstant = new DateTime();
                }
                authnStatement.setAuthnInstant(authInstant);
                if (statementBean.getSessionIndex() != null) {
                    authnStatement.setSessionIndex(statementBean.getSessionIndex());
                }
                AuthnContextClassRef authnContextClassRef = (AuthnContextClassRef)authnContextClassRefBuilder.buildObject();
                authnContextClassRef.setAuthnContextClassRef(SAML2ComponentBuilder.transformAuthenticationMethod(statementBean.getAuthenticationMethod()));
                AuthnContext authnContext = (AuthnContext)authnContextBuilder.buildObject();
                authnContext.setAuthnContextClassRef(authnContextClassRef);
                authnStatement.setAuthnContext(authnContext);
                SubjectLocalityBean subjectLocalityBean = statementBean.getSubjectLocality();
                if (subjectLocalityBean != null) {
                    SubjectLocality subjectLocality = (SubjectLocality)subjectLocalityBuilder.buildObject();
                    subjectLocality.setDNSName(subjectLocalityBean.getDnsAddress());
                    subjectLocality.setAddress(subjectLocalityBean.getIpAddress());
                    authnStatement.setSubjectLocality(subjectLocality);
                }
                authnStatements.add(authnStatement);
            }
        }
        return authnStatements;
    }

    private static String transformAuthenticationMethod(String sourceMethod) {
        String transformedMethod = "";
        if ("Password".equalsIgnoreCase(sourceMethod)) {
            transformedMethod = "urn:oasis:names:tc:SAML:2.0:ac:classes:Password";
        } else if (sourceMethod != null && !"".equals(sourceMethod)) {
            return sourceMethod;
        }
        return transformedMethod;
    }

    public static Attribute createAttribute(String friendlyName, String name, List<String> values) {
        return SAML2ComponentBuilder.createAttribute(friendlyName, name, null, values);
    }

    public static Attribute createAttribute(String friendlyName, String name, String nameFormat, List<?> values) {
        if (stringBuilder == null) {
            stringBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
        }
        Attribute attribute = SAML2ComponentBuilder.createAttribute(friendlyName, name, nameFormat);
        for (Object value : values) {
            if (value instanceof String) {
                XSString attributeValue = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
                attributeValue.setValue((String)value);
                attribute.getAttributeValues().add(attributeValue);
                continue;
            }
            if (!(value instanceof XMLObject)) continue;
            attribute.getAttributeValues().add((XMLObject)value);
        }
        return attribute;
    }

    public static Subject createSaml2Subject(SubjectBean subjectBean) throws SecurityException, WSSecurityException {
        String confirmationMethodStr;
        if (subjectBuilder == null) {
            subjectBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        }
        Subject subject = (Subject)subjectBuilder.buildObject();
        NameID nameID = SAML2ComponentBuilder.createNameID(subjectBean);
        subject.setNameID(nameID);
        SubjectConfirmationData subjectConfData = null;
        if (subjectBean.getKeyInfo() != null) {
            subjectConfData = SAML2ComponentBuilder.createSubjectConfirmationData(null, null, null, subjectBean.getKeyInfo());
        }
        if ((confirmationMethodStr = subjectBean.getSubjectConfirmationMethod()) == null) {
            confirmationMethodStr = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
        }
        SubjectConfirmation subjectConfirmation = SAML2ComponentBuilder.createSubjectConfirmation(confirmationMethodStr, subjectConfData);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        return subject;
    }

    public static SubjectConfirmationData createSubjectConfirmationData(String inResponseTo, String recipient, DateTime notOnOrAfter, KeyInfoBean keyInfoBean) throws SecurityException, WSSecurityException {
        SubjectConfirmationData subjectConfirmationData = null;
        KeyInfo keyInfo = null;
        if (keyInfoBean == null) {
            if (subjectConfirmationDataBuilder == null) {
                subjectConfirmationDataBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
            }
            subjectConfirmationData = (SubjectConfirmationData)subjectConfirmationDataBuilder.buildObject();
        } else {
            if (keyInfoConfirmationDataBuilder == null) {
                keyInfoConfirmationDataBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(KeyInfoConfirmationDataType.TYPE_NAME);
            }
            subjectConfirmationData = (SubjectConfirmationData)keyInfoConfirmationDataBuilder.buildObject();
            keyInfo = SAML1ComponentBuilder.createKeyInfo(keyInfoBean);
            ((KeyInfoConfirmationDataType)subjectConfirmationData).getKeyInfos().add(keyInfo);
        }
        if (inResponseTo != null) {
            subjectConfirmationData.setInResponseTo(inResponseTo);
        }
        if (recipient != null) {
            subjectConfirmationData.setRecipient(recipient);
        }
        if (notOnOrAfter != null) {
            subjectConfirmationData.setNotOnOrAfter(notOnOrAfter);
        }
        return subjectConfirmationData;
    }

    public static SubjectConfirmation createSubjectConfirmation(String method, SubjectConfirmationData subjectConfirmationData) {
        if (subjectConfirmationBuilder == null) {
            subjectConfirmationBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        }
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)subjectConfirmationBuilder.buildObject();
        subjectConfirmation.setMethod(method);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        return subjectConfirmation;
    }

    public static NameID createNameID(SubjectBean subject) {
        if (nameIdBuilder == null) {
            nameIdBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        }
        NameID nameID = (NameID)nameIdBuilder.buildObject();
        nameID.setNameQualifier(subject.getSubjectNameQualifier());
        nameID.setFormat(subject.getSubjectNameIDFormat());
        nameID.setValue(subject.getSubjectName());
        return nameID;
    }

    public static List<AttributeStatement> createAttributeStatement(List<AttributeStatementBean> attributeData) {
        ArrayList<AttributeStatement> attributeStatements = new ArrayList<AttributeStatement>();
        if (attributeStatementBuilder == null) {
            attributeStatementBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        }
        if (attributeData != null && attributeData.size() > 0) {
            for (AttributeStatementBean statementBean : attributeData) {
                AttributeStatement attributeStatement = (AttributeStatement)attributeStatementBuilder.buildObject();
                for (AttributeBean values : statementBean.getSamlAttributes()) {
                    List<String> attributeValues = values.getAttributeValues();
                    if (attributeValues == null || attributeValues.isEmpty()) {
                        attributeValues = values.getCustomAttributeValues();
                    }
                    Attribute samlAttribute = SAML2ComponentBuilder.createAttribute(values.getSimpleName(), values.getQualifiedName(), values.getNameFormat(), attributeValues);
                    attributeStatement.getAttributes().add(samlAttribute);
                }
                attributeStatements.add(attributeStatement);
            }
        }
        return attributeStatements;
    }

    public static Attribute createAttribute(String friendlyName, String name) {
        return SAML2ComponentBuilder.createAttribute(friendlyName, name, (String)null);
    }

    public static Attribute createAttribute(String friendlyName, String name, String nameFormat) {
        if (attributeBuilder == null) {
            attributeBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        }
        Attribute attribute = (Attribute)attributeBuilder.buildObject();
        attribute.setFriendlyName(friendlyName);
        if (nameFormat == null) {
            attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        } else {
            attribute.setNameFormat(nameFormat);
        }
        attribute.setName(name);
        return attribute;
    }

    public static List<AuthzDecisionStatement> createAuthorizationDecisionStatement(List<AuthDecisionStatementBean> decisionData) {
        ArrayList<AuthzDecisionStatement> authDecisionStatements = new ArrayList<AuthzDecisionStatement>();
        if (authorizationDecisionStatementBuilder == null) {
            authorizationDecisionStatementBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthzDecisionStatement.DEFAULT_ELEMENT_NAME);
        }
        if (decisionData != null && decisionData.size() > 0) {
            for (AuthDecisionStatementBean decisionStatementBean : decisionData) {
                AuthzDecisionStatement authDecision = (AuthzDecisionStatement)authorizationDecisionStatementBuilder.buildObject();
                authDecision.setResource(decisionStatementBean.getResource());
                authDecision.setDecision(SAML2ComponentBuilder.transformDecisionType(decisionStatementBean.getDecision()));
                for (ActionBean actionBean : decisionStatementBean.getActions()) {
                    Action actionElement = SAML2ComponentBuilder.createSamlAction(actionBean);
                    authDecision.getActions().add(actionElement);
                }
                if (decisionStatementBean.getEvidence() instanceof Evidence) {
                    authDecision.setEvidence((Evidence)decisionStatementBean.getEvidence());
                }
                authDecisionStatements.add(authDecision);
            }
        }
        return authDecisionStatements;
    }

    public static Action createSamlAction(ActionBean actionBean) {
        if (actionElementBuilder == null) {
            actionElementBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Action.DEFAULT_ELEMENT_NAME);
        }
        Action actionElement = (Action)actionElementBuilder.buildObject();
        actionElement.setNamespace(actionBean.getActionNamespace());
        if (actionBean.getActionNamespace() == null) {
            actionElement.setNamespace("urn:oasis:names:tc:SAML:1.0:action:rwedc-negation");
        }
        actionElement.setAction(actionBean.getContents());
        return actionElement;
    }

    private static DecisionTypeEnumeration transformDecisionType(AuthDecisionStatementBean.Decision decision) {
        DecisionTypeEnumeration decisionTypeEnum = DecisionTypeEnumeration.DENY;
        if (decision.equals((Object)AuthDecisionStatementBean.Decision.PERMIT)) {
            decisionTypeEnum = DecisionTypeEnumeration.PERMIT;
        } else if (decision.equals((Object)AuthDecisionStatementBean.Decision.INDETERMINATE)) {
            decisionTypeEnum = DecisionTypeEnumeration.INDETERMINATE;
        }
        return decisionTypeEnum;
    }

    static {
        builderFactory = Configuration.getBuilderFactory();
    }
}

