/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.as.domain.controller.operations.coordination.HostControllerUpdateTask;
import org.jboss.as.host.controller.mgmt.TransformingProxyController;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public class DomainSlaveHandler
implements OperationStepHandler {
    private final DomainOperationContext domainOperationContext;
    private final Map<String, ProxyController> hostProxies;

    public DomainSlaveHandler(Map<String, ProxyController> hostProxies, DomainOperationContext domainOperationContext) {
        this.hostProxies = hostProxies;
        this.domainOperationContext = domainOperationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String hostName;
        ModelNode finalResult;
        if (context.hasFailureDescription()) {
            context.setRollbackOnly();
            context.completeStep();
            return;
        }
        HashSet<String> outstanding = new HashSet<String>(this.hostProxies.keySet());
        ArrayList<TransactionalProtocolClient.PreparedOperation> results = new ArrayList<TransactionalProtocolClient.PreparedOperation>();
        HashMap<String, ModelNode> finalResults = new HashMap<String, ModelNode>();
        HostControllerUpdateTask.ProxyOperationListener listener = new HostControllerUpdateTask.ProxyOperationListener();
        for (Map.Entry<String, ProxyController> entry : this.hostProxies.entrySet()) {
            String host = entry.getKey();
            TransformingProxyController transformingProxyController = (TransformingProxyController)entry.getValue();
            HostControllerUpdateTask task = new HostControllerUpdateTask(host, operation.clone(), context, transformingProxyController);
            finalResult = task.execute(listener);
            finalResults.put(host, finalResult);
        }
        boolean interrupted = false;
        try {
            try {
                while (outstanding.size() > 0) {
                    TransactionalProtocolClient.PreparedOperation prepared = listener.retrievePreparedOperation();
                    String hostName2 = ((HostControllerUpdateTask.ProxyOperation)prepared.getOperation()).getName();
                    if (!outstanding.remove(hostName2)) continue;
                    ModelNode modelNode = prepared.getPreparedResult();
                    if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Preliminary result for remote host %s is %s", hostName2, modelNode);
                    }
                    this.domainOperationContext.addHostControllerResult(hostName2, modelNode);
                    results.add(prepared);
                }
            }
            catch (InterruptedException ie) {
                interrupted = true;
                this.domainOperationContext.setFailureReported(true);
                for (AsyncFuture asyncFuture : finalResults.values()) {
                    asyncFuture.asyncCancel(false);
                }
                for (Map.Entry entry : finalResults.entrySet()) {
                    hostName = (String)entry.getKey();
                    try {
                        ModelNode result = (ModelNode)((AsyncFuture)entry.getValue()).get();
                        this.domainOperationContext.addHostControllerResult(hostName, result);
                    }
                    catch (Exception e) {
                        ModelNode result = new ModelNode();
                        result.get("outcome").set("failed");
                        if (e instanceof InterruptedException) {
                            result.get("failure-description").set(DomainControllerMessages.MESSAGES.interruptedAwaitingResultFromHost((String)entry.getKey()));
                            interrupted = true;
                        } else {
                            result.get("failure-description").set(DomainControllerMessages.MESSAGES.exceptionAwaitingResultFromHost((String)entry.getKey(), e.getMessage()));
                        }
                        this.domainOperationContext.addHostControllerResult(hostName, result);
                    }
                }
            }
            context.completeStep();
        }
        catch (Throwable throwable) {
            try {
                boolean rollback = this.domainOperationContext.isCompleteRollback();
                for (TransactionalProtocolClient.PreparedOperation prepared : results) {
                    if (prepared.isDone()) continue;
                    if (!rollback) {
                        prepared.commit();
                        continue;
                    }
                    prepared.rollback();
                }
                for (TransactionalProtocolClient.PreparedOperation prepared : results) {
                    String hostName2 = ((HostControllerUpdateTask.ProxyOperation)prepared.getOperation()).getName();
                    try {
                        ModelNode finalResult2 = (ModelNode)prepared.getFinalResult().get();
                        this.domainOperationContext.addHostControllerResult(hostName2, finalResult2);
                        if (!DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) continue;
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Final result for remote host %s is %s", hostName2, finalResult2);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        DomainControllerLogger.CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(hostName2);
                    }
                    catch (ExecutionException e) {
                        DomainControllerLogger.CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), hostName2);
                    }
                }
                throw throwable;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        try {
            boolean rollback = this.domainOperationContext.isCompleteRollback();
            for (TransactionalProtocolClient.PreparedOperation preparedOperation : results) {
                if (preparedOperation.isDone()) continue;
                if (!rollback) {
                    preparedOperation.commit();
                    continue;
                }
                preparedOperation.rollback();
            }
            for (TransactionalProtocolClient.PreparedOperation preparedOperation : results) {
                hostName = ((HostControllerUpdateTask.ProxyOperation)preparedOperation.getOperation()).getName();
                try {
                    finalResult = (ModelNode)preparedOperation.getFinalResult().get();
                    this.domainOperationContext.addHostControllerResult(hostName, finalResult);
                    if (!DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) continue;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Final result for remote host %s is %s", hostName, finalResult);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    DomainControllerLogger.CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(hostName);
                }
                catch (ExecutionException e) {
                    DomainControllerLogger.CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), hostName);
                }
            }
            return;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

