/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.remote.RemoteProxyController;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.dmr.ModelNode;

public interface TransformingProxyController
extends ProxyController {
    public static final Transformers NOOP = new Transformers(){

        public TransformationTarget getTarget() {
            return null;
        }

        public ModelNode transformOperation(TransformationContext context, ModelNode operation) {
            return operation;
        }

        public Resource transformResource(TransformationContext context, Resource resource) {
            return resource;
        }
    };

    public TransactionalProtocolClient getProtocolClient();

    public Transformers getTransformers();

    public static class TransformingProxyControllerImpl
    implements TransformingProxyController {
        private final RemoteProxyController proxy;
        private final Transformers transformers;

        public TransformingProxyControllerImpl(Transformers transformers, RemoteProxyController proxy) {
            this.transformers = transformers;
            this.proxy = proxy;
        }

        @Override
        public TransactionalProtocolClient getProtocolClient() {
            return this.proxy.getTransactionalProtocolClient();
        }

        @Override
        public Transformers getTransformers() {
            return this.transformers;
        }

        public PathAddress getProxyNodeAddress() {
            return this.proxy.getProxyNodeAddress();
        }

        public void execute(ModelNode operation, OperationMessageHandler handler, ProxyController.ProxyOperationControl control, OperationAttachments attachments) {
            this.proxy.execute(operation, handler, control, attachments);
        }
    }

    public static class Factory {
        public static TransformingProxyController create(ManagementChannelHandler channelAssociation, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator) {
            return Factory.create(channelAssociation, NOOP, pathAddress, addressTranslator);
        }

        public static TransformingProxyController create(ManagementChannelHandler channelAssociation, final Transformers transformers, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator) {
            TransactionalProtocolClient client = TransactionalProtocolHandlers.createClient((ManagementChannelHandler)channelAssociation);
            final RemoteProxyController proxy = RemoteProxyController.create((TransactionalProtocolClient)client, (PathAddress)pathAddress, (ProxyOperationAddressTranslator)addressTranslator);
            Transformers delegating = new Transformers(){

                public TransformationTarget getTarget() {
                    return transformers.getTarget();
                }

                public ModelNode transformOperation(TransformationContext context, ModelNode original) {
                    ModelNode operation = proxy.translateOperationForProxy(original);
                    return transformers.transformOperation(context, operation);
                }

                public Resource transformResource(TransformationContext context, Resource resource) {
                    return transformers.transformResource(context, resource);
                }
            };
            return Factory.create(proxy, delegating);
        }

        private static TransformingProxyController create(RemoteProxyController delegate, Transformers transformers) {
            return new TransformingProxyControllerImpl(transformers, delegate);
        }
    }
}

