/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.host.controller.descriptions.HostDescriptionProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

final class JVMDescriptions {
    private static final String RESOURCE_NAME = HostDescriptionProviders.class.getPackage().getName() + ".LocalDescriptions";

    JVMDescriptions() {
    }

    static ModelNode getOptionAddOperation(Locale locale) {
        ResourceBundle bundle2 = JVMDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add-jvm-option");
        node.get("description").set(bundle2.getString("jvm.option.add"));
        node.get(new String[]{"request-properties", "jvm-option", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "jvm-option", "description"}).set(bundle2.getString("jvm.option"));
        node.get(new String[]{"request-properties", "jvm-option", "required"}).set(true);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getOptionRemoveOperation(Locale locale) {
        ResourceBundle bundle2 = JVMDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove-jvm-option");
        node.get("description").set(bundle2.getString("jvm.option.remove"));
        node.get(new String[]{"request-properties", "jvm-option", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "jvm-option", "description"}).set(bundle2.getString("jvm.option"));
        node.get(new String[]{"request-properties", "jvm-option", "required"}).set(true);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getEnvVarAddOperation(Locale locale) {
        ResourceBundle bundle2 = JVMDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add-item-to-environment-variables-list");
        node.get("description").set(bundle2.getString("jvm.environment-variable.add"));
        node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("jvm.environment-variable.name"));
        node.get(new String[]{"request-properties", "name", "required"}).set(true);
        node.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "value", "description"}).set(bundle2.getString("jvm.environment-variable.value"));
        node.get(new String[]{"request-properties", "value", "required"}).set(true);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getEnvVarRemoveOperation(Locale locale) {
        ResourceBundle bundle2 = JVMDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove-item-from-environment-variables-list");
        node.get("description").set(bundle2.getString("jvm.environment-variable.remove"));
        node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("jvm.environment-variable.name"));
        node.get(new String[]{"request-properties", "name", "required"}).set(true);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

