/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.mail.extension.Attribute;
import org.jboss.as.mail.extension.Element;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.mail.extension.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class MailSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    MailSubsystemParser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode model = context.getModelNode();
        List sessions = model.get("mail-session").asPropertyList();
        for (Property mailSession : sessions) {
            ModelNode sessionData = mailSession.getValue();
            writer.writeStartElement(Element.MAIL_SESSION.getLocalName());
            MailSessionDefinition.JNDI_NAME.marshallAsAttribute(sessionData, (XMLStreamWriter)writer);
            MailSessionDefinition.DEBUG.marshallAsAttribute(sessionData, false, (XMLStreamWriter)writer);
            MailSessionDefinition.FROM.marshallAsAttribute(sessionData, false, (XMLStreamWriter)writer);
            ModelNode server = sessionData.get("server");
            if (server.hasDefined("smtp")) {
                this.writeServerModel(writer, server.get("smtp"), "smtp-server");
            }
            if (server.hasDefined("pop3")) {
                this.writeServerModel(writer, server.get("pop3"), "pop3-server");
            }
            if (server.hasDefined("imap")) {
                this.writeServerModel(writer, server.get("imap"), "imap-server");
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeServerModel(XMLExtendedStreamWriter writer, ModelNode server, String elementName) throws XMLStreamException {
        boolean credentials = server.hasDefined("username");
        if (credentials) {
            writer.writeStartElement(Element.forName(elementName).getLocalName());
        } else {
            writer.writeEmptyElement(Element.forName(elementName).getLocalName());
        }
        MailServerDefinition.SSL.marshallAsAttribute(server, false, (XMLStreamWriter)writer);
        MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF.marshallAsAttribute(server, false, (XMLStreamWriter)writer);
        if (credentials) {
            writer.writeEmptyElement(Element.LOGIN.getLocalName());
            MailServerDefinition.USERNAME.marshallAsAttribute(server, false, (XMLStreamWriter)writer);
            MailServerDefinition.PASSWORD.marshallAsAttribute(server, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "mail");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MAIL_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MAIL_SESSION: {
                            this.parseMailSession(reader, list, address);
                            continue block6;
                        }
                    }
                    reader.handleAny(list);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseMailSession(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parent) throws XMLStreamException {
        String jndiName = null;
        ModelNode operation = new ModelNode();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attr = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            if (attr == Attribute.JNDI_NAME) {
                jndiName = value;
                MailSessionDefinition.JNDI_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
            }
            if (attr == Attribute.DEBUG) {
                MailSessionDefinition.DEBUG.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
            }
            if (attr != Attribute.FROM) continue;
            MailSessionDefinition.FROM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
        }
        if (jndiName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.JNDI_NAME));
        }
        ModelNode dsAddress = parent.clone();
        dsAddress.add("mail-session", jndiName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        operation.get("operation").set("add");
        list.add(operation);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MAIL_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SMTP_SERVER: {
                            this.parseServerConfig(reader, "smtp", dsAddress, list);
                            continue block9;
                        }
                        case POP3_SERVER: {
                            this.parseServerConfig(reader, "pop3", dsAddress, list);
                            continue block9;
                        }
                        case IMAP_SERVER: {
                            this.parseServerConfig(reader, "imap", dsAddress, list);
                            continue block9;
                        }
                    }
                    reader.handleAny(list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerConfig(XMLExtendedStreamReader reader, String name, ModelNode parent, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = parent.clone();
        address.add("server", name);
        address.protect();
        ModelNode operation = new ModelNode();
        operation.get("address").set(address);
        operation.get("operation").set("add");
        list.add(operation);
        String socketBindingRef = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attr = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            if (attr == Attribute.OUTBOUND_SOCKET_BINDING_REF) {
                socketBindingRef = value;
                MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
            }
            if (attr != Attribute.SSL) continue;
            MailServerDefinition.SSL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
        }
        if (socketBindingRef == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.OUTBOUND_SOCKET_BINDING_REF));
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGIN: {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String att = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (att.equals(Attribute.USERNAME.getLocalName())) {
                            MailServerDefinition.USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            continue;
                        }
                        if (!att.equals(Attribute.PASSWORD.getLocalName())) continue;
                        MailServerDefinition.PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                }
            }
        }
    }
}

