/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs30;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.osgi.vfs.internal.VFSMessages;
import org.jboss.osgi.vfs30.VFSAdaptor30;
import org.jboss.osgi.vfs30.VFSEntryPathsEnumeration;
import org.jboss.osgi.vfs30.VFSFindEntriesEnumeration;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualJarInputStream;

class VirtualFileAdaptor30
implements VirtualFile {
    private final org.jboss.vfs.VirtualFile vfsFile;
    private IOException leakDebuggingStack;
    private Closeable mount;
    private TempDir streamDir;
    private File streamFile;
    private static Set<String> suffixes = new HashSet<String>();
    private static boolean LEAK_DEBUGGING;
    private static final TempFileProvider tmpProvider;

    VirtualFileAdaptor30(String name, InputStream input) throws IOException {
        this(VFS.getChild((String)name));
        if (input == null) {
            throw VFSMessages.MESSAGES.illegalArgumentNull("input");
        }
        this.mount = VFS.mountZip((InputStream)input, (String)this.vfsFile.getName(), (org.jboss.vfs.VirtualFile)this.vfsFile, (TempFileProvider)tmpProvider);
    }

    VirtualFileAdaptor30(org.jboss.vfs.VirtualFile vfsFile) {
        if (vfsFile == null) {
            throw VFSMessages.MESSAGES.illegalArgumentNull("file");
        }
        this.vfsFile = vfsFile;
        if (LEAK_DEBUGGING) {
            this.leakDebuggingStack = new IOException("VirtualFile created in this stack frame not closed: " + vfsFile);
        }
    }

    protected void finalize() throws Throwable {
        if (this.mount != null && this.leakDebuggingStack != null) {
            this.leakDebuggingStack.printStackTrace(System.err);
        }
    }

    public org.jboss.vfs.VirtualFile getVirtualFile() {
        return this.vfsFile;
    }

    public String getName() {
        return this.vfsFile.getName();
    }

    public String getPathName() {
        return this.vfsFile.getPathName();
    }

    public boolean isFile() throws IOException {
        return this.vfsFile.isFile();
    }

    public boolean isDirectory() throws IOException {
        return this.vfsFile.isDirectory();
    }

    public URL toURL() throws IOException {
        URL url = this.vfsFile.toURL();
        return url;
    }

    public URL getStreamURL() throws IOException {
        if (this.vfsFile.isFile()) {
            return this.vfsFile.toURL();
        }
        if (this.streamFile == null) {
            this.streamDir = tmpProvider.createTempDir("urlstream");
            this.streamFile = this.streamDir.getFile(this.getName());
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(this.streamFile));
            VirtualJarInputStream jarIn = (VirtualJarInputStream)this.vfsFile.openStream();
            ZipEntry nextEntry = jarIn.getNextEntry();
            while (nextEntry != null) {
                jarOut.putNextEntry(nextEntry);
                VFSUtils.copyStream((InputStream)jarIn, (OutputStream)jarOut);
                nextEntry = jarIn.getNextEntry();
            }
            jarOut.close();
            jarIn.close();
        }
        return this.streamFile.toURI().toURL();
    }

    public VirtualFile getParent() {
        org.jboss.vfs.VirtualFile parent = this.vfsFile.getParent();
        return parent != null ? new VirtualFileAdaptor30(parent) : null;
    }

    public VirtualFile getChild(String path) throws IOException {
        org.jboss.vfs.VirtualFile child = this.getMountedChild(path);
        if (!child.exists()) {
            return null;
        }
        return new VirtualFileAdaptor30(child);
    }

    public List<VirtualFile> getChildrenRecursively() throws IOException {
        ArrayList<VirtualFileAdaptor30> files = new ArrayList<VirtualFileAdaptor30>();
        for (org.jboss.vfs.VirtualFile child : this.getMountedChildrenRecursively()) {
            files.add(new VirtualFileAdaptor30(child));
        }
        return Collections.unmodifiableList(files);
    }

    public List<VirtualFile> getChildren() throws IOException {
        ArrayList<VirtualFileAdaptor30> files = new ArrayList<VirtualFileAdaptor30>();
        for (org.jboss.vfs.VirtualFile child : this.getMountedChildren()) {
            files.add(new VirtualFileAdaptor30(child));
        }
        return Collections.unmodifiableList(files);
    }

    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) throws IOException {
        org.jboss.vfs.VirtualFile child;
        if (path == null) {
            throw VFSMessages.MESSAGES.illegalArgumentNull("path");
        }
        if (pattern == null) {
            pattern = "*";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!(child = this.getMountedChild(path)).exists()) {
            return null;
        }
        return new VFSFindEntriesEnumeration(this.vfsFile, child, pattern, recurse);
    }

    public Enumeration<String> getEntryPaths(String path) throws IOException {
        org.jboss.vfs.VirtualFile child;
        if (path == null) {
            throw VFSMessages.MESSAGES.illegalArgumentNull("path");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() > 0) {
            child = this.getMountedChild(path);
        } else {
            this.ensureMounted();
            child = this.vfsFile;
        }
        if (!child.exists()) {
            return null;
        }
        return new VFSEntryPathsEnumeration(this.vfsFile, child);
    }

    public InputStream openStream() throws IOException {
        if (this.mount != null) {
            return this.getStreamURL().openStream();
        }
        return this.vfsFile.openStream();
    }

    public Certificate[] getCertificates() {
        return this.vfsFile.getCertificates();
    }

    public CodeSigner[] getCodeSigners() {
        return this.vfsFile.getCodeSigners();
    }

    public void close() {
        VFSUtils.safeClose((Closeable)this.mount);
        this.leakDebuggingStack = null;
        this.mount = null;
        VFSAdaptor30.unregister(this);
        if (this.streamFile != null) {
            File streamParent = this.streamFile.getParentFile();
            this.streamFile.delete();
            streamParent.delete();
            this.streamFile = null;
        }
    }

    private boolean acceptForMount() {
        if (this.vfsFile.isDirectory()) {
            return false;
        }
        boolean accept = false;
        String rootName = this.vfsFile.getName();
        for (String suffix : suffixes) {
            if (!rootName.endsWith(suffix)) continue;
            accept = true;
            break;
        }
        return accept;
    }

    private org.jboss.vfs.VirtualFile getMountedChild(String path) throws IOException {
        this.ensureMounted();
        return this.vfsFile.getChild(path);
    }

    private List<org.jboss.vfs.VirtualFile> getMountedChildren() throws IOException {
        this.ensureMounted();
        return this.vfsFile.getChildren();
    }

    private List<org.jboss.vfs.VirtualFile> getMountedChildrenRecursively() throws IOException {
        this.ensureMounted();
        return this.vfsFile.getChildrenRecursively();
    }

    private void ensureMounted() throws IOException {
        if (this.mount == null && this.acceptForMount()) {
            this.mount = VFS.mountZip((org.jboss.vfs.VirtualFile)this.vfsFile, (org.jboss.vfs.VirtualFile)this.vfsFile, (TempFileProvider)tmpProvider);
        }
    }

    public boolean equals(Object obj) {
        return this.vfsFile.equals(obj);
    }

    public int hashCode() {
        return this.vfsFile.hashCode();
    }

    public String toString() {
        return this.vfsFile.toString();
    }

    static {
        suffixes.add(".jar");
        suffixes.add(".war");
        LEAK_DEBUGGING = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return "true".equals(System.getProperty("jboss.osgi.vfs.leakDebugging"));
            }
        }).booleanValue() : "true".equals(System.getProperty("jboss.osgi.vfs.leakDebugging"));
        try {
            tmpProvider = TempFileProvider.create((String)"osgitmp-", null);
        }
        catch (IOException ex) {
            throw VFSMessages.MESSAGES.illegalStateCannotCreateTempFileProvider((Throwable)ex);
        }
        Thread shutdownThread = new Thread("vfs-shutdown"){

            @Override
            public void run() {
                try {
                    tmpProvider.close();
                }
                catch (IOException ex) {
                    throw VFSMessages.MESSAGES.illegalStateCannotCloseTempFileProvider((Throwable)ex);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }
}

