/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.metadata.MetaDataExtractor;
import org.picketlink.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.picketlink.identity.federation.core.config.PicketLinkType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.SystemPropertiesUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFormAuthenticator
extends FormAuthenticator {
    protected static Logger log = Logger.getLogger(BaseFormAuthenticator.class);
    protected final boolean trace = log.isTraceEnabled();
    protected TrustKeyManager keyManager;
    protected SPType spConfiguration = null;
    protected PicketLinkType picketLinkConfiguration = null;
    protected String serviceURL = null;
    protected String identityURL = null;
    protected String issuerID = null;
    protected String configFile = "/WEB-INF/picketlink.xml";
    protected transient X509Certificate idpCertificate = null;
    protected transient SAML2HandlerChain chain = null;
    protected transient String samlHandlerChainClass = null;
    protected Map<String, Object> chainConfigOptions = new HashMap<String, Object>();
    protected boolean saveRestoreRequest = true;
    protected Lock chainLock = new ReentrantLock();
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    protected String logOutPage = "/logout.jsp";
    protected SAMLConfigurationProvider configProvider = null;
    private Method theSuperRegisterMethod = null;
    private boolean seekSuperRegisterMethod = true;
    protected String idpAddress = null;

    public void setIdpAddress(String idpAddress) {
        this.idpAddress = idpAddress;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setSamlHandlerChainClass(String samlHandlerChainClass) {
        this.samlHandlerChainClass = samlHandlerChainClass;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public void setSaveRestoreRequest(boolean saveRestoreRequest) {
        this.saveRestoreRequest = saveRestoreRequest;
    }

    public void setConfigProvider(String cp) {
        if (cp == null) {
            throw new IllegalStateException("PL00078: Null Parameter:" + cp);
        }
        Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), cp);
        if (clazz == null) {
            throw new RuntimeException("PL00085: Class Not Loaded:" + cp);
        }
        try {
            this.configProvider = (SAMLConfigurationProvider)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("PL00086: Cannot create instance of:" + cp + ":" + e.getMessage());
        }
    }

    public SPType getConfiguration() {
        return this.spConfiguration;
    }

    public void setIssuerID(String issuerID) {
        this.issuerID = issuerID;
    }

    public void setLogOutPage(String logOutPage) {
        this.logOutPage = logOutPage;
    }

    protected boolean validate(Request request) {
        return request.getParameter("SAMLResponse") != null;
    }

    public void start() throws LifecycleException {
        super.start();
        SystemPropertiesUtil.ensure();
        this.processStart();
    }

    public String getIdentityURL() {
        return this.identityURL;
    }

    public X509Certificate getIdpCertificate() {
        return this.idpCertificate;
    }

    protected void register(Request request, Response response, Principal principal, String arg3, String arg4, String arg5) {
        if (this.theSuperRegisterMethod == null && this.seekSuperRegisterMethod) {
            Class[] args = new Class[]{Request.class, HttpServletResponse.class, Principal.class, String.class, String.class, String.class};
            Class<?> superClass = this.getAuthenticatorBaseClass();
            this.theSuperRegisterMethod = SecurityActions.getMethod(superClass, "register", args);
        }
        try {
            if (this.theSuperRegisterMethod != null) {
                Object[] callArgs = new Object[]{request, response, principal, arg3, arg4, arg5};
                this.theSuperRegisterMethod.invoke((Object)this, callArgs);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.theSuperRegisterMethod == null) {
            this.seekSuperRegisterMethod = false;
            super.register(request, response, principal, arg3, arg4, arg5);
            return;
        }
    }

    protected boolean localAuthentication(Request request, Response response, LoginConfig loginConfig) throws IOException {
        if (request.getUserPrincipal() == null) {
            log.error((Object)"Falling back on local Form Authentication if available");
            try {
                return super.authenticate(request, response, loginConfig);
            }
            catch (NoSuchMethodError e) {
                try {
                    Method method = super.getClass().getMethod("authenticate", HttpServletRequest.class, HttpServletResponse.class, LoginConfig.class);
                    return (Boolean)method.invoke((Object)this, request.getRequest(), response.getResponse(), loginConfig);
                }
                catch (Exception ex) {
                    throw new IOException("PL00035: Unable to fallback on local auth:", ex);
                }
            }
        }
        return true;
    }

    protected abstract String getBinding();

    protected void processIDPMetadataFile(String idpMetadataFile) {
        List keyDescriptors;
        ServletContext servletContext = this.context.getServletContext();
        InputStream is = servletContext.getResourceAsStream(idpMetadataFile);
        if (is == null) {
            return;
        }
        Object metadata = null;
        try {
            Document samlDocument = DocumentUtil.getDocument((InputStream)is);
            SAMLParser parser = new SAMLParser();
            metadata = parser.parse(DocumentUtil.getNodeAsStream((Node)samlDocument));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IDPSSODescriptorType idpSSO = null;
        if (metadata instanceof EntitiesDescriptorType) {
            EntitiesDescriptorType entities = (EntitiesDescriptorType)metadata;
            idpSSO = this.handleMetadata(entities);
        } else {
            idpSSO = this.handleMetadata((EntityDescriptorType)metadata);
        }
        if (idpSSO == null) {
            log.error((Object)"Unable to obtain the IDP SSO Descriptor from metadata");
            return;
        }
        List endpoints = idpSSO.getSingleSignOnService();
        for (EndpointType endpoint : endpoints) {
            String endpointBinding = endpoint.getBinding().toString();
            if (endpointBinding.contains("HTTP-POST")) {
                endpointBinding = "POST";
            } else if (endpointBinding.contains("HTTP-Redirect")) {
                endpointBinding = "REDIRECT";
            }
            if (!this.getBinding().equals(endpointBinding)) continue;
            this.identityURL = endpoint.getLocation().toString();
            break;
        }
        if ((keyDescriptors = idpSSO.getKeyDescriptor()).size() > 0) {
            this.idpCertificate = MetaDataExtractor.getCertificate((KeyDescriptorType)((KeyDescriptorType)keyDescriptors.get(0)));
        }
    }

    protected void processConfiguration() {
        ServletContext servletContext = this.context.getServletContext();
        InputStream is = servletContext.getResourceAsStream(this.configFile);
        try {
            if (this.configProvider != null) {
                this.spConfiguration = this.configProvider.getSPConfiguration();
                if (this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                    ((AbstractSAMLConfigurationProvider)this.configProvider).setConfigFile(is);
                }
            } else if (is != null) {
                try {
                    this.picketLinkConfiguration = ConfigurationUtil.getConfiguration((InputStream)is);
                    this.spConfiguration = (SPType)this.picketLinkConfiguration.getIdpOrSP();
                }
                catch (ParsingException e) {
                    if (this.trace) {
                        log.trace((Object)e);
                    }
                    throw new RuntimeException("PL00102: Processing Exception:", e);
                }
            } else {
                is = servletContext.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                if (is == null) {
                    throw new RuntimeException("PL00025: Service Provider:: Configuration File missing:" + this.configFile);
                }
                this.spConfiguration = ConfigurationUtil.getSPConfiguration((InputStream)is);
            }
            if (StringUtil.isNotNull((String)this.spConfiguration.getIdpMetadataFile())) {
                this.processIDPMetadataFile(this.spConfiguration.getIdpMetadataFile());
            } else {
                this.identityURL = this.spConfiguration.getIdentityURL();
            }
            this.serviceURL = this.spConfiguration.getServiceURL();
            this.canonicalizationMethod = this.spConfiguration.getCanonicalizationMethod();
            log.info((Object)("BaseFormAuthenticator:: Setting the CanonicalizationMethod on XMLSignatureUtil::" + this.canonicalizationMethod));
            XMLSignatureUtil.setCanonicalizationMethodType((String)this.canonicalizationMethod);
            if (this.trace) {
                log.trace((Object)("Identity Provider URL=" + this.identityURL));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected IDPSSODescriptorType handleMetadata(EntitiesDescriptorType entities) {
        Object entityDescriptor;
        IDPSSODescriptorType idpSSO = null;
        List entityDescs = entities.getEntityDescriptor();
        Iterator i$ = entityDescs.iterator();
        while (i$.hasNext() && (idpSSO = (entityDescriptor = i$.next()) instanceof EntitiesDescriptorType ? this.getIDPSSODescriptor(entities) : this.handleMetadata((EntityDescriptorType)entityDescriptor)) == null) {
        }
        return idpSSO;
    }

    protected IDPSSODescriptorType handleMetadata(EntityDescriptorType entityDescriptor) {
        return CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)entityDescriptor);
    }

    protected IDPSSODescriptorType getIDPSSODescriptor(EntitiesDescriptorType entities) {
        List entityDescs = entities.getEntityDescriptor();
        Iterator i$ = entityDescs.iterator();
        if (i$.hasNext()) {
            Object entityDescriptor = i$.next();
            if (entityDescriptor instanceof EntitiesDescriptorType) {
                return this.getIDPSSODescriptor((EntitiesDescriptorType)entityDescriptor);
            }
            return CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)((EntityDescriptorType)entityDescriptor));
        }
        return null;
    }

    protected void initializeHandlerChain() throws ConfigurationException, ProcessingException {
        this.populateChainConfig();
        DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(this.chainConfigOptions);
        Set samlHandlers = this.chain.handlers();
        for (SAML2Handler handler : samlHandlers) {
            handler.initChainConfig((SAML2HandlerChainConfig)handlerChainConfig);
        }
    }

    protected void populateChainConfig() throws ConfigurationException, ProcessingException {
        this.chainConfigOptions.put("CONFIGURATION", this.spConfiguration);
        this.chainConfigOptions.put("CANONICALIZATION_METHOD", this.canonicalizationMethod);
        this.chainConfigOptions.put("ROLE_VALIDATOR_IGNORE", "false");
        if (this.doSupportSignature()) {
            this.chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
        }
    }

    protected void sendToLogoutPage(Request request, Response response, Session session) throws IOException, ServletException {
        RequestDispatcher dispatch = this.context.getServletContext().getRequestDispatcher(this.logOutPage);
        if (dispatch == null) {
            log.error((Object)("Cannot dispatch to the logout page: no request dispatcher:" + this.logOutPage));
        } else {
            session.expire();
            try {
                dispatch.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                dispatch.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
            }
        }
    }

    public void testStart() throws LifecycleException {
        this.saveRestoreRequest = false;
        if (this.context == null) {
            throw new RuntimeException("Catalina Context not set up");
        }
        this.processStart();
    }

    protected void processStart() throws LifecycleException {
        Handlers handlers = null;
        if (StringUtil.isNullOrEmpty((String)this.samlHandlerChainClass)) {
            this.chain = SAML2HandlerChainFactory.createChain();
        } else {
            try {
                this.chain = SAML2HandlerChainFactory.createChain((String)this.samlHandlerChainClass);
            }
            catch (ProcessingException e1) {
                throw new LifecycleException((Throwable)e1);
            }
        }
        ServletContext servletContext = this.context.getServletContext();
        this.processConfiguration();
        try {
            if (this.picketLinkConfiguration != null) {
                handlers = this.picketLinkConfiguration.getHandlers();
            } else {
                String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
                handlers = ConfigurationUtil.getHandlers((InputStream)servletContext.getResourceAsStream(handlerConfigFileName));
            }
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)handlers));
            this.initKeyProvider(this.context);
            this.populateChainConfig();
            this.initializeHandlerChain();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean doSupportSignature() {
        if (this.spConfiguration != null) {
            return this.spConfiguration.isSupportsSignature();
        }
        return false;
    }

    private Class<?> getAuthenticatorBaseClass() {
        Class<?> myClass = ((Object)((Object)this)).getClass();
        while ((myClass = myClass.getSuperclass()) != AuthenticatorBase.class) {
        }
        return myClass;
    }

    protected abstract void initKeyProvider(Context var1) throws LifecycleException;
}

