/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.soap.attachment.SwapableMemoryDataSource;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.xb.binding.NamespaceRegistry;

public abstract class CommonMessageContext
implements Map<String, Object> {
    private static final ResourceBundle bundle = BundleUtils.getBundle(CommonMessageContext.class);
    private static Logger log = Logger.getLogger(CommonMessageContext.class);
    public static final String REMOTING_METADATA = "org.jboss.ws.remoting.metadata";
    private SerializationContext serContext;
    private EndpointMetaData epMetaData;
    private OperationMetaData opMetaData;
    private MessageAbstraction message;
    protected Map<String, ScopedProperty> scopedProps = new HashMap<String, ScopedProperty>();
    protected MessageContext.Scope currentScope = MessageContext.Scope.APPLICATION;
    private boolean isModified;
    private Throwable currentException;

    public CommonMessageContext() {
    }

    public CommonMessageContext(CommonMessageContext msgContext) {
        this.epMetaData = msgContext.epMetaData;
        this.opMetaData = msgContext.opMetaData;
        this.message = msgContext.message;
        this.serContext = msgContext.serContext;
        this.scopedProps = new HashMap<String, ScopedProperty>(msgContext.scopedProps);
        this.currentScope = msgContext.currentScope;
    }

    public Throwable getCurrentException() {
        return this.currentException;
    }

    public void setCurrentException(Throwable t) {
        this.currentException = t;
    }

    public MessageContext.Scope getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(MessageContext.Scope currentScope) {
        this.currentScope = currentScope;
    }

    public EndpointMetaData getEndpointMetaData() {
        if (this.epMetaData == null && this.opMetaData != null) {
            this.epMetaData = this.opMetaData.getEndpointMetaData();
        }
        return this.epMetaData;
    }

    public void setEndpointMetaData(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public void setOperationMetaData(OperationMetaData opMetaData) {
        this.opMetaData = opMetaData;
    }

    public SOAPMessage getSOAPMessage() {
        if (this.message != null && !(this.message instanceof SOAPMessage)) {
            throw new UnsupportedOperationException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NO_SOAPMESSAGE_AVILABLE", (Object[])new Object[]{this.message.getClass()}));
        }
        return (SOAPMessage)this.message;
    }

    public void setSOAPMessage(SOAPMessage soapMessage) {
        this.message = (MessageAbstraction)soapMessage;
        this.setModified(true);
    }

    public MessageAbstraction getMessageAbstraction() {
        return this.message;
    }

    public void setMessageAbstraction(MessageAbstraction message) {
        this.message = message;
    }

    public SerializationContext getSerializationContext() {
        if (this.serContext == null) {
            this.serContext = this.createSerializationContext();
        }
        return this.serContext;
    }

    public abstract SerializationContext createSerializationContext();

    public void setSerializationContext(SerializationContext serContext) {
        this.serContext = serContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.getSerializationContext().getNamespaceRegistry();
    }

    @Override
    public int size() {
        return this.scopedProps.size();
    }

    @Override
    public boolean isEmpty() {
        return this.scopedProps.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        ScopedProperty prop = this.scopedProps.get(key);
        return this.isValidInScope(prop);
    }

    @Override
    public boolean containsValue(Object value) {
        boolean valueFound = false;
        for (ScopedProperty prop : this.scopedProps.values()) {
            if (!prop.getValue().equals(value) || !this.isValidInScope(prop)) continue;
            valueFound = true;
            break;
        }
        return valueFound;
    }

    @Override
    public Object get(Object key) {
        Object value = null;
        ScopedProperty scopedProp = this.scopedProps.get(key);
        if (log.isTraceEnabled()) {
            log.trace((Object)("get(" + key + "): " + scopedProp));
        }
        if (this.isValidInScope(scopedProp)) {
            value = scopedProp.getValue();
        }
        return value;
    }

    @Override
    public Object put(String key, Object value) {
        ScopedProperty prevProp = this.scopedProps.get(key);
        if (prevProp != null && !this.isValidInScope(prevProp)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_SET_VALUE_FOR_HANDLER_SCOPED_PROPERTY", (Object[])new Object[]{key}));
        }
        ScopedProperty newProp = new ScopedProperty(key, value, this.currentScope);
        if (log.isTraceEnabled()) {
            log.trace((Object)("put: " + newProp));
        }
        this.scopedProps.put(key, newProp);
        return prevProp != null ? prevProp.getValue() : null;
    }

    @Override
    public Object remove(Object key) {
        ScopedProperty prevProp = this.scopedProps.get(key);
        if (prevProp != null && !this.isValidInScope(prevProp)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_SET_REMOVE_FOR_HANDLER_SCOPED_PROPERTY", (Object[])new Object[]{key}));
        }
        return this.scopedProps.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> srcMap) {
        for (String string : srcMap.keySet()) {
            try {
                Object value = srcMap.get(string);
                this.put(string, value);
            }
            catch (IllegalArgumentException ex) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Ignore: " + ex.getMessage()));
            }
        }
    }

    @Override
    public void clear() {
        this.scopedProps.clear();
    }

    public boolean isModified() {
        if (XOPContext.isXOPEncodedRequest() && !XOPContext.isXOPMessage()) {
            log.debug((Object)"Disregard changes from XOP/Handler interactions");
            return false;
        }
        return this.isModified;
    }

    public void setModified(boolean modified) {
        this.isModified = modified;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>(this.scopedProps.size());
        for (ScopedProperty prop : this.scopedProps.values()) {
            if (!this.isValidInScope(prop)) continue;
            keys.add(prop.getName());
        }
        return keys;
    }

    @Override
    public Collection<Object> values() {
        HashSet<Object> values = new HashSet<Object>(this.scopedProps.size());
        for (ScopedProperty prop : this.scopedProps.values()) {
            if (!this.isValidInScope(prop)) continue;
            values.add(prop.getValue());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        for (ScopedProperty prop : this.scopedProps.values()) {
            if (!this.isValidInScope(prop)) continue;
            String name = prop.getName();
            Object value = prop.getValue();
            ImmutableEntry<String, Object> entry = new ImmutableEntry<String, Object>(name, value);
            entries.add(entry);
        }
        return entries;
    }

    private boolean isValidInScope(ScopedProperty prop) {
        boolean valid = prop != null && (prop.getScope() == MessageContext.Scope.APPLICATION || this.currentScope == MessageContext.Scope.HANDLER);
        return valid;
    }

    public static void cleanupAttachments(CommonMessageContext messageContext) {
        MessageAbstraction msg = messageContext.getMessageAbstraction();
        if (msg != null && msg instanceof SOAPMessage) {
            Iterator it = ((SOAPMessage)msg).getAttachments();
            while (it.hasNext()) {
                AttachmentPart attachment = (AttachmentPart)it.next();
                try {
                    if (!(attachment.getDataHandler().getDataSource() instanceof SwapableMemoryDataSource)) continue;
                    SwapableMemoryDataSource swapFile = (SwapableMemoryDataSource)attachment.getDataHandler().getDataSource();
                    swapFile.cleanup();
                }
                catch (SOAPException e) {
                    log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CLEANUP_ATTACHMENT_PART", (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
    }

    public static class ScopedProperty {
        private MessageContext.Scope scope;
        private String name;
        private Object value;

        public ScopedProperty(String name, Object value, MessageContext.Scope scope) {
            this.scope = scope;
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public MessageContext.Scope getScope() {
            return this.scope;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.scope + ":" + this.name + "=" + this.value;
        }
    }

    private static class ImmutableEntry<K, V>
    implements Map.Entry<K, V> {
        final K k;
        final V v;

        ImmutableEntry(K key, V value) {
            this.k = key;
            this.v = value;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

