/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import org.jboss.ws.common.utils.HashCodeUtil;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.metadata.umdm.EndpointMetaData;

public class JAXBContextCache {
    private Map<Integer, JAXBContext> cache = new ConcurrentHashMap<Integer, JAXBContext>();

    public JAXBContext get(Class[] clazzes) {
        Integer id = JAXBContextCache.buildId(clazzes);
        return this.get(id);
    }

    public void add(Class[] clazzes, JAXBContext context) {
        Integer id = JAXBContextCache.buildId(clazzes);
        this.add(id, context);
    }

    private JAXBContext get(Integer id) {
        return this.cache.get(id);
    }

    private void add(Integer id, JAXBContext context) {
        this.cache.put(id, context);
    }

    private static Integer buildId(Class[] classes) {
        int sum = 23;
        for (Class cls : classes) {
            sum = HashCodeUtil.hash((int)sum, (Object)cls.getName());
        }
        return sum;
    }

    public static JAXBContextCache getContextCache() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
        return epMetaData.getJaxbCache();
    }
}

