/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.util.xml.BufferedStreamResult;
import org.jboss.ws.util.xml.BufferedStreamSource;
import org.w3c.dom.Element;

public class XMLFragment {
    private static final ResourceBundle bundle = BundleUtils.getBundle(XMLFragment.class);
    private static Logger log = Logger.getLogger(XMLFragment.class);
    private Source source;
    private static final String XML_PROC = "<?xml";
    private RuntimeException streamSourceAccessMarker;

    public XMLFragment(Source source) {
        this.source = source;
    }

    public XMLFragment(String xmlString) {
        this.source = new BufferedStreamSource(xmlString.getBytes());
    }

    public XMLFragment(Result result) {
        if (result instanceof DOMResult) {
            DOMResult domResult = (DOMResult)result;
            this.source = new DOMSource(domResult.getNode());
        } else if (result instanceof BufferedStreamResult) {
            BufferedStreamResult br = (BufferedStreamResult)result;
            ByteArrayOutputStream baos = (ByteArrayOutputStream)br.getOutputStream();
            this.source = new BufferedStreamSource(baos.toByteArray());
        } else {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_RESULT_TYPE", (Object[])new Object[]{result}));
        }
    }

    public Source getSource() {
        this.source = this.beginSourceAccess(this.source);
        this.endSourceAccess();
        return this.source;
    }

    public String toXMLString() {
        try {
            StringWriter strWriter = new StringWriter(1024);
            this.writeSourceInternal(strWriter);
            return strWriter.toString();
        }
        catch (IOException ex) {
            throw new WSException(ex);
        }
    }

    public Element toElement() {
        Element retElement = null;
        try {
            this.source = this.beginSourceAccess(this.source);
            retElement = DOMUtils.sourceToElement((Source)this.source);
            this.endSourceAccess();
        }
        catch (IOException ex) {
            this.handleSourceAccessException(ex);
        }
        return retElement;
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeSourceInternal(writer);
    }

    public void writeTo(OutputStream out) throws IOException {
        PrintWriter printWriter = new PrintWriter(out);
        this.writeSourceInternal(printWriter);
        printWriter.flush();
        printWriter.close();
    }

    private void writeSourceInternal(Writer writer) throws IOException {
        try {
            this.source = this.beginSourceAccess(this.source);
            if (this.source instanceof DOMSource) {
                DOMSource domSource = (DOMSource)this.source;
                new DOMWriter(writer).print(domSource.getNode());
            } else if (this.source instanceof StreamSource || this.source instanceof SAXSource) {
                StreamSource streamSource = (StreamSource)this.source;
                boolean newReader = false;
                Reader reader = streamSource.getReader();
                InputStream is = streamSource.getInputStream();
                if (reader == null) {
                    if (is != null) {
                        reader = new InputStreamReader(is, "UTF-8");
                        newReader = true;
                    } else {
                        return;
                    }
                }
                char[] cbuf = new char[1024];
                int len = reader.read(cbuf);
                int off = 0;
                if (len == -1) {
                    throw new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"STREAMSOURCE_ALREADY_EXHAUSTED", (Object[])new Object[0]));
                }
                String xmlProc = new String(cbuf, 0, XML_PROC.length());
                if (XML_PROC.equals(xmlProc)) {
                    for (off = XML_PROC.length(); cbuf[off] != '>' && off < len; ++off) {
                    }
                    if (cbuf[off] != '>') {
                        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_END_INSTRUCTION", (Object[])new Object[0]));
                    }
                    len -= ++off;
                }
                while (len > 0) {
                    writer.write(cbuf, off, len);
                    len = reader.read(cbuf);
                    off = 0;
                }
                if (newReader) {
                    reader.close();
                }
            } else {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_SOURCE_TYPE", (Object[])new Object[]{this.source}));
            }
            this.endSourceAccess();
        }
        catch (IOException ex) {
            this.handleSourceAccessException(ex);
        }
    }

    private Source beginSourceAccess(Source source) {
        if (source instanceof BufferedStreamSource || source instanceof DOMSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            source = new BufferedStreamSource((StreamSource)source);
        } else {
            try {
                Element element = DOMUtils.sourceToElement((Source)source);
                source = element != null ? new DOMSource(element) : new DOMSource();
            }
            catch (IOException ex) {
                WSException.rethrow(ex);
            }
        }
        return source;
    }

    private void endSourceAccess() {
        if (this.source instanceof StreamSource) {
            this.streamSourceAccessMarker = new RuntimeException();
        }
    }

    private void handleSourceAccessException(IOException ex) {
        if (this.source instanceof StreamSource && this.streamSourceAccessMarker != null) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"STREAMSOURCE_WAS_PREVIOUSLY_ACCESSED", (Object[])new Object[0]), (Throwable)this.streamSourceAccessMarker);
        }
        WSException.rethrow(ex);
    }

    public String toString() {
        return "[source=" + this.source + "]";
    }
}

