/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.XMLUtils;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.element.Reference;
import org.jboss.ws.extensions.security.element.X509Token;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyIdentifier
extends Reference {
    private static final ResourceBundle bundle = BundleUtils.getBundle(KeyIdentifier.class);
    public static final String SKI_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
    private Document doc;
    private String value;
    private Element cachedElement;

    public KeyIdentifier(Document doc, BinarySecurityToken token) throws WSSecurityException {
        this.doc = doc;
        this.referenceToken(token);
    }

    public KeyIdentifier(Element element) throws WSSecurityException {
        this.doc = element.getOwnerDocument();
        if (!"KeyIdentifier".equals(element.getLocalName())) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_LOCAL_NAME_ON_A_KEYIDENTIFIER", (Object[])new Object[0]));
        }
        String valueType = element.getAttribute("ValueType");
        if (valueType == null || valueType.length() == 0) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"KEYIDENTIFIER_ELEMENT_IS_MISSING_AN_VALUETYPE", (Object[])new Object[0]));
        }
        if (!SKI_TYPE.equals(valueType)) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ONLY_SUBJECTKEYIDENTIFIERS_SUPPORTED", (Object[])new Object[]{valueType}));
        }
        this.value = XMLUtils.getFullTextChildrenFromElement((Element)element);
    }

    public void referenceToken(BinarySecurityToken token) throws WSSecurityException {
        if (!(token instanceof X509Token)) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"KEYIDENTIFIER_TRIED_TO_REFERENCE", (Object[])new Object[0]));
        }
        X509Token x509 = (X509Token)token;
        X509Certificate cert = x509.getCert();
        byte[] encoded = cert.getExtensionValue("2.5.29.14");
        if (encoded == null) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_CONTAIN_A_SUBJECT_KEY_IDENTIFIER", (Object[])new Object[0]));
        }
        int trunc = encoded.length - 4;
        byte[] identifier = new byte[trunc];
        System.arraycopy(encoded, 4, identifier, 0, trunc);
        this.value = Base64.encode((byte[])identifier);
    }

    public String getValue() {
        return this.value;
    }

    public String getValueType() {
        return SKI_TYPE;
    }

    public Document getDocument() {
        return this.doc;
    }

    public byte[] getIdentifier() throws WSSecurityException {
        if (this.value == null) {
            return null;
        }
        try {
            return Base64.decode((String)this.value);
        }
        catch (Base64DecodingException e) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_DECODING_KEY_IDENTIFIER", (Object[])new Object[0]), e);
        }
    }

    @Override
    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
        element.setAttribute("ValueType", this.getValueType());
        element.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        element.appendChild(this.doc.createTextNode(this.value));
        this.cachedElement = element;
        return this.cachedElement;
    }
}

