/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.security.PublicKey;
import java.util.ResourceBundle;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.KeyResolver;
import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.element.SecurityProcess;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.w3c.dom.Element;

public class Signature
implements SecurityProcess {
    private static final ResourceBundle bundle = BundleUtils.getBundle(Signature.class);
    private static Logger log = Logger.getLogger(Signature.class);
    private XMLSignature signature;
    private PublicKey publicKey;
    private BinarySecurityToken securityToken;
    private Element cachedElement;

    public Signature(XMLSignature signature) {
        this.signature = signature;
    }

    public Signature(Element element, KeyResolver resolver) throws WSSecurityException {
        try {
            this.signature = new XMLSignature(element, null);
            this.publicKey = resolver.resolvePublicKey(this.signature.getKeyInfo());
            try {
                this.securityToken = resolver.resolve(this.signature.getKeyInfo());
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"KeyInfo does not contain any reference to a binary security token.", (Throwable)e);
                }
            }
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_DECODING_XML_SIGNATURE", (Object[])new Object[]{e.getMessage()}), e);
        }
    }

    public XMLSignature getSignature() {
        return this.signature;
    }

    public void setSignature(XMLSignature signature) {
        this.signature = signature;
    }

    @Override
    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        this.cachedElement = this.signature.getElement();
        return this.cachedElement;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public BinarySecurityToken getSecurityToken() {
        return this.securityToken;
    }
}

