/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra.processors;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.as.connector.deployers.Util;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.metadata.xmldescriptors.IronJacamarXmlDescriptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.metadata.ironjacamar.v10.IronJacamarParser;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class IronJacamarDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        block9: {
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            ResourceRoot resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            VirtualFile deploymentRoot = resourceRoot.getRoot();
            boolean resolveProperties = Util.shouldResolveJBoss(deploymentUnit);
            if (deploymentRoot == null || !deploymentRoot.exists()) {
                return;
            }
            String deploymentRootName = deploymentRoot.getName().toLowerCase(Locale.ENGLISH);
            VirtualFile serviceXmlFile = null;
            if (deploymentRootName.endsWith(".rar")) {
                serviceXmlFile = deploymentRoot.getChild("/META-INF/ironjacamar.xml");
            }
            if (serviceXmlFile == null || !serviceXmlFile.exists()) {
                return;
            }
            InputStream xmlStream = null;
            IronJacamar result = null;
            try {
                xmlStream = serviceXmlFile.openStream();
                IronJacamarParser ironJacamarParser = new IronJacamarParser();
                ironJacamarParser.setSystemPropertiesResolved(resolveProperties);
                result = ironJacamarParser.parse(xmlStream);
                if (result != null) {
                    IronJacamarXmlDescriptor xmlDescriptor = new IronJacamarXmlDescriptor(result);
                    deploymentUnit.putAttachment(IronJacamarXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
                    break block9;
                }
                throw ConnectorMessages.MESSAGES.failedToParseServiceXml(serviceXmlFile);
            }
            catch (Exception e) {
                throw ConnectorMessages.MESSAGES.failedToParseServiceXml(e, serviceXmlFile);
            }
            finally {
                VFSUtils.safeClose((Closeable)xmlStream);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

