/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.net.InetAddress;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.server.FutureServiceContainer;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class BootstrapListener
extends AbstractServiceListener<Object> {
    private final AtomicInteger started = new AtomicInteger();
    private final AtomicInteger failed = new AtomicInteger();
    private final AtomicInteger outstanding = new AtomicInteger(1);
    private final AtomicBoolean done = new AtomicBoolean();
    private final AtomicInteger missingDeps = new AtomicInteger();
    private final EnumMap<ServiceController.Mode, AtomicInteger> map;
    private final ServiceContainer serviceContainer;
    private final Set<ServiceName> missingDepsSet = Collections.synchronizedSet(new TreeSet());
    private final ServiceTarget serviceTarget;
    private final long startTime;
    private volatile boolean cancelLikely;
    private final FutureServiceContainer futureContainer;
    private final String prettyVersion;

    public BootstrapListener(ServiceContainer serviceContainer, long startTime, ServiceTarget serviceTarget, FutureServiceContainer futureContainer, String prettyVersion) {
        this.serviceContainer = serviceContainer;
        this.startTime = startTime;
        this.serviceTarget = serviceTarget;
        this.futureContainer = futureContainer;
        this.prettyVersion = prettyVersion;
        EnumMap<ServiceController.Mode, AtomicInteger> map = new EnumMap<ServiceController.Mode, AtomicInteger>(ServiceController.Mode.class);
        for (ServiceController.Mode mode : ServiceController.Mode.values()) {
            map.put(mode, new AtomicInteger());
        }
        this.map = map;
    }

    public void listenerAdded(ServiceController<?> controller) {
        ServiceController.Mode mode = controller.getMode();
        if (mode == ServiceController.Mode.ACTIVE) {
            this.outstanding.incrementAndGet();
        } else {
            controller.removeListener((ServiceListener)this);
        }
        this.map.get(mode).incrementAndGet();
    }

    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
        switch (transition) {
            case STARTING_to_UP: {
                this.started.incrementAndGet();
                controller.removeListener((ServiceListener)this);
                this.tick();
                break;
            }
            case STARTING_to_START_FAILED: {
                this.failed.incrementAndGet();
                controller.removeListener((ServiceListener)this);
                this.tick();
                break;
            }
            case START_REQUESTED_to_PROBLEM: {
                this.missingDeps.incrementAndGet();
                this.check();
                break;
            }
            case PROBLEM_to_START_REQUESTED: {
                this.missingDeps.decrementAndGet();
                this.check();
                break;
            }
            case REMOVING_to_REMOVED: {
                this.cancelLikely = true;
                this.tick();
            }
        }
    }

    private void check() {
        int outstanding = this.outstanding.get();
        if (outstanding == this.missingDeps.get()) {
            this.finish(this.serviceContainer, outstanding);
        }
    }

    public void tick() {
        int outstanding = this.outstanding.decrementAndGet();
        if (outstanding != this.missingDeps.get()) {
            return;
        }
        this.finish(this.serviceContainer, outstanding);
    }

    private void finish(ServiceContainer container, int outstanding) {
        if (this.done.getAndSet(true)) {
            return;
        }
        this.serviceTarget.removeListener((ServiceListener)this);
        if (this.cancelLikely) {
            return;
        }
        int failed = this.failed.get() + outstanding;
        long elapsedTime = Math.max(System.currentTimeMillis() - this.startTime, 0L);
        int started = this.started.get();
        this.done(container, elapsedTime, started, failed, this.map, this.missingDepsSet);
    }

    protected void done(ServiceContainer container, long elapsedTime, int started, int failed, EnumMap<ServiceController.Mode, AtomicInteger> map, Set<ServiceName> missingDepsSet) {
        this.futureContainer.done(container);
        this.logAdminConsole(container);
        int active = map.get(ServiceController.Mode.ACTIVE).get();
        int passive = map.get(ServiceController.Mode.PASSIVE).get();
        int onDemand = map.get(ServiceController.Mode.ON_DEMAND).get();
        int never = map.get(ServiceController.Mode.NEVER).get();
        if (failed == 0) {
            ServerLogger.AS_ROOT_LOGGER.startedClean(this.prettyVersion, elapsedTime, started, active + passive + onDemand + never, onDemand + passive);
        } else {
            ServerLogger.AS_ROOT_LOGGER.startedWitErrors(this.prettyVersion, elapsedTime, started, active + passive + onDemand + never, failed, onDemand + passive);
        }
    }

    private void logAdminConsole(ServiceContainer container) {
        ServiceController controller = container.getService(HttpManagementService.SERVICE_NAME);
        if (controller != null) {
            boolean hasHttps;
            HttpManagement mgmt = (HttpManagement)controller.getValue();
            boolean hasHttp = mgmt.getHttpNetworkInterfaceBinding() != null && mgmt.getHttpPort() > 0;
            boolean bl = hasHttps = mgmt.getHttpsNetworkInterfaceBinding() != null && mgmt.getHttpsPort() > 0;
            if (hasHttp && hasHttps) {
                ServerLogger.AS_ROOT_LOGGER.logHttpAndHttpsConsole(NetworkUtils.formatAddress((InetAddress)mgmt.getHttpNetworkInterfaceBinding().getAddress()), mgmt.getHttpPort(), NetworkUtils.formatAddress((InetAddress)mgmt.getHttpsNetworkInterfaceBinding().getAddress()), mgmt.getHttpsPort());
            } else if (hasHttp) {
                ServerLogger.AS_ROOT_LOGGER.logHttpConsole(NetworkUtils.formatAddress((InetAddress)mgmt.getHttpNetworkInterfaceBinding().getAddress()), mgmt.getHttpPort());
            } else if (hasHttps) {
                ServerLogger.AS_ROOT_LOGGER.logHttpsConsole(NetworkUtils.formatAddress((InetAddress)mgmt.getHttpsNetworkInterfaceBinding().getAddress()), mgmt.getHttpsPort());
            } else {
                ServerLogger.AS_ROOT_LOGGER.logNoConsole();
            }
        }
    }
}

