/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.DeleteException;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.SaveException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.registry.AuthTokenV3Singleton;
import org.apache.ws.scout.registry.BulkResponseImpl;
import org.apache.ws.scout.registry.ConnectionImpl;
import org.apache.ws.scout.registry.IRegistryV3;
import org.apache.ws.scout.registry.LifeCycleManagerImpl;
import org.apache.ws.scout.registry.RegistryV3Exception;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.registry.infomodel.OrganizationImpl;
import org.apache.ws.scout.registry.infomodel.ServiceImpl;
import org.apache.ws.scout.util.ScoutJaxrUddiV3Helper;
import org.apache.ws.scout.util.ScoutUddiV3JaxrHelper;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.AssertionStatusReport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.ErrInfo;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ObjectFactory;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.PublisherAssertions;
import org.uddi.api_v3.Result;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessLifeCycleManagerV3Impl
extends LifeCycleManagerImpl
implements BusinessLifeCycleManager,
Serializable {
    private static final long serialVersionUID = -1145007155334678356L;
    private Log log = LogFactory.getLog(this.getClass());
    private transient ObjectFactory objectFactory = new ObjectFactory();

    public BusinessLifeCycleManagerV3Impl(RegistryService registry) {
        super(registry);
        if (this.objectFactory == null) {
            this.objectFactory = new ObjectFactory();
        }
    }

    @Override
    public BulkResponse deleteObjects(Collection keys, String objectType) throws JAXRException {
        BulkResponse bulk = null;
        if (objectType == "Association") {
            bulk = this.deleteAssociations(keys);
        } else if (objectType == "ClassificationScheme") {
            bulk = this.deleteClassificationSchemes(keys);
        } else if (objectType == "Concept") {
            bulk = this.deleteConcepts(keys);
        } else if (objectType == "Organization") {
            bulk = this.deleteOrganizations(keys);
        } else if (objectType == "Service") {
            bulk = this.deleteServices(keys);
        } else if (objectType == "ServiceBinding") {
            bulk = this.deleteServiceBindings(keys);
        } else {
            throw new JAXRException("Delete Operation for " + objectType + " not implemented by Scout");
        }
        return bulk;
    }

    public BulkResponse deleteAssociations(Collection associationKeys) throws JAXRException {
        return this.deleteOperation(associationKeys, "DELETE_ASSOCIATION");
    }

    public BulkResponse deleteClassificationSchemes(Collection schemeKeys) throws JAXRException {
        return this.deleteOperation(schemeKeys, "DELETE_CLASSIFICATIONSCHEME");
    }

    public BulkResponse deleteConcepts(Collection conceptKeys) throws JAXRException {
        return this.deleteOperation(conceptKeys, "DELETE_CONCEPT");
    }

    public BulkResponse deleteOrganizations(Collection orgkeys) throws JAXRException {
        return this.deleteOperation(orgkeys, "DELETE_ORG");
    }

    public BulkResponse deleteServiceBindings(Collection bindingKeys) throws JAXRException {
        return this.deleteOperation(bindingKeys, "DELETE_SERVICEBINDING");
    }

    public BulkResponse deleteServices(Collection serviceKeys) throws JAXRException {
        return this.deleteOperation(serviceKeys, "DELETE_SERVICE");
    }

    @Override
    public BulkResponse saveObjects(Collection col) throws JAXRException {
        Iterator iter = col.iterator();
        LinkedHashSet suc = new LinkedHashSet();
        ArrayList<Exception> exc = new ArrayList<Exception>();
        while (iter.hasNext()) {
            RegistryObject reg = (RegistryObject)iter.next();
            BulkResponse br = null;
            ArrayList<RegistryObject> c = new ArrayList<RegistryObject>();
            c.add(reg);
            if (reg instanceof Association) {
                br = this.saveAssociations(c, true);
            } else if (reg instanceof ClassificationScheme) {
                br = this.saveClassificationSchemes(c);
            } else if (reg instanceof Concept) {
                br = this.saveConcepts(c);
            } else if (reg instanceof Organization) {
                br = this.saveOrganizations(c);
            } else if (reg instanceof Service) {
                br = this.saveServices(c);
            } else if (reg instanceof ServiceBinding) {
                br = this.saveServiceBindings(c);
            } else {
                throw new JAXRException("Delete Operation for " + reg.getClass() + " not implemented by Scout");
            }
            if (br.getCollection() != null) {
                suc.addAll(br.getCollection());
            }
            if (br.getExceptions() == null) continue;
            exc.addAll(br.getExceptions());
        }
        BulkResponseImpl bulk = new BulkResponseImpl();
        bulk.setStatus(0);
        bulk.setCollection(suc);
        bulk.setExceptions(exc);
        return bulk;
    }

    public BulkResponse saveAssociations(Collection associations, boolean replace) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        PublisherAssertion[] sarr = new PublisherAssertion[associations.size()];
        ArrayList<Key> coll = new ArrayList<Key>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Iterator iter = associations.iterator();
        int currLoc = 0;
        while (iter.hasNext()) {
            PublisherAssertion pa;
            Association association = (Association)iter.next();
            association.getSourceObject();
            sarr[currLoc] = pa = ScoutJaxrUddiV3Helper.getPubAssertionFromJAXRAssociation(association);
            ++currLoc;
            PublisherAssertions bd = null;
            try {
                bd = (PublisherAssertions)this.executeOperation(sarr, "SAVE_ASSOCIATION");
            }
            catch (RegistryV3Exception e) {
                exceptions.add((Exception)new SaveException((Throwable)e));
                bulk.setExceptions(exceptions);
                bulk.setStatus(2);
                return bulk;
            }
            if (bd == null) continue;
            List publisherAssertionList = bd.getPublisherAssertion();
            PublisherAssertion[] keyarr = new PublisherAssertion[publisherAssertionList.size()];
            publisherAssertionList.toArray(keyarr);
            for (int i = 0; keyarr != null && i < keyarr.length; ++i) {
                PublisherAssertion result = keyarr[i];
                KeyedReference keyr = result.getKeyedReference();
                ConceptImpl c = new ConceptImpl((LifeCycleManager)this.getRegistryService().getBusinessLifeCycleManager());
                c.setName(new InternationalStringImpl(keyr.getKeyName()));
                c.setKey(new KeyImpl(keyr.getTModelKey()));
                c.setValue(keyr.getKeyValue());
                association.setAssociationType((Concept)c);
                coll.add(association.getKey());
            }
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public BulkResponse saveClassificationSchemes(Collection schemes) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        TModel[] entityarr = new TModel[schemes.size()];
        LinkedHashSet<KeyImpl> coll = new LinkedHashSet<KeyImpl>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Iterator iter = schemes.iterator();
        int currLoc = 0;
        while (iter.hasNext()) {
            try {
                TModel en;
                entityarr[currLoc] = en = ScoutJaxrUddiV3Helper.getTModelFromJAXRClassificationScheme((ClassificationScheme)iter.next());
                ++currLoc;
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        this.log.debug((Object)("Method:save_classificationscheme: ENlength=" + entityarr.length));
        TModelDetail td = null;
        try {
            td = (TModelDetail)this.executeOperation(entityarr, "SAVE_TMODEL");
        }
        catch (RegistryV3Exception e) {
            exceptions.add((Exception)new SaveException(e.getLocalizedMessage()));
            bulk.setStatus(2);
            return bulk;
        }
        List tmodelList = td.getTModel();
        entityarr = new TModel[tmodelList.size()];
        tmodelList.toArray(entityarr);
        this.log.debug((Object)("After Saving TModel. Obtained vector size:" + entityarr != null ? entityarr.length : 0));
        for (int i = 0; entityarr != null && i < entityarr.length; ++i) {
            TModel tm = entityarr[i];
            coll.add(new KeyImpl(tm.getTModelKey()));
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public BulkResponse saveConcepts(Collection concepts) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        TModel[] entityarr = new TModel[concepts.size()];
        LinkedHashSet<KeyImpl> coll = new LinkedHashSet<KeyImpl>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Iterator iter = concepts.iterator();
        int currLoc = 0;
        while (iter.hasNext()) {
            try {
                TModel en;
                entityarr[currLoc] = en = ScoutJaxrUddiV3Helper.getTModelFromJAXRConcept((Concept)iter.next());
                ++currLoc;
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        this.log.debug((Object)("Method:save_concept: ENlength=" + entityarr.length));
        TModelDetail td = null;
        try {
            td = (TModelDetail)this.executeOperation(entityarr, "SAVE_TMODEL");
        }
        catch (RegistryV3Exception e) {
            exceptions.add((Exception)new SaveException(e.getLocalizedMessage()));
            bulk.setStatus(2);
            return bulk;
        }
        List tmodelList = td.getTModel();
        entityarr = new TModel[tmodelList.size()];
        tmodelList.toArray(entityarr);
        this.log.debug((Object)("After Saving TModel. Obtained vector size:" + entityarr != null ? entityarr.length : 0));
        for (int i = 0; entityarr != null && i < entityarr.length; ++i) {
            TModel tm = entityarr[i];
            coll.add(new KeyImpl(tm.getTModelKey()));
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public BulkResponse saveOrganizations(Collection organizations) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        BusinessEntity[] entityarr = new BusinessEntity[organizations.size()];
        LinkedHashSet<KeyImpl> coll = new LinkedHashSet<KeyImpl>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Iterator iter = organizations.iterator();
        int currLoc = 0;
        while (iter.hasNext()) {
            try {
                BusinessEntity en;
                entityarr[currLoc] = en = ScoutJaxrUddiV3Helper.getBusinessEntityFromJAXROrg((Organization)iter.next());
                ++currLoc;
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        this.log.debug((Object)("Method:save_business: ENlength=" + entityarr.length));
        BusinessDetail bd = null;
        try {
            bd = (BusinessDetail)this.executeOperation(entityarr, "SAVE_ORG");
        }
        catch (RegistryV3Exception e) {
            exceptions.add((Exception)new SaveException(e.getLocalizedMessage()));
            bulk.setStatus(2);
            return bulk;
        }
        List bizEntityList = bd.getBusinessEntity();
        entityarr = new BusinessEntity[bizEntityList.size()];
        bizEntityList.toArray(entityarr);
        this.log.debug((Object)("After Saving Business. Obtained vector size:" + entityarr != null ? entityarr.length : 0));
        for (int i = 0; entityarr != null && i < entityarr.length; ++i) {
            BusinessEntity entity = entityarr[i];
            coll.add(new KeyImpl(entity.getBusinessKey()));
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public BulkResponse saveServiceBindings(Collection bindings) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        BindingTemplate[] sbarr = new BindingTemplate[bindings.size()];
        LinkedHashSet<KeyImpl> coll = new LinkedHashSet<KeyImpl>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Iterator iter = bindings.iterator();
        int currLoc = 0;
        while (iter.hasNext()) {
            try {
                BindingTemplate bs;
                sbarr[currLoc] = bs = ScoutJaxrUddiV3Helper.getBindingTemplateFromJAXRSB((ServiceBinding)iter.next());
                ++currLoc;
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        BindingDetail bd = null;
        try {
            bd = (BindingDetail)this.executeOperation(sbarr, "SAVE_SERVICE_BINDING");
        }
        catch (RegistryV3Exception e) {
            exceptions.add((Exception)new SaveException(e.getLocalizedMessage()));
            bulk.setStatus(2);
            return bulk;
        }
        List bindingTemplateList = bd.getBindingTemplate();
        sbarr = new BindingTemplate[bindingTemplateList.size()];
        bindingTemplateList.toArray(sbarr);
        for (int i = 0; sbarr != null && i < sbarr.length; ++i) {
            BindingTemplate bt = sbarr[i];
            coll.add(new KeyImpl(bt.getBindingKey()));
        }
        if (coll.size() > 0) {
            bulk.setCollection(coll);
        }
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public BulkResponse saveServices(Collection services) throws JAXRException {
        BulkResponseImpl bulk = new BulkResponseImpl();
        BusinessService[] sarr = new BusinessService[services.size()];
        LinkedHashSet<KeyImpl> coll = new LinkedHashSet<KeyImpl>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Iterator iter = services.iterator();
        int currLoc = 0;
        while (iter.hasNext()) {
            try {
                BusinessService bs;
                sarr[currLoc] = bs = ScoutJaxrUddiV3Helper.getBusinessServiceFromJAXRService((Service)iter.next());
                ++currLoc;
            }
            catch (ClassCastException ce) {
                throw new UnexpectedObjectException();
            }
        }
        ServiceDetail sd = null;
        try {
            sd = (ServiceDetail)this.executeOperation(sarr, "SAVE_SERVICE");
        }
        catch (RegistryV3Exception e) {
            exceptions.add((Exception)new SaveException(e.getLocalizedMessage()));
            bulk.setStatus(2);
            return bulk;
        }
        List bizServiceList = sd.getBusinessService();
        sarr = new BusinessService[bizServiceList.size()];
        bizServiceList.toArray(sarr);
        for (int i = 0; sarr != null && i < sarr.length; ++i) {
            BusinessService entity = sarr[i];
            coll.add(new KeyImpl(entity.getServiceKey()));
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    public void confirmAssociation(Association assoc) throws JAXRException, InvalidRequestException {
        HashSet<Association> col = new HashSet<Association>();
        col.add(assoc);
        BulkResponse br = this.saveAssociations(col, true);
        if (br.getExceptions() != null) {
            throw new JAXRException("Confiming the Association Failed");
        }
    }

    public void unConfirmAssociation(Association assoc) throws JAXRException, InvalidRequestException {
        ArrayList<Key> col = new ArrayList<Key>();
        col.add(assoc.getKey());
        BulkResponse br = this.deleteAssociations(col);
        if (br.getExceptions() != null) {
            throw new JAXRException("UnConfiming the Association Failed");
        }
    }

    protected Object executeOperation(Object dataarray, String op) throws RegistryV3Exception, JAXRException {
        PublisherAssertions regobj;
        if (this.registry == null) {
            throw new IllegalStateException("No registry");
        }
        IRegistryV3 ireg = (IRegistryV3)this.registry.getRegistry();
        ConnectionImpl connection = this.registry.getConnection();
        AuthToken token = this.getAuthToken(connection, ireg);
        if (token == null) {
            throw new IllegalStateException("No auth token returned");
        }
        if (op.equalsIgnoreCase("SAVE_ASSOCIATION")) {
            try {
                regobj = ireg.setPublisherAssertions(token.getAuthInfo(), (PublisherAssertion[])dataarray);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.setPublisherAssertions(token.getAuthInfo(), (PublisherAssertion[])dataarray);
            }
        } else if (op.equalsIgnoreCase("SAVE_SERVICE")) {
            try {
                regobj = ireg.saveService(token.getAuthInfo(), (BusinessService[])dataarray);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.saveService(token.getAuthInfo(), (BusinessService[])dataarray);
            }
        } else if (op.equalsIgnoreCase("SAVE_SERVICE_BINDING")) {
            try {
                regobj = ireg.saveBinding(token.getAuthInfo(), (BindingTemplate[])dataarray);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.saveBinding(token.getAuthInfo(), (BindingTemplate[])dataarray);
            }
        } else if (op.equalsIgnoreCase("SAVE_ORG")) {
            try {
                regobj = ireg.saveBusiness(token.getAuthInfo(), (BusinessEntity[])dataarray);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.saveBusiness(token.getAuthInfo(), (BusinessEntity[])dataarray);
            }
        } else if (op.equalsIgnoreCase("SAVE_TMODEL")) {
            try {
                regobj = ireg.saveTModel(token.getAuthInfo(), (TModel[])dataarray);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.saveTModel(token.getAuthInfo(), (TModel[])dataarray);
            }
        } else if (op.equalsIgnoreCase("DELETE_ORG")) {
            try {
                this.clearPublisherAssertions(token.getAuthInfo(), ireg);
                regobj = ireg.deleteBusiness(token.getAuthInfo(), (String[])dataarray);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.deleteBusiness(token.getAuthInfo(), (String[])dataarray);
            }
        } else if (op.equalsIgnoreCase("DELETE_SERVICE")) {
            try {
                regobj = ireg.deleteService(token.getAuthInfo(), (String[])dataarray);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.deleteService(token.getAuthInfo(), (String[])dataarray);
            }
        } else if (op.equalsIgnoreCase("DELETE_SERVICEBINDING")) {
            try {
                regobj = ireg.deleteBinding(token.getAuthInfo(), (String[])dataarray);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.deleteBinding(token.getAuthInfo(), (String[])dataarray);
            }
        } else if (op.equalsIgnoreCase("DELETE_CONCEPT")) {
            try {
                regobj = ireg.deleteTModel(token.getAuthInfo(), (String[])dataarray);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.deleteTModel(token.getAuthInfo(), (String[])dataarray);
            }
        } else if (op.equalsIgnoreCase("DELETE_ASSOCIATION")) {
            int len = ((String[])dataarray).length;
            PublisherAssertion[] paarr = new PublisherAssertion[len];
            for (int i = 0; i < len; ++i) {
                String keystr = ((String[])dataarray)[i];
                paarr[i] = ScoutJaxrUddiV3Helper.getPubAssertionFromJAXRAssociationKey(keystr);
            }
            try {
                regobj = ireg.deletePublisherAssertions(token.getAuthInfo(), paarr);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.deletePublisherAssertions(token.getAuthInfo(), paarr);
            }
        } else if (op.equalsIgnoreCase("DELETE_CLASSIFICATIONSCHEME")) {
            try {
                regobj = ireg.deleteTModel(token.getAuthInfo(), (String[])dataarray);
            }
            catch (RegistryV3Exception rve) {
                String username = this.getUsernameFromCredentials(connection.getCredentials());
                if (AuthTokenV3Singleton.getToken(username) != null) {
                    AuthTokenV3Singleton.deleteAuthToken(username);
                }
                token = this.getAuthToken(connection, ireg);
                regobj = ireg.deleteTModel(token.getAuthInfo(), (String[])dataarray);
            }
        } else {
            throw new JAXRException("Unsupported operation:" + op);
        }
        return regobj;
    }

    private void clearPublisherAssertions(String authinfo, IRegistryV3 ireg) {
        Vector<PublisherAssertion> pasvect = null;
        PublisherAssertion[] pasarr = null;
        try {
            AssertionStatusItem asi;
            int i;
            AssertionStatusReport report = ireg.getAssertionStatusReport(authinfo, "status:complete");
            List assertionStatusItemList = report.getAssertionStatusItem();
            AssertionStatusItem[] assertionStatusItemArr = new AssertionStatusItem[assertionStatusItemList.size()];
            int len = assertionStatusItemArr != null ? assertionStatusItemArr.length : 0;
            for (i = 0; i < len; ++i) {
                asi = assertionStatusItemArr[i];
                if (pasvect == null) {
                    pasvect = new Vector<PublisherAssertion>(len);
                }
                pasvect.add(this.getPublisherAssertion(asi));
            }
            report = ireg.getAssertionStatusReport(authinfo, "status:toKey_incomplete");
            assertionStatusItemArr = report.getAssertionStatusItem().toArray(assertionStatusItemArr);
            len = assertionStatusItemArr != null ? assertionStatusItemArr.length : 0;
            for (i = 0; i < len; ++i) {
                asi = assertionStatusItemArr[i];
                if (pasvect == null) {
                    pasvect = new Vector(len);
                }
                pasvect.add(this.getPublisherAssertion(asi));
            }
            report = ireg.getAssertionStatusReport(authinfo, "status:fromKey_incomplete");
            assertionStatusItemArr = report.getAssertionStatusItem().toArray(assertionStatusItemArr);
            len = assertionStatusItemArr != null ? assertionStatusItemArr.length : 0;
            for (i = 0; i < len; ++i) {
                asi = assertionStatusItemArr[i];
                if (pasvect == null) {
                    pasvect = new Vector(len);
                }
                pasvect.add(this.getPublisherAssertion(asi));
            }
            if (pasvect != null) {
                pasarr = new PublisherAssertion[pasvect.size()];
                Iterator iter = pasvect.iterator();
                int pasarrPos = 0;
                while (iter.hasNext()) {
                    pasarr[pasarrPos] = (PublisherAssertion)iter.next();
                    ++pasarrPos;
                }
            }
        }
        catch (RegistryV3Exception e) {
            throw new RuntimeException(e);
        }
        if (pasarr != null && pasarr.length > 0) {
            try {
                ireg.deletePublisherAssertions(authinfo, pasarr);
            }
            catch (RegistryV3Exception e) {
                this.log.debug((Object)("Ignoring exception " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected BulkResponse deleteOperation(Collection<Key> keys, String op) throws JAXRException {
        if (keys == null) {
            throw new JAXRException("Keys provided to " + op + " are null");
        }
        BulkResponseImpl bulk = new BulkResponseImpl();
        String[] keyarr = new String[keys.size()];
        LinkedHashSet<Key> coll = new LinkedHashSet<Key>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        try {
            Iterator<Key> iter = keys.iterator();
            int currLoc = 0;
            while (iter.hasNext()) {
                Key key = iter.next();
                keyarr[currLoc] = key.getId();
                ++currLoc;
            }
            DispositionReport bd = (DispositionReport)this.executeOperation(keyarr, op);
            List resultList = bd.getResult();
            Result[] keyResultArr = new Result[resultList.size()];
            resultList.toArray(keyResultArr);
            this.log.debug((Object)("After deleting Business. Obtained vector size:" + keyResultArr != null ? keyResultArr.length : 0));
            for (int i = 0; keyResultArr != null && i < keyResultArr.length; ++i) {
                Result result = keyResultArr[i];
                int errno = result.getErrno();
                if (errno == 0) {
                    coll.addAll(keys);
                    continue;
                }
                ErrInfo errinfo = result.getErrInfo();
                DeleteException de = new DeleteException(errinfo.getErrCode() + ":" + errinfo.getValue());
                bulk.setStatus(2);
                exceptions.add((Exception)de);
            }
        }
        catch (RegistryV3Exception regExcept) {
            DeleteException de = new DeleteException(regExcept.getFaultCode() + ":" + regExcept.getFaultString(), (Throwable)regExcept);
            bulk.setStatus(2);
            exceptions.add((Exception)de);
        }
        catch (JAXRException tran) {
            exceptions.add((Exception)((Object)new JAXRException("Apache JAXR Impl:", (Throwable)tran)));
            bulk.setStatus(2);
        }
        bulk.setCollection(coll);
        bulk.setExceptions(exceptions);
        return bulk;
    }

    private String getUsernameFromCredentials(Set credentials) {
        String username = "";
        String pwd = "";
        if (credentials != null) {
            for (PasswordAuthentication pass : credentials) {
                username = pass.getUserName();
            }
        }
        return username;
    }

    private AuthToken getAuthToken(ConnectionImpl connection, IRegistryV3 ireg) throws JAXRException {
        Set creds = connection.getCredentials();
        String username = "";
        String pwd = "";
        if (creds != null) {
            for (PasswordAuthentication pass : creds) {
                username = pass.getUserName();
                pwd = new String(pass.getPassword());
            }
        }
        if (AuthTokenV3Singleton.getToken(username) != null) {
            return AuthTokenV3Singleton.getToken(username);
        }
        AuthToken token = null;
        try {
            token = ireg.getAuthToken(username, pwd);
        }
        catch (Exception e) {
            throw new JAXRException((Throwable)e);
        }
        AuthTokenV3Singleton.addAuthToken(username, token);
        return token;
    }

    private PublisherAssertion getPublisherAssertion(AssertionStatusItem asi) {
        PublisherAssertion pa = this.objectFactory.createPublisherAssertion();
        if (asi != null) {
            KeyedReference keyr;
            String sourceKey = asi.getFromKey();
            String targetKey = asi.getToKey();
            if (sourceKey != null) {
                pa.setFromKey(sourceKey);
            }
            if (targetKey != null) {
                pa.setToKey(targetKey);
            }
            if ((keyr = asi.getKeyedReference()) != null) {
                pa.setKeyedReference(keyr);
            }
        }
        return pa;
    }

    Organization createOrganization(BusinessDetail bizDetail) throws JAXRException {
        return ScoutUddiV3JaxrHelper.getOrganization(bizDetail, (LifeCycleManager)this);
    }

    Organization createOrganization(BusinessInfo bizInfo) throws JAXRException {
        String key = bizInfo.getBusinessKey();
        List names = bizInfo.getName();
        List descriptions = bizInfo.getDescription();
        List serviceInfos = bizInfo.getServiceInfos().getServiceInfo();
        OrganizationImpl org = new OrganizationImpl(this);
        org.setKey(this.createKey(key));
        if (names != null && names.size() > 0) {
            org.setName(this.createInternationalString(((Name)names.get(0)).getValue()));
        }
        if (descriptions != null && descriptions.size() > 0) {
            org.setDescription(this.createInternationalString(((Description)descriptions.get(0)).getValue()));
        }
        if (serviceInfos != null && serviceInfos.size() > 0) {
            ArrayList<Service> services = new ArrayList<Service>(serviceInfos.size());
            for (int i = 0; i < serviceInfos.size(); ++i) {
                ServiceInfo serviceInfo = (ServiceInfo)serviceInfos.get(i);
                services.add(this.createService(serviceInfo));
            }
            org.addServices(services);
        }
        return org;
    }

    Service createService(ServiceInfo serviceInfo) throws JAXRException {
        String key = serviceInfo.getServiceKey();
        List names = serviceInfo.getName();
        ServiceImpl service = new ServiceImpl(this);
        service.setKey(this.createKey(key));
        if (names != null && names.size() > 0) {
            service.setName(this.createInternationalString(((Name)names.get(0)).getValue()));
        }
        return service;
    }
}

