/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.RegistryEntryImpl;

public class ClassificationSchemeImpl
extends RegistryEntryImpl
implements ClassificationScheme {
    private Collection<Concept> childConcepts = new ArrayList<Concept>();
    private boolean external = false;

    public ClassificationSchemeImpl(LifeCycleManager lifeCycleManager) {
        super(lifeCycleManager);
    }

    public void addChildConcept(Concept concept) throws JAXRException {
        this.childConcepts.add(concept);
    }

    public void addChildConcepts(Collection collection) throws JAXRException {
        this.childConcepts.addAll(collection);
    }

    public int getChildConceptCount() throws JAXRException {
        return this.childConcepts.size();
    }

    public Collection getChildrenConcepts() throws JAXRException {
        return this.childConcepts;
    }

    public Collection getDescendantConcepts() throws JAXRException {
        ArrayList<Concept> coll = new ArrayList<Concept>();
        Iterator<Concept> iter = this.childConcepts.iterator();
        while (iter != null && iter.hasNext()) {
            ConceptImpl c = (ConceptImpl)iter.next();
            coll.add(c);
            coll.addAll(c.getDescendantConcepts());
        }
        return coll;
    }

    public int getValueType() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    protected void setExternal(boolean b) {
        this.external = b;
    }

    public boolean isExternal() throws JAXRException {
        return this.external;
    }

    public void removeChildConcept(Concept concept) throws JAXRException {
        this.childConcepts.remove(concept);
    }

    public void removeChildConcepts(Collection collection) throws JAXRException {
        this.childConcepts.removeAll(collection);
    }

    public void setValueType(int param) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }
}

