/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml.metadata;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.saml.metadata.SAMLEntityDescriptorParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.ExtensionsType;
import org.w3c.dom.Element;

public class SAMLEntitiesDescriptorParser
implements ParserNamespaceSupport {
    private final String EDT = JBossSAMLConstants.ENTITIES_DESCRIPTOR.get();

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        Attribute cacheDuration;
        Attribute name;
        Attribute id;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, this.EDT);
        EntitiesDescriptorType entitiesDescriptorType = new EntitiesDescriptorType();
        Attribute validUntil = startElement.getAttributeByName(new QName(JBossSAMLConstants.VALID_UNTIL.get()));
        if (validUntil != null) {
            String validUntilValue = StaxParserUtil.getAttributeValue(validUntil);
            entitiesDescriptorType.setValidUntil(XMLTimeUtil.parse(validUntilValue));
        }
        if ((id = startElement.getAttributeByName(new QName(JBossSAMLConstants.ID.get()))) != null) {
            entitiesDescriptorType.setID(StaxParserUtil.getAttributeValue(id));
        }
        if ((name = startElement.getAttributeByName(new QName(JBossSAMLConstants.NAME.get()))) != null) {
            entitiesDescriptorType.setName(StaxParserUtil.getAttributeValue(name));
        }
        if ((cacheDuration = startElement.getAttributeByName(new QName(JBossSAMLConstants.CACHE_DURATION.get()))) != null) {
            entitiesDescriptorType.setCacheDuration(XMLTimeUtil.parseAsDuration(StaxParserUtil.getAttributeValue(cacheDuration)));
        }
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                StaxParserUtil.validate((EndElement)xmlEvent, this.EDT);
                StaxParserUtil.getNextEndElement(xmlEventReader);
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ENTITY_DESCRIPTOR.get().equals(localPart)) {
                SAMLEntityDescriptorParser entityParser = new SAMLEntityDescriptorParser();
                entitiesDescriptorType.addEntityDescriptor(entityParser.parse(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.EXTENSIONS.get().equalsIgnoreCase(localPart)) {
                entitiesDescriptorType.setExtensions(this.parseExtensions(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ENTITIES_DESCRIPTOR.get().equalsIgnoreCase(localPart)) {
                SAMLEntitiesDescriptorParser parser = new SAMLEntitiesDescriptorParser();
                entitiesDescriptorType.addEntityDescriptor(parser.parse(xmlEventReader));
                continue;
            }
            if (localPart.equals(JBossSAMLConstants.SIGNATURE.get())) {
                entitiesDescriptorType.setSignature(StaxParserUtil.getDOMElement(xmlEventReader));
                continue;
            }
            throw new RuntimeException("PL00062: Parser : Unknown tag:" + localPart + " ::location=" + startElement.getLocation());
        }
        return entitiesDescriptorType;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(this.EDT);
    }

    private ExtensionsType parseExtensions(XMLEventReader xmlEventReader) throws ParsingException {
        ExtensionsType extensions = new ExtensionsType();
        Element extElement = StaxParserUtil.getDOMElement(xmlEventReader);
        extensions.setElement(extElement);
        return extensions;
    }
}

