/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.plugins.saml;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.sts.AbstractSecurityTokenProvider;
import org.picketlink.identity.federation.core.wstrust.StandardSecurityToken;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestContext;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AudienceRestrictionCondition;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ConditionsType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11NameIdentifierType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11StatementAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.RequestedReferenceType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.w3c.dom.Element;

public class SAML11TokenProvider
extends AbstractSecurityTokenProvider {
    protected static Logger logger = Logger.getLogger(SAML11TokenProvider.class);

    public void cancelToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext wstContext = (WSTrustRequestContext)context;
        Element token = wstContext.getRequestSecurityToken().getCancelTargetElement();
        if (token == null) {
            throw new ProcessingException("PL00092: Null Value:Invalid cancel request: missing required CancelTarget");
        }
        Element assertionElement = (Element)token.getFirstChild();
        if (!this.isSAMLAssertion(assertionElement)) {
            throw new ProcessingException("PL00080: Invalid Assertion:CancelTarget doesn't not contain a SAMLV1.1 assertion");
        }
        String assertionId = assertionElement.getAttribute("AssertionID");
        this.revocationRegistry.revokeToken("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1", assertionId);
    }

    public void issueToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext wstContext = (WSTrustRequestContext)context;
        String assertionID = IDGenerator.create("ID_");
        Lifetime lifetime = wstContext.getRequestSecurityToken().getLifetime();
        SAML11AudienceRestrictionCondition restriction = null;
        AppliesTo appliesTo = wstContext.getRequestSecurityToken().getAppliesTo();
        if (appliesTo != null) {
            restriction = new SAML11AudienceRestrictionCondition();
            restriction.add(URI.create(WSTrustUtil.parseAppliesTo(appliesTo)));
        }
        SAML11ConditionsType conditions = new SAML11ConditionsType();
        conditions.setNotBefore(lifetime.getCreated());
        conditions.setNotOnOrAfter(lifetime.getExpires());
        conditions.add(restriction);
        Principal principal = wstContext.getCallerPrincipal();
        String confirmationMethod = null;
        KeyInfoType keyInfoType = null;
        if (wstContext.getOnBehalfOfPrincipal() != null) {
            principal = wstContext.getOnBehalfOfPrincipal();
            confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
        } else if (wstContext.getProofTokenInfo() != null) {
            confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
            keyInfoType = wstContext.getProofTokenInfo();
        } else {
            confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
        }
        SAML11SubjectConfirmationType subjectConfirmation = new SAML11SubjectConfirmationType();
        subjectConfirmation.addConfirmationMethod(URI.create(confirmationMethod));
        if (keyInfoType != null) {
            throw new IllegalStateException("PL00082: Not Implemented Yet:");
        }
        String subjectName = principal == null ? "ANONYMOUS" : principal.getName();
        SAML11NameIdentifierType nameId = new SAML11NameIdentifierType(subjectName);
        nameId.setFormat(URI.create("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
        SAML11SubjectType subject = new SAML11SubjectType();
        subject.setChoice(new SAML11SubjectType.SAML11SubjectTypeChoice(nameId));
        subject.setSubjectConfirmation(subjectConfirmation);
        SAML11AuthenticationStatementType authStatement = new SAML11AuthenticationStatementType(URI.create("urn:picketlink:auth"), lifetime.getCreated());
        authStatement.setSubject(subject);
        SAML11AssertionType assertion = new SAML11AssertionType(assertionID, lifetime.getCreated());
        assertion.add(authStatement);
        assertion.setConditions(conditions);
        assertion.setIssuer(wstContext.getTokenIssuer());
        Element assertionElement = null;
        try {
            assertionElement = SAMLUtil.toElement(assertion);
        }
        catch (Exception e) {
            throw new ProcessingException("PL00102: Processing Exception:Failed to marshall SAMLV1.1 assertion", e);
        }
        StandardSecurityToken token = new StandardSecurityToken(wstContext.getRequestSecurityToken().getTokenType().toString(), assertionElement, assertionID);
        wstContext.setSecurityToken(token);
        KeyIdentifierType keyIdentifier = WSTrustUtil.createKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", "#" + assertionID);
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        attributes.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType", "wsse11"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        RequestedReferenceType attachedReference = WSTrustUtil.createRequestedReference(keyIdentifier, attributes);
        wstContext.setAttachedReference(attachedReference);
    }

    public void renewToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext wstContext = (WSTrustRequestContext)context;
        Element token = wstContext.getRequestSecurityToken().getRenewTargetElement();
        if (token == null) {
            throw new ProcessingException("PL00092: Null Value:Invalid renew request: missing required RenewTarget");
        }
        Element oldAssertionElement = (Element)token.getFirstChild();
        if (!this.isSAMLAssertion(oldAssertionElement)) {
            throw new ProcessingException("PL00080: Invalid Assertion:RenewTarget doesn't not contain a SAMLV1.1 assertion");
        }
        SAML11AssertionType oldAssertion = null;
        try {
            oldAssertion = SAMLUtil.saml11FromElement(oldAssertionElement);
        }
        catch (Exception je) {
            throw new ProcessingException("PL00102: Processing Exception:Error unmarshalling assertion", je);
        }
        if (this.revocationRegistry.isRevoked("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1", oldAssertion.getID())) {
            throw new ProcessingException("PL00103:Assertion Renewal Exception:SAMLV1.1 Assertion with id " + oldAssertion.getID() + " has been canceled and cannot be renewed");
        }
        SAML11ConditionsType conditions = oldAssertion.getConditions();
        conditions.setNotBefore(wstContext.getRequestSecurityToken().getLifetime().getCreated());
        conditions.setNotOnOrAfter(wstContext.getRequestSecurityToken().getLifetime().getExpires());
        String assertionID = IDGenerator.create("ID_");
        ArrayList<SAML11StatementAbstractType> statements = new ArrayList<SAML11StatementAbstractType>();
        statements.addAll(oldAssertion.getStatements());
        SAML11AssertionType newAssertion = new SAML11AssertionType(assertionID, conditions.getNotBefore());
        newAssertion.addAllStatements(statements);
        newAssertion.setConditions(conditions);
        newAssertion.setIssuer(wstContext.getTokenIssuer());
        Element assertionElement = null;
        try {
            assertionElement = SAMLUtil.toElement(newAssertion);
        }
        catch (Exception e) {
            throw new ProcessingException("PL00102: Processing Exception:Failed to marshall SAMLV1.1 assertion", e);
        }
        StandardSecurityToken securityToken = new StandardSecurityToken(wstContext.getRequestSecurityToken().getTokenType().toString(), assertionElement, assertionID);
        wstContext.setSecurityToken(securityToken);
        KeyIdentifierType keyIdentifier = WSTrustUtil.createKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", "#" + assertionID);
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        attributes.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        RequestedReferenceType attachedReference = WSTrustUtil.createRequestedReference(keyIdentifier, attributes);
        wstContext.setAttachedReference(attachedReference);
    }

    public void validateToken(ProtocolContext context) throws ProcessingException {
        Element token;
        if (!(context instanceof WSTrustRequestContext)) {
            return;
        }
        WSTrustRequestContext wstContext = (WSTrustRequestContext)context;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SAML V1.1 token validation started");
        }
        if ((token = wstContext.getRequestSecurityToken().getValidateTargetElement()) == null) {
            throw new ProcessingException("PL00092: Null Value:Bad validate request: missing required ValidateTarget");
        }
        String code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid";
        String reason = "SAMLV1.1 Assertion successfuly validated";
        SAML11AssertionType assertion = null;
        Element assertionElement = (Element)token.getFirstChild();
        if (!this.isSAMLAssertion(assertionElement)) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: supplied token is not a SAMLV1.1 Assertion";
        } else {
            try {
                assertion = SAMLUtil.saml11FromElement(assertionElement);
            }
            catch (Exception e) {
                throw new ProcessingException("PL00102: Processing Exception:Unmarshalling error:", e);
            }
        }
        if (this.revocationRegistry.isRevoked("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1", assertion.getID())) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: assertion with id " + assertion.getID() + " has been canceled";
        }
        try {
            if (AssertionUtil.hasExpired(assertion)) {
                code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
                reason = "Validation failure: assertion expired or used before its lifetime period";
            }
        }
        catch (Exception ce) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: unable to verify assertion lifetime: " + ce.getMessage();
        }
        StatusType status = new StatusType();
        status.setCode(code);
        status.setReason(reason);
        wstContext.setStatus(status);
    }

    public String family() {
        return SecurityTokenProvider.FAMILY_TYPE.WS_TRUST.toString();
    }

    public QName getSupportedQName() {
        return new QName(this.tokenType(), JBossSAMLConstants.ASSERTION.get());
    }

    public boolean supports(String namespace) {
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace);
    }

    public String tokenType() {
        return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
    }

    private boolean isSAMLAssertion(Element element) {
        return element == null ? false : "Assertion".equals(element.getLocalName()) && "urn:oasis:names:tc:SAML:1.0:assertion".equals(element.getNamespaceURI());
    }
}

