/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.wrappers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.ws.addressing.EndpointReferenceType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.policy.Policy;
import org.picketlink.identity.federation.ws.policy.PolicyReference;
import org.picketlink.identity.federation.ws.trust.AllowPostdatingType;
import org.picketlink.identity.federation.ws.trust.CancelTargetType;
import org.picketlink.identity.federation.ws.trust.ClaimsType;
import org.picketlink.identity.federation.ws.trust.DelegateToType;
import org.picketlink.identity.federation.ws.trust.EncryptionType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.LifetimeType;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.trust.ProofEncryptionType;
import org.picketlink.identity.federation.ws.trust.RenewTargetType;
import org.picketlink.identity.federation.ws.trust.RenewingType;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenType;
import org.picketlink.identity.federation.ws.trust.UseKeyType;
import org.picketlink.identity.federation.ws.trust.ValidateTargetType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestSecurityToken
implements BaseRequestSecurityToken {
    private final RequestSecurityTokenType delegate;
    private URI tokenType;
    private URI requestType;
    private AppliesTo appliesTo;
    private ClaimsType claims;
    private EntropyType entropy;
    private Lifetime lifetime;
    private AllowPostdatingType allowPostDating;
    private RenewingType renewing;
    private OnBehalfOfType onBehalfOf;
    private EndpointReferenceType issuer;
    private URI authenticationType;
    private URI keyType;
    private long keySize;
    private URI signatureAlgorithm;
    private EncryptionType encryption;
    private URI encryptionAlgorithm;
    private URI canonicalizationAlgorithm;
    private URI keyWrapAlgorithm;
    private ProofEncryptionType proofEncryption;
    private UseKeyType useKey;
    private URI signWith;
    private URI encryptWith;
    private DelegateToType delegateTo;
    private boolean forwardable;
    private boolean delegatable;
    private Policy policy;
    private PolicyReference policyReference;
    private ValidateTargetType validateTarget;
    private RenewTargetType renewTarget;
    private CancelTargetType cancelTarget;
    private final List<Object> extensionElements = new ArrayList<Object>();
    private Document rstDocument;
    private URI binaryValueType;
    private Node binaryToken;

    public RequestSecurityToken() {
        this.delegate = new RequestSecurityTokenType();
    }

    public RequestSecurityToken(RequestSecurityTokenType delegate) {
        this.delegate = delegate;
        for (Object obj : this.delegate.getAny()) {
            if (obj instanceof AppliesTo) {
                this.appliesTo = (AppliesTo)obj;
                continue;
            }
            if (obj instanceof Policy) {
                this.policy = (Policy)obj;
                continue;
            }
            if (obj instanceof PolicyReference) {
                this.policyReference = (PolicyReference)obj;
                continue;
            }
            if (obj instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)obj;
                String localName = element.getName().getLocalPart();
                if (localName.equalsIgnoreCase("TokenType")) {
                    this.tokenType = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("RequestType")) {
                    this.requestType = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("Claims")) {
                    this.claims = (ClaimsType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Entropy")) {
                    this.entropy = (EntropyType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Lifetime")) {
                    this.lifetime = new Lifetime((LifetimeType)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("AllowPostdating")) {
                    this.allowPostDating = (AllowPostdatingType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Renewing")) {
                    this.renewing = (RenewingType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("OnBehalfOf")) {
                    this.onBehalfOf = (OnBehalfOfType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Issuer")) {
                    this.issuer = (EndpointReferenceType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("AuthenticationType")) {
                    this.authenticationType = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("KeyType")) {
                    this.keyType = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("KeySize")) {
                    this.keySize = (Long)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("SignatureAlgorithm")) {
                    this.signatureAlgorithm = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("Encryption")) {
                    this.encryption = (EncryptionType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("EntropyAlgorithm")) {
                    this.encryptionAlgorithm = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("CanonicalizationAlgorithm")) {
                    this.canonicalizationAlgorithm = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("KeyWrapAlgorithm")) {
                    this.keyWrapAlgorithm = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("ProofEncryption")) {
                    this.proofEncryption = (ProofEncryptionType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("UseKey")) {
                    this.useKey = (UseKeyType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("SignWith")) {
                    this.signWith = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("EncryptWith")) {
                    this.encryptWith = URI.create((String)element.getValue());
                    continue;
                }
                if (localName.equalsIgnoreCase("DelegateTo")) {
                    this.delegateTo = (DelegateToType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Forwardable")) {
                    this.forwardable = (Boolean)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("Delegatable")) {
                    this.delegatable = (Boolean)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("CancelTarget")) {
                    this.cancelTarget = (CancelTargetType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("RenewTarget")) {
                    this.renewTarget = (RenewTargetType)element.getValue();
                    continue;
                }
                if (localName.equalsIgnoreCase("ValidateTarget")) {
                    this.validateTarget = (ValidateTargetType)element.getValue();
                    continue;
                }
                this.extensionElements.add(element.getValue());
                continue;
            }
            this.extensionElements.add(obj);
        }
    }

    public RequestSecurityToken(RequestSecurityTokenType delegate, Document rstDocument) {
        this(delegate);
        this.rstDocument = rstDocument;
    }

    public URI getBinaryValueType() {
        return this.binaryValueType;
    }

    public void setBinaryValueType(URI binaryValueType) {
        this.binaryValueType = binaryValueType;
    }

    public Node getBinaryToken() {
        return this.binaryToken;
    }

    public void setBinaryToken(Node binaryToken) {
        this.binaryToken = binaryToken;
    }

    public URI getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(URI tokenType) {
        this.tokenType = tokenType;
        this.delegate.addAny(tokenType.toString());
    }

    public URI getRequestType() {
        return this.requestType;
    }

    public void setRequestType(URI requestType) {
        this.requestType = requestType;
        this.delegate.addAny(requestType.toString());
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(AppliesTo appliesTo) {
        this.appliesTo = appliesTo;
        this.delegate.addAny(appliesTo);
    }

    public ClaimsType getClaims() {
        return this.claims;
    }

    public void setClaims(ClaimsType claims) {
        this.claims = claims;
        this.delegate.addAny(claims);
    }

    public EntropyType getEntropy() {
        return this.entropy;
    }

    public void setEntropy(EntropyType entropy) {
        this.entropy = entropy;
        this.delegate.addAny(entropy);
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(Lifetime lifetime) {
        this.lifetime = lifetime;
        this.delegate.addAny(lifetime.getDelegate());
    }

    public AllowPostdatingType getAllowPostDating() {
        return this.allowPostDating;
    }

    public void setAllowPostDating(AllowPostdatingType allowPostDating) {
        this.allowPostDating = allowPostDating;
        this.delegate.addAny(allowPostDating);
    }

    public RenewingType getRenewing() {
        return this.renewing;
    }

    public void setRenewing(RenewingType renewing) {
        this.renewing = renewing;
        this.delegate.addAny(renewing);
    }

    public OnBehalfOfType getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public void setOnBehalfOf(OnBehalfOfType onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        this.delegate.addAny(onBehalfOf);
    }

    public EndpointReferenceType getIssuer() {
        return this.issuer;
    }

    public void setIssuer(EndpointReferenceType issuer) {
        this.issuer = issuer;
        this.delegate.addAny(issuer);
    }

    public URI getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(URI authenticationType) {
        this.authenticationType = authenticationType;
        this.delegate.addAny(authenticationType.toString());
    }

    public URI getKeyType() {
        return this.keyType;
    }

    public void setKeyType(URI keyType) {
        this.keyType = keyType;
        this.delegate.addAny(keyType.toString());
    }

    public long getKeySize() {
        return this.keySize;
    }

    public void setKeySize(long keySize) {
        this.keySize = keySize;
        this.delegate.addAny(keySize);
    }

    public URI getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(URI signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.delegate.addAny(signatureAlgorithm.toString());
    }

    public EncryptionType getEncryption() {
        return this.encryption;
    }

    public void setEncryption(EncryptionType encryption) {
        this.encryption = encryption;
        this.delegate.addAny(encryption);
    }

    public URI getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(URI encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.delegate.addAny(encryptionAlgorithm.toString());
    }

    public URI getCanonicalizationAlgorithm() {
        return this.canonicalizationAlgorithm;
    }

    public void setCanonicalizationAlgorithm(URI canonicalizationAlgorithm) {
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
        this.delegate.addAny(canonicalizationAlgorithm.toString());
    }

    public URI getKeyWrapAlgorithm() {
        return this.keyWrapAlgorithm;
    }

    public void setKeyWrapAlgorithm(URI keyWrapAlgorithm) {
        this.keyWrapAlgorithm = keyWrapAlgorithm;
    }

    public ProofEncryptionType getProofEncryption() {
        return this.proofEncryption;
    }

    public void setProofEncryption(ProofEncryptionType proofEncryption) {
        this.proofEncryption = proofEncryption;
        this.delegate.addAny(proofEncryption);
    }

    public UseKeyType getUseKey() {
        return this.useKey;
    }

    public void setUseKey(UseKeyType useKey) {
        this.useKey = useKey;
        this.delegate.addAny(useKey);
    }

    public URI getSignWith() {
        return this.signWith;
    }

    public void setSignWith(URI signWith) {
        this.signWith = signWith;
        this.delegate.addAny(signWith.toString());
    }

    public URI getEncryptWith() {
        return this.encryptWith;
    }

    public void setEncryptWith(URI encryptWith) {
        this.encryptWith = encryptWith;
        this.delegate.addAny(encryptWith.toString());
    }

    public DelegateToType getDelegateTo() {
        return this.delegateTo;
    }

    public void setDelegateTo(DelegateToType delegateTo) {
        this.delegateTo = delegateTo;
        this.delegate.addAny(delegateTo);
    }

    public boolean isForwardable() {
        return this.forwardable;
    }

    public void setForwardable(boolean forwardable) {
        this.forwardable = forwardable;
        this.delegate.addAny(forwardable);
    }

    public boolean isDelegatable() {
        return this.delegatable;
    }

    public void setDelegatable(boolean delegatable) {
        this.delegatable = delegatable;
        this.delegate.addAny(delegatable);
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
        this.delegate.addAny(policy);
    }

    public PolicyReference getPolicyReference() {
        return this.policyReference;
    }

    public void setPolicyReference(PolicyReference policyReference) {
        this.policyReference = policyReference;
        this.delegate.addAny(policyReference);
    }

    public List<Object> getExtensionElements() {
        return Collections.unmodifiableList(this.extensionElements);
    }

    public String getContext() {
        return this.delegate.getContext();
    }

    public void setContext(String context) {
        this.delegate.setContext(context);
    }

    public CancelTargetType getCancelTarget() {
        return this.cancelTarget;
    }

    public void setCancelTarget(CancelTargetType cancelTarget) {
        this.cancelTarget = cancelTarget;
        this.delegate.addAny(cancelTarget);
    }

    public RenewTargetType getRenewTarget() {
        return this.renewTarget;
    }

    public void setRenewTarget(RenewTargetType renewTarget) {
        this.renewTarget = renewTarget;
        this.delegate.addAny(renewTarget);
    }

    public ValidateTargetType getValidateTarget() {
        return this.validateTarget;
    }

    public Element getValidateTargetElement() {
        if (this.rstDocument == null) {
            throw new IllegalStateException("PL00092: Null Value:RST Document");
        }
        String ns = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        String localPart = "ValidateTarget";
        NodeList nodeList = this.rstDocument.getElementsByTagNameNS(ns, localPart);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public Element getRenewTargetElement() {
        if (this.rstDocument == null) {
            throw new IllegalStateException("PL00092: Null Value:RST Document");
        }
        String ns = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        String localName = "RenewTarget";
        NodeList nodeList = this.rstDocument.getElementsByTagNameNS(ns, localName);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public Element getCancelTargetElement() {
        if (this.rstDocument == null) {
            throw new IllegalStateException("PL00092: Null Value:RST Document");
        }
        String ns = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        String localName = "CancelTarget";
        NodeList nodeList = this.rstDocument.getElementsByTagNameNS(ns, localName);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public void setValidateTarget(ValidateTargetType validateTarget) {
        this.validateTarget = validateTarget;
        this.delegate.addAny(validateTarget);
    }

    public Map<QName, String> getOtherAttributes() {
        return this.delegate.getOtherAttributes();
    }

    public List<Object> getAny() {
        return this.delegate.getAny();
    }

    public RequestSecurityTokenType getDelegate() {
        return this.delegate;
    }

    public Document getRSTDocument() {
        return this.rstDocument;
    }

    public void setRSTDocument(Document rstDocument) {
        this.rstDocument = rstDocument;
    }

    public void addExtensionElement(Object element) {
        this.extensionElements.add(element);
    }

    public String toString() {
        return "RequestSecurityToken [delegate=" + this.delegate + ", tokenType=" + this.tokenType + ", requestType=" + this.requestType + ", appliesTo=" + this.appliesTo + ", claims=" + this.claims + ", entropy=" + this.entropy + ", lifetime=" + this.lifetime + ", allowPostDating=" + this.allowPostDating + ", renewing=" + this.renewing + ", onBehalfOf=" + this.onBehalfOf + ", issuer=" + this.issuer + ", authenticationType=" + this.authenticationType + ", keyType=" + this.keyType + ", keySize=" + this.keySize + ", signatureAlgorithm=" + this.signatureAlgorithm + ", encryption=" + this.encryption + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ", canonicalizationAlgorithm=" + this.canonicalizationAlgorithm + ", keyWrapAlgorithm=" + this.keyWrapAlgorithm + ", proofEncryption=" + this.proofEncryption + ", useKey=" + this.useKey + ", signWith=" + this.signWith + ", encryptWith=" + this.encryptWith + ", delegateTo=" + this.delegateTo + ", forwardable=" + this.forwardable + ", delegatable=" + this.delegatable + ", policy=" + this.policy + ", policyReference=" + this.policyReference + ", validateTarget=" + this.validateTarget + ", renewTarget=" + this.renewTarget + ", cancelTarget=" + this.cancelTarget + ", extensionElements=" + this.extensionElements + ", rstDocument=" + this.rstDocument + "]";
    }
}

